/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtext.builder.trace.IStorageAwareTraceContribution;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperJdtExtensions;
import org.eclipse.xtext.util.Pair;

public class JarEntryAwareTrace
implements IStorageAwareTraceContribution {
    private static final Logger log = Logger.getLogger(JarEntryAwareTrace.class);
    @Inject
    private IStorage2UriMapperJdtExtensions uriMapperExtensions;

    public URI tryResolvePath(IStorage localStorage, URI path) {
        if (localStorage instanceof IFile) {
            IProject project = ((IFile)localStorage).getProject();
            if (project != null) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                if (javaProject != null && javaProject.exists()) {
                    return this.resolvePath(javaProject, path);
                }
                return null;
            }
        } else if (localStorage instanceof IJarEntryResource) {
            return this.resolvePath((IJarEntryResource)localStorage, path);
        }
        return null;
    }

    protected URI resolvePath(IJarEntryResource jarEntry, URI path) {
        IPackageFragmentRoot packageFragmentRoot = jarEntry.getPackageFragmentRoot();
        try {
            URI first;
            Pair pair = this.uriMapperExtensions.getURIMapping(packageFragmentRoot);
            if (pair != null && (first = (URI)pair.getFirst()) != null) {
                return URI.createURI((String)(first + "/" + path));
            }
        }
        catch (JavaModelException e) {
            log.error((Object)e);
        }
        return path;
    }

    protected URI resolvePath(IJavaProject javaProject, URI path) {
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFolder folder;
                IResource candidate;
                IResource resource;
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (root.getKind() == 1 && (resource = root.getResource()) instanceof IFolder && (candidate = (folder = (IFolder)resource).findMember(path.toString())) != null && candidate.exists()) {
                    return URI.createPlatformResourceURI((String)(resource.getFullPath() + "/" + path), (boolean)true);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            log.error((Object)e);
        }
        return null;
    }
}

