/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendImport;
import org.eclipse.xtend.ide.labeling.XtendImages;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.ui.labeling.XbaseLabelProvider;
import org.eclipse.xtext.xbase.validation.UIStrings;

public class XtendLabelProvider
extends XbaseLabelProvider {
    @Inject
    private UIStrings uiStrings;
    @Inject
    private XtendImages images;
    @Inject
    private IXtendJvmAssociations associations;

    @Inject
    public XtendLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    public Image image(XtendFile element) {
        return this.images.forFile();
    }

    public Image image(XtendImport element) {
        return this.images.forImport();
    }

    public Image image(XtendClass element) {
        JvmGenericType inferredType = this.associations.getInferredType(element);
        return this.images.forClass(inferredType.getVisibility());
    }

    public Image image(XtendFunction element) {
        JvmOperation inferredOperation = this.associations.getDirectlyInferredOperation(element);
        return this.images.forOperation(inferredOperation.getVisibility(), inferredOperation.isStatic());
    }

    public Image image(XtendConstructor element) {
        JvmConstructor inferredConstructor = this.associations.getInferredConstructor(element);
        return this.images.forConstructor(inferredConstructor.getVisibility());
    }

    public Image image(XtendField element) {
        JvmField inferredField = this.associations.getJvmField(element);
        return this.images.forField(inferredField.getVisibility(), inferredField.isStatic(), element.isExtension());
    }

    public String text(XtendFile element) {
        return element.eResource().getURI().trimFileExtension().lastSegment();
    }

    public String text(XtendImport element) {
        return element.getImportedNamespace();
    }

    public String text(XtendClass element) {
        return String.valueOf(element.getName()) + (element.getTypeParameters().isEmpty() ? "" : this.uiStrings.typeParameters((Iterable)element.getTypeParameters()));
    }

    public String text(XtendConstructor element) {
        return "new" + this.uiStrings.parameters((JvmIdentifiableElement)this.associations.getInferredConstructor(element));
    }

    public Object text(XtendFunction element) {
        return this.signature(element.getName(), (JvmIdentifiableElement)this.associations.getDirectlyInferredOperation(element));
    }

    public String text(XtendField element) {
        JvmTypeReference type;
        if (element.getName() == null && element.isExtension()) {
            return element.getType().getSimpleName();
        }
        JvmField jvmField = this.associations.getJvmField(element);
        if (jvmField != null && (type = jvmField.getType()) != null) {
            return String.valueOf(element.getName()) + " : " + type.getSimpleName();
        }
        return element.getName();
    }
}

