/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.smap;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.internal.core.Region;
import org.eclipse.xtext.generator.trace.ITraceInformation;
import org.eclipse.xtext.generator.trace.SmapSupport;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.util.Files;

public class SmapInstallingCompilationParticipant
extends CompilationParticipant {
    private static final Logger log = Logger.getLogger(SmapInstallingCompilationParticipant.class);
    @Inject
    private ITraceInformation traceInformation;
    @Inject
    private IResourceServiceProvider.Registry serviceProviderRegistry;
    @Inject
    private SmapSupport smapSupport;
    private List<BuildContext> files;

    public boolean isActive(IJavaProject project) {
        return XtextProjectHelper.hasNature((IProject)project.getProject());
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
        super.buildStarting(files, isBatch);
        if (this.files != null) {
            this.files.addAll(Arrays.asList(files));
        } else {
            this.files = Lists.newArrayList((Object[])files);
        }
    }

    public void buildFinished(IJavaProject project) {
        try {
            super.buildFinished(project);
            if (this.files == null) {
                return;
            }
            for (BuildContext ctx : this.files) {
                try {
                    IFile smapFile;
                    IJavaElement element = JavaCore.create((IFile)ctx.getFile());
                    if (element == null || !element.exists() || (smapFile = this.findSmapFile(ctx)) == null || !smapFile.exists()) continue;
                    try {
                        try {
                            String smapAsString = Files.readStreamIntoString((InputStream)smapFile.getContents());
                            Region region = new Region();
                            region.add(element);
                            this.installSmapInformation(smapAsString, JavaCore.getGeneratedResources((IRegion)region, (boolean)false));
                        }
                        catch (Exception e) {
                            log.error((Object)String.format("Could not read and install smap information from %s: %s", smapFile.getFullPath().toString(), e.getMessage()), (Throwable)e);
                            try {
                                smapFile.delete(true, null);
                            }
                            catch (CoreException e2) {
                                log.error((Object)e2.getMessage(), (Throwable)e2);
                            }
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            smapFile.delete(true, null);
                        }
                        catch (CoreException e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        smapFile.delete(true, null);
                    }
                    catch (CoreException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    log.error((Object)String.format("Could not process %s to install smap information: %s", ctx.getFile().getFullPath().toString(), e.getMessage()), (Throwable)e);
                }
            }
        }
        finally {
            this.files = null;
        }
    }

    protected void installSmapInformation(String smap, IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFile) {
                this.installSmapInformation(smap, (IFile)res);
            }
            ++n2;
        }
    }

    protected void installSmapInformation(String smap, IFile compiledFile) {
        try {
            InputStream newByteCode = this.smapSupport.getModifiedByteCode(smap, compiledFile.getContents());
            compiledFile.setContents(newByteCode, 2, null);
        }
        catch (Exception e) {
            log.error((Object)String.format("Could not install smap information into %s: %s", compiledFile.getFullPath().toString(), e.getMessage()), (Throwable)e);
        }
    }

    protected IFile findSmapFile(BuildContext ctx) {
        IFile compiledFile = ctx.getFile();
        IPath smapPath = compiledFile.getFullPath().removeFileExtension().addFileExtension("smap");
        IContainer container = compiledFile.getParent();
        IFile result = container.getFile(smapPath.removeFirstSegments(smapPath.segmentCount() - 1));
        return result;
    }
}

