/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.preferences;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.eclipse.xtext.builder.preferences.IStatusChangeListener;
import org.eclipse.xtext.builder.preferences.Messages;
import org.eclipse.xtext.builder.preferences.ProjectSelectionDialog;
import org.eclipse.xtext.builder.preferences.StatusInfo;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.DialogField;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.IDialogFieldListener;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.LayoutUtil;
import org.eclipse.xtext.ui.editor.tasks.dialogfields.SelectionButtonDialogField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyAndPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";
    private Control configurationBlockControl;
    private ControlEnableState blockEnableState = null;
    private Link changeWorkspaceSettings;
    private SelectionButtonDialogField useProjectSettings;
    private IStatus blockStatus = new StatusInfo();
    private Composite parentComposite;
    private IProject project = null;
    private Map<Object, Object> pageData = null;

    protected abstract Control createPreferenceContent(Composite var1, IPreferencePageContainer var2);

    protected abstract boolean hasProjectSpecificOptions(IProject var1);

    protected abstract String getPreferencePageID();

    protected abstract String getPropertyPageID();

    protected boolean supportsProjectSpecificOptions() {
        return this.getPropertyPageID() != null;
    }

    protected boolean offerLink() {
        return this.pageData == null || !Boolean.TRUE.equals(this.pageData.get(DATA_NO_LINK));
    }

    protected Label createDescriptionLabel(Composite parent) {
        this.parentComposite = parent;
        if (this.isProjectPreferencePage()) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            IDialogFieldListener listener = new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField field) {
                    boolean enabled = ((SelectionButtonDialogField)field).isSelected();
                    PropertyAndPreferencePage.this.enableProjectSpecificSettings(enabled);
                    if (enabled && PropertyAndPreferencePage.this.getData() != null) {
                        PropertyAndPreferencePage.this.applyData(PropertyAndPreferencePage.this.getData());
                    }
                }
            };
            this.useProjectSettings = new SelectionButtonDialogField(32);
            this.useProjectSettings.setDialogFieldListener(listener);
            this.useProjectSettings.setLabelText(Messages.PropertyAndPreferencePage_useprojectsettings_label);
            this.useProjectSettings.doFillIntoGrid(composite, 1);
            LayoutUtil.setHorizontalGrabbing((Control)this.useProjectSettings.getSelectionButton(null));
            if (this.offerLink()) {
                this.changeWorkspaceSettings = this.createLink(composite, Messages.PropertyAndPreferencePage_useworkspacesettings_change);
                this.changeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            } else {
                LayoutUtil.setHorizontalSpan((Control)this.useProjectSettings.getSelectionButton(null), (int)2);
            }
            Label horizontalLine = new Label(composite, 258);
            horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            horizontalLine.setFont(composite.getFont());
        } else if (this.supportsProjectSpecificOptions() && this.offerLink()) {
            this.changeWorkspaceSettings = this.createLink(parent, Messages.PropertyAndPreferencePage_showprojectspecificsettings_label);
            this.changeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        }
        return super.createDescriptionLabel(parent);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData data = new GridData(4, 4, true, true);
        this.configurationBlockControl = this.createPreferenceContent(composite, this.getContainer());
        this.configurationBlockControl.setLayoutData((Object)data);
        if (this.isProjectPreferencePage()) {
            boolean useProjectSettings = this.hasProjectSpecificOptions(this.getProject());
            this.enableProjectSpecificSettings(useProjectSettings);
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertyAndPreferencePage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertyAndPreferencePage.this.doLinkActivated((Link)e.widget);
            }
        });
        return link;
    }

    protected boolean useProjectSettings() {
        return this.isProjectPreferencePage() && this.useProjectSettings != null && this.useProjectSettings.isSelected();
    }

    protected boolean isProjectPreferencePage() {
        return this.project != null;
    }

    protected IProject getProject() {
        return this.project;
    }

    final void doLinkActivated(Link link) {
        Map<Object, Object> data = this.getData();
        if (data == null) {
            data = new HashMap<Object, Object>();
        }
        data.put(DATA_NO_LINK, Boolean.TRUE);
        if (this.isProjectPreferencePage()) {
            this.openWorkspacePreferences(data);
        } else {
            IProject[] projects;
            HashSet projectsWithSpecifics = Sets.newHashSet();
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (XtextProjectHelper.hasNature((IProject)project) && this.hasProjectSpecificOptions(project)) {
                    projectsWithSpecifics.add(project);
                }
                ++n2;
            }
            ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell(), projectsWithSpecifics);
            if (dialog.open() == 0) {
                IProject project = (IProject)dialog.getFirstResult();
                this.openProjectProperties(project, data);
            }
        }
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    protected final void openProjectProperties(IProject project, Object data) {
        String id = this.getPropertyPageID();
        if (id != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, (Object)data).open();
        }
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        this.useProjectSettings.setSelection(useProjectSpecificSettings);
        this.enablePreferenceContent(useProjectSpecificSettings);
        this.updateLinkVisibility();
        this.doStatusChanged();
    }

    private void updateLinkVisibility() {
        if (this.changeWorkspaceSettings == null || this.changeWorkspaceSettings.isDisposed()) {
            return;
        }
        if (this.isProjectPreferencePage()) {
            this.changeWorkspaceSettings.setEnabled(!this.useProjectSettings());
        }
    }

    protected void setPreferenceContentStatus(IStatus status) {
        this.blockStatus = status;
        this.doStatusChanged();
    }

    protected IStatusChangeListener getNewStatusChangedListener() {
        return new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
                PropertyAndPreferencePage.this.setPreferenceContentStatus(status);
            }
        };
    }

    protected IStatus getPreferenceContentStatus() {
        return this.blockStatus;
    }

    protected void doStatusChanged() {
        if (!this.isProjectPreferencePage() || this.useProjectSettings()) {
            this.updateStatus(this.blockStatus);
        } else {
            this.updateStatus(new StatusInfo());
        }
    }

    protected void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this.blockEnableState != null) {
                this.blockEnableState.restore();
                this.blockEnableState = null;
            }
        } else if (this.blockEnableState == null) {
            this.blockEnableState = ControlEnableState.disable((Control)this.configurationBlockControl);
        }
    }

    protected void performDefaults() {
        if (this.useProjectSettings()) {
            this.enableProjectSpecificSettings(false);
        }
        super.performDefaults();
    }

    private void updateStatus(IStatus status) {
        this.setValid(!status.matches(4));
        PropertyAndPreferencePage.applyToStatusLine((DialogPage)this, status);
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = (IProject)element.getAdapter(IResource.class);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            this.pageData = (Map)data;
        }
        if (this.changeWorkspaceSettings != null && !this.offerLink()) {
            this.changeWorkspaceSettings.dispose();
            this.parentComposite.layout(true, true);
        }
    }

    protected Map<Object, Object> getData() {
        return this.pageData;
    }

    protected IWorkingCopyManager getWorkingCopyManager() {
        IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
        Object manager = container == null ? new WorkingCopyManager() : container.getWorkingCopyManager();
        return manager;
    }

    private static void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        if (message != null && message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }
}

