/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.imports.TypeUsages;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.scoping.batch.ImplicitlyImportedTypes;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.util.FeatureCallAsTypeLiteralHelper;
import org.eclipse.xtext.xtype.XFunctionTypeRef;

public class TypeUsageCollector {
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private ImplicitlyImportedTypes implicitImports;
    @Inject
    private SuperTypeCollector superTypeCollector;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    @Inject
    private IJavaDocTypeReferenceProvider javaDocTypeReferenceProvider;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TypeUsages typeUsages;
    @Inject
    private IBatchTypeResolver batchTypeResolver;
    @Inject
    private FeatureCallAsTypeLiteralHelper typeLiteralHelper;
    private JvmDeclaredType currentThisType;
    private JvmMember currentContext;
    private XtextResource resource;
    private List<JvmType> implicitStaticImports;
    private List<JvmType> implicitExtensionImports;
    private Set<JvmType> knownTypesForStaticImports;
    private IEObjectDocumentationProviderExtension documentationProvider;

    @Inject
    private void setDocumentationProvider(IEObjectDocumentationProvider documentationProvider) {
        if (documentationProvider instanceof IEObjectDocumentationProviderExtension) {
            this.documentationProvider = (IEObjectDocumentationProviderExtension)documentationProvider;
        }
    }

    public TypeUsages collectTypeUsages(XtextResource resource) {
        if (resource != null && !resource.getContents().isEmpty()) {
            this.resource = resource;
            this.implicitStaticImports = this.implicitImports.getStaticImportClasses((Resource)resource);
            this.implicitExtensionImports = this.implicitImports.getExtensionClasses((Resource)resource);
            this.collectAllReferences((EObject)resource.getContents().get(0));
        }
        return this.typeUsages;
    }

    protected void collectAllReferences(EObject rootElement) {
        TreeIterator contents = EcoreUtil.getAllContents((EObject)rootElement, (boolean)true);
        while (contents.hasNext()) {
            EObject firstJvmElement;
            XAbstractFeatureCall featureCall;
            EObject next = (EObject)contents.next();
            if (next instanceof JvmTypeReference) {
                this.acceptType((JvmTypeReference)next);
                continue;
            }
            if (next instanceof XAnnotation) {
                this.acceptPreferredType(next, XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE);
                continue;
            }
            if (next instanceof XConstructorCall) {
                this.acceptPreferredType(next, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR);
                continue;
            }
            if (next instanceof XTypeLiteral) {
                this.acceptPreferredType(next, XbasePackage.Literals.XTYPE_LITERAL__TYPE);
                continue;
            }
            if (next instanceof XFeatureCall) {
                featureCall = (XFeatureCall)next;
                if (featureCall.getFeature() instanceof JvmType && featureCall.isTypeLiteral()) {
                    if (this.isOuterTypeLiteral(featureCall)) {
                        contents.prune();
                        continue;
                    }
                    this.acceptPreferredType(featureCall, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
                    continue;
                }
                if (featureCall.getFeature().eIsProxy()) {
                    this.acceptPreferredType(featureCall, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
                    continue;
                }
                this.collectStaticImportsFrom(featureCall);
                continue;
            }
            if (next instanceof XMemberFeatureCall) {
                XExpression target;
                featureCall = (XMemberFeatureCall)next;
                if (featureCall.getFeature() instanceof JvmType && featureCall.isTypeLiteral()) {
                    if (this.isOuterTypeLiteral(featureCall)) {
                        contents.prune();
                        continue;
                    }
                    this.acceptPreferredType(featureCall, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
                }
                if (featureCall.isExplicitStatic() || this.isTypeLiteral(target = featureCall.getMemberCallTarget())) continue;
                this.collectStaticImportsFrom((XAbstractFeatureCall)next);
                continue;
            }
            if (next instanceof XBinaryOperation || next instanceof XUnaryOperation || next instanceof XAssignment && !Iterables.contains((Iterable)this.currentThisType.getAllFeatures(), (Object)((XAssignment)next).getFeature())) {
                this.collectStaticImportsFrom((XAbstractFeatureCall)next);
                continue;
            }
            Set<EObject> elements = this.associations.getJvmElements(next);
            if (!elements.isEmpty() && (firstJvmElement = elements.iterator().next()) instanceof JvmMember) {
                JvmDeclaredType declaringType;
                JvmDeclaredType jvmDeclaredType = declaringType = firstJvmElement instanceof JvmDeclaredType ? (JvmDeclaredType)firstJvmElement : ((JvmMember)firstJvmElement).getDeclaringType();
                if (this.currentThisType != declaringType) {
                    this.currentThisType = declaringType;
                    this.knownTypesForStaticImports = null;
                }
                this.currentContext = (JvmMember)firstJvmElement;
            }
            this.addJavaDocReferences(next);
        }
    }

    private boolean isOuterTypeLiteral(XAbstractFeatureCall featureCall) {
        XMemberFeatureCall container;
        return featureCall.eContainingFeature() == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET && (container = (XMemberFeatureCall)featureCall.eContainer()).isTypeLiteral();
    }

    private boolean isTypeLiteral(XExpression memberCallTarget) {
        if (memberCallTarget instanceof XAbstractFeatureCall) {
            return ((XAbstractFeatureCall)memberCallTarget).isTypeLiteral();
        }
        return false;
    }

    private void collectStaticImportsFrom(XAbstractFeatureCall featureCall) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        if ((feature instanceof JvmOperation || feature instanceof JvmField) && featureCall.isStatic()) {
            if (featureCall.isExtension()) {
                this.acceptStaticExtensionImport((JvmMember)feature);
            } else {
                this.acceptStaticImport((JvmMember)feature);
            }
        }
    }

    protected void addJavaDocReferences(EObject element) {
        if (element != null && this.documentationProvider != null && this.currentThisType != null) {
            for (INode documentationNode : this.documentationProvider.getDocumentationNodes(element)) {
                for (ReplaceRegion docTypeReference : this.javaDocTypeReferenceProvider.computeTypeRefRegions(documentationNode)) {
                    JvmType referencedType;
                    String docTypeText = docTypeReference.getText();
                    JvmTypeReference typeRef = this.typeReferences.getTypeForName(docTypeText, (Notifier)this.currentThisType, new JvmTypeReference[0]);
                    TextRegion textRegion = new TextRegion(docTypeReference.getOffset(), docTypeReference.getLength());
                    JvmType jvmType = referencedType = typeRef != null ? typeRef.getType() : null;
                    if (referencedType instanceof JvmDeclaredType && !referencedType.eIsProxy()) {
                        JvmDeclaredType casted = (JvmDeclaredType)referencedType;
                        this.typeUsages.addTypeUsage(casted, casted, (ITextRegion)textRegion, (JvmMember)this.currentThisType);
                        continue;
                    }
                    this.typeUsages.addUnresolved(docTypeText, "", (ITextRegion)textRegion, (JvmMember)this.currentThisType);
                }
            }
        }
    }

    protected void acceptType(JvmTypeReference ref) {
        if (ref instanceof XFunctionTypeRef || ref instanceof JvmWildcardTypeReference || ref.eContainer() instanceof XFunctionTypeRef && ref.eContainmentFeature() == TypesPackage.Literals.JVM_SPECIALIZED_TYPE_REFERENCE__EQUIVALENT || NodeModelUtils.findActualNodeFor((EObject)ref) == null) {
            return;
        }
        this.acceptPreferredType(ref);
    }

    protected void acceptPreferredType(JvmTypeReference ref) {
        if (ref instanceof JvmParameterizedTypeReference) {
            this.acceptPreferredType((EObject)ref, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
        } else {
            this.acceptType(ref.getType(), this.locationInFileProvider.getFullTextRegion((EObject)ref));
        }
    }

    protected PreferredType findPreferredType(EObject owner, EReference reference, String text) {
        JvmIdentifiableElement potentiallyLinkedType;
        JvmIdentifiableElement referencedThing = (JvmIdentifiableElement)owner.eGet((EStructuralFeature)reference);
        if (referencedThing != null && owner instanceof XConstructorCall && referencedThing.eIsProxy() && (potentiallyLinkedType = this.batchTypeResolver.resolveTypes(owner).getLinkedFeature((XConstructorCall)owner)) != null && !potentiallyLinkedType.eIsProxy()) {
            referencedThing = potentiallyLinkedType;
        }
        JvmDeclaredType referencedType = null;
        if (referencedThing instanceof JvmDeclaredType) {
            referencedType = (JvmDeclaredType)referencedThing;
        } else if (referencedThing instanceof JvmMember) {
            referencedType = ((JvmMember)referencedThing).getDeclaringType();
        } else if (referencedThing instanceof JvmType) {
            if (referencedThing.eIsProxy()) {
                String importedName = this.getFirstNameSegment(owner, reference);
                return new PreferredType(importedName);
            }
            return null;
        }
        return this.findPreferredType(referencedType, text);
    }

    private String getFirstNameSegment(EObject owner, EReference reference) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)owner, (EStructuralFeature)reference);
        if (nodes.size() == 1) {
            String text = NodeModelUtils.getTokenText((INode)((INode)nodes.get(0)));
            return this.getFirstNameSegment(text);
        }
        throw new IllegalStateException("Cannot find node for feature");
    }

    protected String getFirstNameSegment(String text) {
        int firstDelimiter = text.indexOf(46);
        if (firstDelimiter == -1) {
            firstDelimiter = text.indexOf(36);
        } else {
            int dollar = text.indexOf(36);
            if (dollar != -1) {
                firstDelimiter = Math.min(firstDelimiter, dollar);
            }
        }
        if (firstDelimiter == -1) {
            firstDelimiter = text.indexOf("::");
            if (firstDelimiter == text.length() - 2 && firstDelimiter >= 0) {
                text = text.substring(0, firstDelimiter);
                firstDelimiter = -1;
            }
        } else {
            int colon = text.indexOf("::");
            if (colon != text.length() - 2 && colon != -1) {
                firstDelimiter = Math.min(firstDelimiter, colon);
            }
        }
        if (firstDelimiter != -1) {
            return text.substring(0, firstDelimiter);
        }
        return text;
    }

    private PreferredType findPreferredType(JvmDeclaredType referencedType, String text) {
        if (referencedType != null && !referencedType.eIsProxy()) {
            if (referencedType.getDeclaringType() == null) {
                return new PreferredType((JvmType)referencedType, (JvmType)referencedType);
            }
            String outerSegment = this.getFirstNameSegment(text);
            JvmDeclaredType outerType = this.findDeclaringTypeBySimpleName(referencedType, outerSegment);
            if (outerType == null) {
                throw new IllegalStateException();
            }
            return new PreferredType((JvmType)outerType, (JvmType)referencedType);
        }
        String name = this.getFirstNameSegment(text);
        return new PreferredType(name);
    }

    private JvmDeclaredType findDeclaringTypeBySimpleName(JvmDeclaredType referencedType, String outerSegment) {
        if (referencedType.getDeclaringType() == null || outerSegment.equals(referencedType.getSimpleName())) {
            return referencedType;
        }
        return this.findDeclaringTypeBySimpleName(referencedType.getDeclaringType(), outerSegment);
    }

    protected void acceptPreferredType(EObject owner, EReference referenceToTypeOrMember) {
        String completeText;
        String refText;
        PreferredType preferredType;
        ITextRegion refRegion = this.locationInFileProvider.getFullTextRegion(owner, (EStructuralFeature)referenceToTypeOrMember, 0);
        IParseResult parseResult = this.resource.getParseResult();
        if (parseResult != null && (preferredType = this.findPreferredType(owner, referenceToTypeOrMember, refText = (completeText = parseResult.getRootNode().getText()).substring(refRegion.getOffset(), refRegion.getOffset() + refRegion.getLength()))) != null) {
            if (preferredType.referencedType != null) {
                this.acceptType(preferredType.referencedType, preferredType.usedType, refRegion);
            } else {
                ITextRegion region;
                XAbstractFeatureCall root;
                XFeatureCall featureCall;
                String suffix = refText.substring(preferredType.unresolvedTypeName.length());
                if (owner instanceof XFeatureCall && this.typeLiteralHelper.isPotentialTypeLiteral(featureCall = (XFeatureCall)owner, null) && (root = this.typeLiteralHelper.getRootTypeLiteral(featureCall)) != null && (region = this.locationInFileProvider.getSignificantTextRegion((EObject)root)).getOffset() == refRegion.getOffset()) {
                    suffix = completeText.substring(region.getOffset(), region.getOffset() + region.getLength());
                    suffix = suffix.substring(preferredType.unresolvedTypeName.length());
                    refRegion = region;
                }
                this.acceptUnresolvedType(preferredType.unresolvedTypeName, suffix, refRegion);
            }
        }
    }

    protected void acceptType(JvmType type, ITextRegion refRegion) {
        this.acceptType(type, type, refRegion);
    }

    protected void acceptType(JvmType type, JvmType usedType, ITextRegion refRegion) {
        if (this.currentContext != null) {
            if (type == null || type.eIsProxy()) {
                throw new IllegalArgumentException();
            }
            if (type instanceof JvmDeclaredType) {
                this.typeUsages.addTypeUsage((JvmDeclaredType)type, (JvmDeclaredType)usedType, refRegion, this.currentContext);
            }
        }
    }

    protected void acceptUnresolvedType(String usedTypeName, String suffix, ITextRegion refRegion) {
        if (this.currentContext != null) {
            this.typeUsages.addUnresolved(usedTypeName, suffix, refRegion, this.currentContext);
        }
    }

    protected void acceptStaticImport(JvmMember member) {
        JvmDeclaredType declarator = member.getDeclaringType();
        if (!this.needsStaticImport(declarator) || this.implicitStaticImports.contains(declarator)) {
            return;
        }
        this.typeUsages.addStaticImport(declarator);
    }

    protected void acceptStaticExtensionImport(JvmMember member) {
        JvmDeclaredType declarator = member.getDeclaringType();
        if (!this.needsStaticImport(declarator) || this.implicitExtensionImports.contains(declarator)) {
            return;
        }
        this.typeUsages.addExtensionImport(declarator);
    }

    protected boolean needsStaticImport(JvmDeclaredType declarator) {
        if (this.currentThisType == declarator) {
            return false;
        }
        if (this.knownTypesForStaticImports == null && this.currentThisType != null) {
            JvmParameterizedTypeReference reference = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            reference.setType((JvmType)this.currentThisType);
            this.knownTypesForStaticImports = this.superTypeCollector.collectSuperTypesAsRawTypes((JvmTypeReference)reference);
        }
        return this.knownTypesForStaticImports == null || !this.knownTypesForStaticImports.contains(declarator);
    }

    protected static class PreferredType {
        public final JvmType referencedType;
        public final JvmType usedType;
        public final String unresolvedTypeName;

        public PreferredType(JvmType referencedType, JvmType usedType) {
            if (referencedType.eIsProxy()) {
                throw new IllegalArgumentException();
            }
            this.referencedType = referencedType;
            this.usedType = usedType;
            this.unresolvedTypeName = null;
        }

        public PreferredType(String name) {
            this.unresolvedTypeName = name;
            this.referencedType = null;
            this.usedType = null;
        }
    }
}

