/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentTokenSource {
    private boolean checkInvariant = false;
    private List<TokenInfo> internalModifyableTokenInfos = Collections.emptyList();
    private List<TokenInfo> tokenInfos = Collections.emptyList();
    private IRegion previousRegion;
    private DocumentEvent previousEvent;
    @Inject
    @Named(value="org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer.HIGHLIGHTING")
    private Provider<Lexer> lexer;

    public Iterable<ILexerTokenRegion> getTokenInfos() {
        return new IRegionIterable(this.tokenInfos);
    }

    public IRegion getLastDamagedRegion() {
        return this.previousRegion;
    }

    public void setLexer(Provider<Lexer> lexer) {
        this.lexer = lexer;
    }

    protected void setTokens(List<TokenInfo> infos) {
        this.internalModifyableTokenInfos = infos;
        this.tokenInfos = Collections.unmodifiableList(Lists.newArrayList(infos));
    }

    protected List<TokenInfo> createTokenInfos(String string) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(string.length() / 3));
        Lexer source = this.createLexer(string);
        CommonToken token = (CommonToken)source.nextToken();
        while (token != Token.EOF_TOKEN) {
            TokenInfo info = this.createTokenInfo(token);
            result.add(info);
            token = (CommonToken)source.nextToken();
        }
        return result;
    }

    protected TokenInfo createTokenInfo(CommonToken token) {
        TokenInfo info = new TokenInfo(token);
        return info;
    }

    public void updateStructure(DocumentEvent e) {
        try {
            if (this.previousEvent == e && this.previousRegion != null) {
                return;
            }
            this.previousRegion = this.computeDamageRegion(e);
        }
        finally {
            this.previousEvent = e;
            if (this.isCheckInvariant()) {
                this.doCheckInvariant(e);
            }
        }
    }

    protected void doCheckInvariant(DocumentEvent e) {
        List<TokenInfo> parsedTokenInfos = this.createTokenInfos(e.fDocument.get());
        if (!parsedTokenInfos.equals(this.internalModifyableTokenInfos)) {
            throw new IllegalStateException("Expected: '" + parsedTokenInfos + "' but was: '" + this.internalModifyableTokenInfos + "'.");
        }
    }

    protected IRegion computeDamageRegion(DocumentEvent e) {
        if (e.getDocument().getLength() == 0) {
            this.setTokens(this.createTokenInfos(e.fDocument.get()));
            return new Region(0, 0);
        }
        if (this.internalModifyableTokenInfos.isEmpty()) {
            this.setTokens(this.createTokenInfos(e.fDocument.get()));
            return new Region(0, e.getDocument().getLength());
        }
        try {
            int tokenStartsAt = 0;
            int tokenInfoIdx = 0;
            int regionOffset = 0;
            int regionLength = e.fDocument.getLength();
            Lexer source = this.createLexer(e.fDocument.get());
            CommonToken token = (CommonToken)source.nextToken();
            while (true) {
                TokenInfo tokenInfo;
                if (token == Token.EOF_TOKEN) {
                    this.internalModifyableTokenInfos.subList(tokenInfoIdx, this.internalModifyableTokenInfos.size()).clear();
                    break;
                }
                if (tokenInfoIdx >= this.internalModifyableTokenInfos.size() || (tokenInfo = this.internalModifyableTokenInfos.get(tokenInfoIdx)).type != token.getType() || token.getStopIndex() - token.getStartIndex() + 1 != tokenInfo.length || tokenStartsAt + tokenInfo.length > e.fOffset) break;
                tokenStartsAt += tokenInfo.length;
                ++tokenInfoIdx;
                token = (CommonToken)source.nextToken();
            }
            regionLength -= tokenStartsAt;
            regionOffset = tokenStartsAt;
            int lengthDiff = e.fText.length() - e.fLength;
            while (token != Token.EOF_TOKEN && tokenInfoIdx < this.internalModifyableTokenInfos.size()) {
                while (tokenInfoIdx < this.internalModifyableTokenInfos.size()) {
                    TokenInfo tokenInfo = this.internalModifyableTokenInfos.get(tokenInfoIdx);
                    if (token.getStartIndex() >= e.fOffset + e.fText.length() && tokenStartsAt + lengthDiff == token.getStartIndex() && tokenInfo.type == token.getType() && token.getStopIndex() - token.getStartIndex() + 1 == tokenInfo.length) {
                        Region region = new Region(regionOffset, token.getStartIndex() - regionOffset);
                        return region;
                    }
                    if (tokenStartsAt + lengthDiff + tokenInfo.length > token.getStopIndex() + 1) break;
                    this.internalModifyableTokenInfos.remove(tokenInfoIdx);
                    if ((tokenStartsAt += tokenInfo.length) + lengthDiff <= token.getStartIndex()) continue;
                }
                this.internalModifyableTokenInfos.add(tokenInfoIdx++, this.createTokenInfo(token));
                token = (CommonToken)source.nextToken();
            }
            this.internalModifyableTokenInfos.subList(tokenInfoIdx, this.internalModifyableTokenInfos.size()).clear();
            if (tokenInfoIdx >= this.internalModifyableTokenInfos.size()) {
                while (token != Token.EOF_TOKEN) {
                    this.internalModifyableTokenInfos.add(this.createTokenInfo(token));
                    token = (CommonToken)source.nextToken();
                }
            }
            Region region = new Region(regionOffset, regionLength);
            return region;
        }
        finally {
            this.setTokens(this.internalModifyableTokenInfos);
        }
    }

    protected Lexer createLexer(String string) {
        Lexer l = (Lexer)this.lexer.get();
        l.setCharStream((CharStream)new ANTLRStringStream(string));
        return l;
    }

    public void setCheckInvariant(boolean checkInvariant) {
        this.checkInvariant = checkInvariant;
    }

    public boolean isCheckInvariant() {
        return this.checkInvariant;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IRegionIterable
    implements Iterable<ILexerTokenRegion> {
        private Iterable<TokenInfo> tokens = null;

        public IRegionIterable(Iterable<TokenInfo> tokens) {
            this.tokens = tokens;
        }

        @Override
        public Iterator<ILexerTokenRegion> iterator() {
            return new AbstractIterator<ILexerTokenRegion>(){
                private int offset = 0;
                private Iterator<TokenInfo> infos;
                {
                    this.infos = IRegionIterable.this.tokens.iterator();
                }

                protected ILexerTokenRegion computeNext() {
                    if (!this.infos.hasNext()) {
                        this.endOfData();
                        return null;
                    }
                    TokenInfo next = this.infos.next();
                    try {
                        TokenAdapter tokenAdapter = new TokenAdapter(next, this.offset);
                        return tokenAdapter;
                    }
                    finally {
                        this.offset += next.getLength();
                    }
                }
            };
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IRegionIterable)) {
                return false;
            }
            return this.tokens == ((IRegionIterable)obj).tokens;
        }

        public int hashCode() {
            return System.identityHashCode(this.tokens);
        }
    }

    public static class TokenAdapter
    implements ILexerTokenRegion {
        private TokenInfo token;
        private int offset;

        public TokenAdapter(TokenInfo token, int offset) {
            this.token = token;
            this.offset = offset;
        }

        public int getLength() {
            return this.token.getLength();
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLexerTokenType() {
            return this.token.getAntlrTokenType();
        }
    }

    public static class TokenInfo {
        private final int length;
        private final int type;

        public TokenInfo(CommonToken token) {
            this.length = token.getStopIndex() - token.getStartIndex() + 1;
            this.type = token.getType();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.type;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TokenInfo other = (TokenInfo)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return "TokenInfo [length=" + this.length + ", type=" + this.type + "]";
        }

        public int getAntlrTokenType() {
            return this.type;
        }

        public int getLength() {
            return this.length;
        }
    }
}

