/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.refactoring.ui.DefaultRenameSupport;
import org.eclipse.xtext.ui.refactoring.ui.IRenameSupport;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.JvmRenameRefactoringProvider;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.jdt.RenameJvmReferenceContext;

public class JdtAwareRenameSupportFactory
extends DefaultRenameSupport.Factory {
    @Inject
    private JvmRenameRefactoringProvider jvmRenameRefactorigProvider;

    public IRenameSupport create(Object context, String newName) {
        if (context instanceof RenameJvmReferenceContext) {
            try {
                RenameJavaElementDescriptor descriptor = this.createDescriptor((RenameJvmReferenceContext)((Object)context), newName);
                return new JdtRefactoringSupportWrapper(descriptor);
            }
            catch (Exception exc) {
                throw new WrappedException(exc);
            }
        }
        return super.create(context, newName);
    }

    protected RenameJavaElementDescriptor createDescriptor(RenameJvmReferenceContext renameElementContext, String newName) throws JavaModelException {
        IJavaElement referencedJavaElement = renameElementContext.getReferencedJavaElement();
        return this.jvmRenameRefactorigProvider.createRenameDescriptor(referencedJavaElement, newName);
    }

    protected static class JdtRefactoringSupportWrapper
    implements IRenameSupport {
        private RenameSupport renameSupport;

        public JdtRefactoringSupportWrapper(RenameJavaElementDescriptor renameDescriptor) throws CoreException {
            this.renameSupport = RenameSupport.create((RenameJavaElementDescriptor)renameDescriptor);
        }

        public void startRefactoringWithDialog(boolean previewOnly) throws InterruptedException {
            try {
                this.renameSupport.openDialog(this.getShell(), previewOnly);
            }
            catch (CoreException e) {
                throw new WrappedException((Exception)((Object)e));
            }
        }

        public void startDirectRefactoring() throws InterruptedException {
            try {
                this.renameSupport.perform(this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            catch (InvocationTargetException e) {
                throw new WrappedException((Exception)e);
            }
        }

        protected Shell getShell() {
            return Display.getDefault().getActiveShell();
        }
    }
}

