/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.services;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sirius.properties.uml.Activator;
import org.eclipse.papyrus.sirius.properties.uml.messages.Messages;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class PropertiesMemberEndServices {
    private static final String ASSOCIATION = "Association";
    private static final String CLASSIFIER = "Classifier";
    private static final String FEATURE_NOT_FOUND = Messages.OwnerObservableValue_FeatureNotFound;
    private static final String NULL_TYPE = Messages.OwnerObservableValue_NullType;
    private static final String OWNER = "owner";
    private static final String UNKNOWN_TYPE = Messages.OwnerObservableValue_UnknownType;
    private static final String UNMODIFIED_FEATURE = Messages.OwnerObservableValue_OwnerFeatureUnmodified;

    public void setNavigable(Property memberEnd, boolean isNavigable) {
        if (memberEnd.isNavigable() == isNavigable) {
            throw new OperationCanceledException();
        }
        Association association = memberEnd.getAssociation();
        EList navigableOwnedEnds = association.getNavigableOwnedEnds();
        if (isNavigable) {
            navigableOwnedEnds.add((Object)memberEnd);
        } else {
            if (memberEnd.getOwningAssociation() == null && memberEnd.getOwner() instanceof Classifier) {
                association.getOwnedEnds().add((Object)memberEnd);
            }
            if (navigableOwnedEnds.contains((Object)memberEnd)) {
                navigableOwnedEnds.remove((Object)memberEnd);
            }
        }
    }

    public String getOwner(Property memberEnd) {
        if (memberEnd.getAssociation().getOwnedEnds().contains((Object)memberEnd)) {
            return ASSOCIATION;
        }
        return CLASSIFIER;
    }

    public List<String> getOwnerEnumerations(Element obj) {
        return Arrays.asList(ASSOCIATION, CLASSIFIER);
    }

    public void setOwner(Property memberEnd, String owner) {
        boolean isOwnedByAssociation = ASSOCIATION.equals(owner);
        Association association = memberEnd.getAssociation();
        if (association.getMemberEnds().size() > 2) {
            Status status = new Status(2, "org.eclipse.papyrus.sirius.properties.uml", UNMODIFIED_FEATURE);
            Activator.getDefault().getLog().log((IStatus)status);
            throw new OperationCanceledException();
        }
        if (isOwnedByAssociation) {
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)association);
            if (provider != null) {
                association.getOwnedEnds().add((Object)memberEnd);
            }
        } else {
            EList ownerList = association.getEndTypes();
            Type ownerType = ((Type)ownerList.get(0)).equals(memberEnd.getType()) && ownerList.size() > 1 ? (Type)ownerList.get(1) : (Type)ownerList.get(0);
            EStructuralFeature ownedAttributeFeature = this.getOwnedAttributeFeatureForType(ownerType);
            if (ownedAttributeFeature != null) {
                ((EList)ownerType.eGet(ownedAttributeFeature)).add((Object)memberEnd);
            }
        }
    }

    public EStructuralFeature getOwnedAttributeFeatureForType(Type type) {
        EReference ownedAttributeFeature = null;
        if (type == null) {
            Status status = new Status(2, "org.eclipse.papyrus.sirius.properties.uml", NULL_TYPE);
            Activator.getDefault().getLog().log((IStatus)status);
        } else if (type instanceof StructuredClassifier) {
            ownedAttributeFeature = UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute();
        } else if (type instanceof Interface) {
            ownedAttributeFeature = UMLPackage.eINSTANCE.getInterface_OwnedAttribute();
        } else if (type instanceof DataType) {
            ownedAttributeFeature = UMLPackage.eINSTANCE.getDataType_OwnedAttribute();
        } else if (type instanceof Artifact) {
            ownedAttributeFeature = UMLPackage.eINSTANCE.getArtifact_OwnedAttribute();
        } else if (type instanceof Signal) {
            ownedAttributeFeature = UMLPackage.eINSTANCE.getSignal_OwnedAttribute();
        } else {
            String eClassName = type.eClass().getName();
            Status status = new Status(2, "org.eclipse.papyrus.sirius.properties.uml", String.format(UNKNOWN_TYPE, eClassName));
            Activator.getDefault().getLog().log((IStatus)status);
            ownedAttributeFeature = type.eClass().getEStructuralFeature("ownedAttribute");
            if (ownedAttributeFeature == null) {
                status = new Status(2, "org.eclipse.papyrus.sirius.properties.uml", String.format(FEATURE_NOT_FOUND, eClassName));
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return ownedAttributeFeature;
    }

    public boolean isMemberEndPropertyEditable(Element source, String propertyPath) {
        boolean isEditable = true;
        if (propertyPath.equals(OWNER)) {
            EList memberEnds = ((Property)source).getAssociation().getMemberEnds();
            if (memberEnds.size() == 2) {
                Property otherMemberEnd;
                if (this.isAssociation((Property)memberEnds.get(0)) && this.isAssociation((Property)memberEnds.get(1))) {
                    isEditable = false;
                }
                if ((otherMemberEnd = (Property)memberEnds.stream().filter(memberEnd -> memberEnd != source).collect(Collectors.toList()).get(0)).getType().eClass() == UMLPackage.eINSTANCE.getUseCase()) {
                    isEditable = false;
                }
            } else {
                isEditable = ((Property)source).getAssociation().getMemberEnds().size() <= 2 && !EMFHelper.isReadOnly((EObject)source);
            }
        } else {
            isEditable = !EMFHelper.isReadOnly((EObject)source);
        }
        return isEditable;
    }

    private boolean isAssociation(Property property) {
        if (property.getType() == null) {
            return false;
        }
        return property.getType().eClass() == UMLPackage.eINSTANCE.getAssociation();
    }
}

