/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.sequence.services.reorder;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.SequenceDiagramOrderServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.utils.SequenceDiagramUMLHelper;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.OccurrenceSpecificationHelper;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class SequenceDiagramSemanticReorderHelper {
    private final SequenceDiagramOrderServices orderService = new SequenceDiagramOrderServices();
    private final SequenceDiagramUMLHelper umlHelper = new SequenceDiagramUMLHelper();

    public Reordering createSemanticReorderEntry(NamedElement semanticElement, EAnnotation newEndPredecessor, List<EAnnotation> ends) {
        Element newOwner = this.findNewOwner(semanticElement, newEndPredecessor, ends);
        EReference newContainment = SequenceDiagramSemanticReorderHelper.findFragmentContainment(newOwner);
        List siblings = (List)newOwner.eGet((EStructuralFeature)newContainment);
        NamedElement newPredecessor = this.findSemanticPredecessor(newEndPredecessor, siblings, ends);
        return new Reordering(semanticElement, newOwner, newContainment, newPredecessor);
    }

    public Reordering reorderElements(NamedElement semanticElement, EAnnotation newEndPredecessor, List<EAnnotation> endsOrdering) {
        Reordering context = this.createSemanticReorderEntry(semanticElement, newEndPredecessor, endsOrdering);
        this.removeInteractionFragment(context.element());
        this.addInteractionFragment(context.element(), context.owner(), context.containment(), context.predecessor());
        return context;
    }

    public void reorderLifeline(Lifeline lifeline, Lifeline predecessor) {
        EList lifelines = lifeline.getInteraction().getLifelines();
        int newPosition = 0;
        if (predecessor != null) {
            newPosition = lifelines.indexOf((Object)predecessor) + 1;
            int currentPosition = lifelines.indexOf((Object)lifeline);
            if (currentPosition < newPosition) {
                --newPosition;
            }
        }
        lifelines.move(newPosition, (Object)lifeline);
    }

    private Element findNewOwner(NamedElement element, EAnnotation newEndPredecessor, List<EAnnotation> ends) {
        Element baseElement = this.umlHelper.getBaseElement(element);
        int finishIndex = ends.indexOf(this.orderService.getFinishingEnd(baseElement));
        int i = ends.indexOf(newEndPredecessor);
        while (i >= 0) {
            NamedElement semanticEnd;
            EAnnotation beforeEnd;
            EAnnotation previous = ends.get(i);
            if (this.orderService.getEndOwner(previous) != baseElement && this.orderService.isStartingEnd(previous) && finishIndex <= ends.indexOf(beforeEnd = this.orderService.getFinishingEnd(this.umlHelper.getBaseElement(semanticEnd = this.orderService.getEndFragment(previous)))) && SequenceDiagramSemanticReorderHelper.isApplicableOwner(semanticEnd, element) && this.umlHelper.isCoveringASubsetOf(element, semanticEnd)) {
                return semanticEnd;
            }
            --i;
        }
        return this.umlHelper.getOwningInteraction((Element)element);
    }

    private static boolean isApplicableOwner(NamedElement parent, NamedElement element) {
        return element instanceof InteractionOperand ? parent instanceof CombinedFragment : parent instanceof Interaction || parent instanceof InteractionOperand;
    }

    public static EReference findFragmentContainment(Element owner) {
        Object result = owner instanceof Interaction ? UMLPackage.eINSTANCE.getInteraction_Fragment() : (owner instanceof InteractionOperand ? UMLPackage.eINSTANCE.getInteractionOperand_Fragment() : (owner instanceof CombinedFragment ? UMLPackage.eINSTANCE.getCombinedFragment_Operand() : null));
        return result;
    }

    private NamedElement findSemanticPredecessor(EAnnotation previousEnd, List<?> siblings, List<EAnnotation> ends) {
        int i = ends.indexOf(previousEnd);
        while (i >= 0) {
            EAnnotation end = ends.get(i);
            NamedElement previous = this.orderService.getEndFragment(end);
            if (siblings.contains(previous)) {
                InteractionFragment associated = this.getAssociatedFragment(previous);
                if (associated != null) {
                    previous = associated;
                }
                return previous;
            }
            --i;
        }
        return null;
    }

    public void addInteractionFragment(NamedElement fragment, Element newOwner, EReference containmentReference, NamedElement semanticPredecessor) {
        List containment = (List)newOwner.eGet((EStructuralFeature)containmentReference);
        int newElementIndex = containment.indexOf(semanticPredecessor) + 1;
        containment.add(newElementIndex, fragment);
        InteractionFragment associated = this.getAssociatedFragment(fragment);
        if (associated != null) {
            containment.add(newElementIndex + 1, associated);
        }
    }

    private void removeInteractionFragment(NamedElement fragment) {
        Element owner = fragment.getOwner();
        EReference containmentReference = SequenceDiagramSemanticReorderHelper.findFragmentContainment(owner);
        List containment = (List)owner.eGet((EStructuralFeature)containmentReference);
        containment.remove(fragment);
        InteractionFragment associated = this.getAssociatedFragment(fragment);
        if (associated != null) {
            containment.remove(associated);
        }
    }

    private InteractionFragment getAssociatedFragment(NamedElement element) {
        if (element instanceof OccurrenceSpecification) {
            OccurrenceSpecification occurence = (OccurrenceSpecification)element;
            return OccurrenceSpecificationHelper.getExecutionFromStartOccurrence((OccurrenceSpecification)occurence).orElse(null);
        }
        return null;
    }

    public void alignLifelinesCoverage(Interaction root, Set<Lifeline> lifelines) {
        lifelines.forEach(lifeline -> {
            int n = this.alignLifelineEvents((Lifeline)lifeline, 0, (List<? extends InteractionFragment>)root.getFragments());
        });
    }

    private int alignLifelineEvents(Lifeline lifeline, int index, List<? extends InteractionFragment> fragments) {
        int cursor = index;
        EList order = lifeline.getCoveredBys();
        for (InteractionFragment interactionFragment : fragments) {
            if (!interactionFragment.getCovereds().contains((Object)lifeline)) continue;
            if (order.get(cursor) != interactionFragment) {
                lifeline.getCoveredBys().move(cursor, (Object)interactionFragment);
            }
            if (++cursor == lifeline.getCoveredBys().size()) {
                return cursor;
            }
            if (interactionFragment instanceof CombinedFragment) {
                CombinedFragment composite = (CombinedFragment)interactionFragment;
                cursor = this.alignLifelineEvents(lifeline, cursor, (List<? extends InteractionFragment>)composite.getOperands());
                continue;
            }
            if (!(interactionFragment instanceof InteractionOperand)) continue;
            InteractionOperand composite = (InteractionOperand)interactionFragment;
            cursor = this.alignLifelineEvents(lifeline, cursor, (List<? extends InteractionFragment>)composite.getFragments());
        }
        return cursor;
    }

    public record Reordering(NamedElement element, Element owner, EReference containment, NamedElement predecessor) {
    }
}

