/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.ui.editor.factories;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.emf.ui.converters.IDisplayConverter;
import org.eclipse.papyrus.emf.ui.converters.IdentityDisplayConverter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class CustomExtendedDialogCellEditor
extends ExtendedDialogCellEditor {
    private ITreeContentProvider contentProvider;
    private Collection<?> dialogInput;
    private ISelectionStatusValidator validator;
    private IItemPropertyDescriptor itemPropertyDescriptor;
    private IDisplayConverter displayConverter;
    private String dialogTitle;
    private String dialogMessage;
    private EObject editedObject;
    private EStructuralFeature editedFeature;
    private Image image;

    public CustomExtendedDialogCellEditor(Composite composite, ILabelProvider labelProvider, IItemPropertyDescriptor itemPropertyDescriptor, EObject editedObject, EStructuralFeature editedFeature) {
        super(composite, labelProvider);
        Assert.isNotNull((Object)itemPropertyDescriptor);
        this.itemPropertyDescriptor = itemPropertyDescriptor;
        Assert.isNotNull((Object)editedObject);
        this.editedObject = editedObject;
        Assert.isNotNull((Object)editedFeature);
        this.editedFeature = editedFeature;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public void setDialogMessage(String dialogMessage) {
        this.dialogMessage = dialogMessage;
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setDisplayConverter(IDisplayConverter displayConverter) {
        this.displayConverter = displayConverter;
    }

    public void setDialogInput(Collection<?> dialogInput) {
        this.dialogInput = dialogInput;
    }

    public void setSelectionStatusValidator(ISelectionStatusValidator validator) {
        this.validator = validator;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        Object[] result;
        this.checkInput();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), this.labelProvider, this.contentProvider);
        Object initialSelection = this.displayConverter.semanticToDisplayValue(this.editedObject.eGet(this.editedFeature), this.editedObject);
        Object[] selectedValue = new Object[]{initialSelection};
        dialog.setSize(100, 50);
        dialog.setInput(this.dialogInput);
        if (this.validator != null) {
            dialog.setValidator(this.validator);
        }
        dialog.setComparator(new ViewerComparator());
        dialog.setAllowMultiple(this.isManyFeature());
        dialog.setInitialSelections(selectedValue);
        dialog.setTitle(this.dialogTitle);
        dialog.setMessage(this.dialogMessage);
        if (this.image != null) {
            dialog.setImage(this.image);
        }
        int userResponse = dialog.open();
        Object toReturn = null;
        toReturn = userResponse == 0 ? ((result = dialog.getResult()) == null ? this.itemPropertyDescriptor.getPropertyValue(null) : (this.editedFeature.isMany() ? Arrays.asList(result) : result[0])) : this.itemPropertyDescriptor.getPropertyValue((Object)this.editedObject);
        toReturn = this.displayConverter.displayToSemanticValue(toReturn, this.editedObject);
        return toReturn;
    }

    private void checkInput() {
        if (this.displayConverter == null) {
            this.displayConverter = new IdentityDisplayConverter();
        }
        Assert.isNotNull((Object)this.contentProvider, (String)"The ITreeContentProvider has not been set");
        Assert.isNotNull(this.dialogInput, (String)"The dialog input is null");
        Assert.isNotNull((Object)this.validator, (String)"The validator has not been set");
    }

    public void dispose() {
        super.dispose();
        this.contentProvider = null;
        this.dialogInput.clear();
        this.dialogInput = null;
        this.displayConverter = null;
        this.editedFeature = null;
        this.editedObject = null;
        this.image = null;
        this.itemPropertyDescriptor = null;
        this.validator = null;
    }

    private boolean isManyFeature() {
        return this.editedFeature.isMany();
    }
}

