/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.ui.workflow.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderDefaultImpl;
import org.eclipse.emf.mwe.internal.ui.workflow.Activator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;

public class ProjectIncludingResourceLoader
extends ResourceLoaderDefaultImpl {
    private final ClassLoader projectCL;

    public ProjectIncludingResourceLoader(IProject project) throws CoreException {
        this.projectCL = this.createClassLoader(project);
    }

    public ClassLoader createClassLoader(IProject project) throws CoreException {
        IJavaProject jp = JavaCore.create((IProject)project);
        IPackageFragmentRoot[] roots = jp.getAllPackageFragmentRoots();
        URL[] urls = new URL[roots.length];
        IPath wsLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        int i = 0;
        while (i < roots.length) {
            try {
                URL url;
                IPath path = roots[i].getPath();
                File file = path.toFile();
                if (!file.exists()) {
                    path = wsLocation.append(path);
                    file = path.toFile();
                }
                urls[i] = url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                Activator.logError(e);
            }
            ++i;
        }
        return new URLClassLoader(urls);
    }

    protected URL loadFromContextClassLoader(String path) {
        URL resource = this.projectCL.getResource(path);
        if (resource == null) {
            resource = super.loadFromContextClassLoader(path);
        }
        return resource;
    }
}

