/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.emf.mint.internal.ui.actions.OpenGeneratedAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;

public class OpenGeneratedMenu
extends CompoundContributionItem {
    protected static final IContributionItem[] NO_ITEMS = new IContributionItem[0];
    protected ComposedAdapterFactory adapterFactory;

    protected IContributionItem[] getContributionItems() {
        Object target;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection sel = selectionService.getSelection();
        if (sel instanceof IStructuredSelection && (target = ((IStructuredSelection)sel).getFirstElement()) != null) {
            Object adapter;
            if (this.adapterFactory == null) {
                this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            }
            if ((adapter = this.adapterFactory.adapt(target, IItemJavaElementSource.class)) instanceof IItemJavaElementSource) {
                return this.createActions((IItemJavaElementSource)adapter, target);
            }
        }
        return NO_ITEMS;
    }

    private IContributionItem[] createActions(IItemJavaElementSource provider, Object target) {
        ArrayList descriptors = new ArrayList(provider.getJavaElementDescriptors(target));
        Collections.sort(descriptors, new DescriptorComparator(target));
        ArrayList<Object> actions = new ArrayList<Object>(descriptors.size());
        String category = null;
        for (IItemJavaElementDescriptor descriptor : descriptors) {
            String newCategory = descriptor.getCategory(target);
            if (category == null ? newCategory != null : !category.equals(newCategory)) {
                category = newCategory;
                if (!actions.isEmpty()) {
                    actions.add(new Separator());
                }
            }
            IAction action = this.createAction(descriptor, target);
            actions.add(new ActionContributionItem(action));
        }
        return actions.toArray(new IContributionItem[actions.size()]);
    }

    protected IAction createAction(IItemJavaElementDescriptor descriptor, Object target) {
        return new OpenGeneratedAction(descriptor, target);
    }

    public void dispose() {
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
            this.adapterFactory = null;
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DescriptorComparator
    implements Comparator<IItemJavaElementDescriptor> {
        protected final Object target;

        public DescriptorComparator(Object target) {
            this.target = target;
        }

        @Override
        public int compare(IItemJavaElementDescriptor o1, IItemJavaElementDescriptor o2) {
            String category1 = o1.getCategory(this.target);
            String category2 = o2.getCategory(this.target);
            if (category1 == null) {
                if (category2 != null) {
                    return -1;
                }
            } else {
                if (category2 == null) {
                    return 1;
                }
                int result = category1.compareTo(category2);
                if (result != 0) {
                    return result;
                }
            }
            String name1 = o1.getDisplayName(this.target);
            String name2 = o2.getDisplayName(this.target);
            if (name1 == null) {
                return name2 == null ? 0 : -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

