/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.match.engine.IMatchScope;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMatchScope
implements IMatchScope {
    private final List<Resource> resourcesInScope = new ArrayList<Resource>();
    private final List<EObject> eObjectsInScope = new ArrayList<EObject>();

    public GenericMatchScope(EObject eObject) {
        this.eObjectsInScope.add(eObject);
        TreeIterator iterator = eObject.eAllContents();
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            this.eObjectsInScope.add(next);
            if (next.eResource() == null || this.resourcesInScope.contains(next.eResource())) continue;
            GenericMatchScope.resolveAll(next.eResource().getResourceSet());
            this.resourcesInScope.add(next.eResource());
        }
    }

    public GenericMatchScope(Resource scope) {
        GenericMatchScope.resolveAll(scope.getResourceSet());
        this.resourcesInScope.add(scope);
    }

    public GenericMatchScope(ResourceSet scope) {
        GenericMatchScope.resolveAll(scope);
        this.resourcesInScope.addAll((Collection<Resource>)scope.getResources());
    }

    @Override
    public boolean isInScope(EObject eObject) {
        if (this.eObjectsInScope.contains(eObject)) {
            return true;
        }
        Resource resource = this.getContainingResource(eObject);
        if (resource == null) {
            return false;
        }
        return this.isInScope(resource);
    }

    private Resource getContainingResource(EObject eObject) {
        if (eObject.eResource() != null) {
            return eObject.eResource();
        }
        for (Resource resourceInScope : this.getResourcesInScope()) {
            if (!ModelUtils.contains((Resource)resourceInScope, (EObject)eObject)) continue;
            return resourceInScope;
        }
        return null;
    }

    @Override
    public boolean isInScope(Resource resource) {
        return this.getResourcesInScope().contains(resource);
    }

    public List<Resource> getResourcesInScope() {
        return this.resourcesInScope;
    }

    private static void resolveAll(ResourceSet resourceSet) {
        if (resourceSet != null) {
            EList resources = resourceSet.getResources();
            int i = 0;
            while (i < resources.size()) {
                TreeIterator resourceContent = ((Resource)resources.get(i)).getAllContents();
                while (resourceContent.hasNext()) {
                    EObject eObject = (EObject)resourceContent.next();
                    Iterator objectChildren = eObject.eCrossReferences().iterator();
                    while (objectChildren.hasNext()) {
                        objectChildren.next();
                    }
                }
                ++i;
            }
        }
    }
}

