/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.postprocessor;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.conflict.DefaultConflictDetector;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.uml2.internal.OpaqueElementBodyChange;
import org.eclipse.emf.compare.uml2.internal.postprocessor.util.UMLCompareUtil;
import org.eclipse.emf.ecore.EObject;

public class OpaqueElementBodyChangePostProcessor
extends DefaultConflictDetector
implements IPostProcessor {
    private static final Predicate<Diff> IS_OPAQUE_ELEMENT_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return diff instanceof OpaqueElementBodyChange;
        }
    };
    private static final Predicate<Diff> IS_LEFT_OPAQUE_ELEMENT_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return DifferenceSource.LEFT.equals((Object)diff.getSource()) && IS_OPAQUE_ELEMENT_CHANGE.apply((Object)diff);
        }
    };
    private static final Predicate<Diff> IS_RIGHT_OPAQUE_ELEMENT_CHANGE = new Predicate<Diff>(){

        public boolean apply(Diff diff) {
            return DifferenceSource.RIGHT.equals((Object)diff.getSource()) && IS_OPAQUE_ELEMENT_CHANGE.apply((Object)diff);
        }
    };

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
        this.detect(comparison, monitor);
    }

    public void detect(Comparison comparison, Monitor monitor) {
        EList diffs = comparison.getDifferences();
        Iterable leftBodyChanges = Iterables.filter((Iterable)diffs, IS_LEFT_OPAQUE_ELEMENT_CHANGE);
        for (Diff leftDiff : leftBodyChanges) {
            OpaqueElementBodyChange leftBodyChange = (OpaqueElementBodyChange)leftDiff;
            EObject leftOpaqueElement = leftBodyChange.getDiscriminant();
            Match opaqueElementMatch = comparison.getMatch(leftOpaqueElement);
            EList rightDiffs = comparison.getDifferences(opaqueElementMatch.getRight());
            Iterable rightBodyChanges = Iterables.filter((Iterable)rightDiffs, IS_RIGHT_OPAQUE_ELEMENT_CHANGE);
            for (Diff rightDiff : rightBodyChanges) {
                OpaqueElementBodyChange rightBodyChange = (OpaqueElementBodyChange)rightDiff;
                if (!this.isConflicting(leftBodyChange, rightBodyChange)) continue;
                Conflict conflict = this.createRealConflict(leftBodyChange, rightBodyChange);
                comparison.getConflicts().add((Object)conflict);
            }
        }
    }

    private boolean isConflicting(OpaqueElementBodyChange bodyChange1, OpaqueElementBodyChange bodyChange2) {
        boolean areConflicting = false;
        if (this.concernSameLanguage(bodyChange1, bodyChange2)) {
            if (this.areDifferenceKindChange(bodyChange1, bodyChange2)) {
                areConflicting = this.isThreeWayTextConflict(bodyChange1);
            } else if (this.areDifferenceKindChangeAndDelete(bodyChange1, bodyChange2)) {
                areConflicting = true;
            } else if (this.areDifferenceKindAdd(bodyChange1, bodyChange2)) {
                areConflicting = true;
            } else if (this.areDifferenceKindMove(bodyChange1, bodyChange2)) {
                areConflicting = true;
            }
        }
        return areConflicting;
    }

    private boolean concernSameLanguage(OpaqueElementBodyChange bodyChange1, OpaqueElementBodyChange bodyChange2) {
        return bodyChange1.getLanguage().equals(bodyChange2.getLanguage());
    }

    private boolean areDifferenceKindChange(OpaqueElementBodyChange bodyChange1, OpaqueElementBodyChange bodyChange2) {
        return DifferenceKind.CHANGE.equals((Object)bodyChange1.getKind()) && DifferenceKind.CHANGE.equals((Object)bodyChange2.getKind());
    }

    private boolean areDifferenceKindAdd(OpaqueElementBodyChange bodyChange1, OpaqueElementBodyChange bodyChange2) {
        return DifferenceKind.ADD.equals((Object)bodyChange1.getKind()) && DifferenceKind.ADD.equals((Object)bodyChange2.getKind());
    }

    private boolean areDifferenceKindChangeAndDelete(OpaqueElementBodyChange bodyChange1, OpaqueElementBodyChange bodyChange2) {
        return DifferenceKind.CHANGE.equals((Object)bodyChange1.getKind()) && DifferenceKind.DELETE.equals((Object)bodyChange2.getKind()) || DifferenceKind.DELETE.equals((Object)bodyChange1.getKind()) && DifferenceKind.CHANGE.equals((Object)bodyChange2.getKind());
    }

    private boolean areDifferenceKindMove(OpaqueElementBodyChange bodyChange1, OpaqueElementBodyChange bodyChange2) {
        return DifferenceKind.MOVE.equals((Object)bodyChange1.getKind()) && DifferenceKind.MOVE.equals((Object)bodyChange2.getKind());
    }

    private boolean isThreeWayTextConflict(OpaqueElementBodyChange bodyChange) {
        String rightBody;
        if (bodyChange.getMatch().getOrigin() == null) {
            return false;
        }
        Match match = bodyChange.getMatch();
        EObject originContainer = match.getOrigin();
        EObject leftContainer = match.getLeft();
        EObject rightContainer = match.getRight();
        String language = bodyChange.getLanguage();
        String originBody = UMLCompareUtil.getOpaqueElementBody(originContainer, language);
        String leftBody = UMLCompareUtil.getOpaqueElementBody(leftContainer, language);
        return !this.isMergeableText(leftBody, rightBody = UMLCompareUtil.getOpaqueElementBody(rightContainer, language), originBody);
    }

    private Conflict createRealConflict(OpaqueElementBodyChange bodyChange1, OpaqueElementBodyChange bodyChange2) {
        Conflict conflict = CompareFactory.eINSTANCE.createConflict();
        conflict.setKind(ConflictKind.REAL);
        conflict.getDifferences().add((Object)bodyChange1);
        conflict.getDifferences().add((Object)bodyChange2);
        return conflict;
    }
}

