/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.internal.spec.DiffSpec;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImplicationsMergeTest {
    private static final boolean MERGE_RIGHT_TO_LEFT = false;
    private final IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
    private final BatchMerger batchMerger = new BatchMerger(this.mergerRegistry);

    @Before
    public void setUp() {
        this.mergerRegistry.add((IMerger)new AbstractMerger(){

            public boolean isMergerFor(Diff target) {
                return true;
            }
        });
    }

    protected IMerger2 getMerger(Diff diff) {
        return (IMerger2)this.mergerRegistry.getHighestRankingMerger(diff);
    }

    protected void mergeLeftToRight(Diff diff) {
        this.batchMerger.copyAllLeftToRight(Arrays.asList(diff), (Monitor)new BasicMonitor());
    }

    protected Set<Diff> getDirectResultingMerges(Diff diff) {
        return this.getMerger(diff).getDirectResultingMerges(diff, false);
    }

    @Test
    public void testsAImpliesBMergeA() {
        Diff diffA = this.createDiff("DiffA");
        Diff diffB = this.createDiff("DiffB");
        diffA.getImplies().add((Object)diffB);
        Set<Diff> resultingMerges = this.getDirectResultingMerges(diffA);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertSame((Object)diffB, (Object)resultingMerges.iterator().next());
        resultingMerges = this.getDirectResultingMerges(diffB);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertSame((Object)diffA, (Object)resultingMerges.iterator().next());
        this.mergeLeftToRight(diffA);
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffA.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffB.getState());
    }

    @Test
    public void testsAImpliesBMergeB() {
        Diff diffA = this.createDiff("DiffA");
        Diff diffB = this.createDiff("DiffB");
        diffA.getImplies().add((Object)diffB);
        Set<Diff> resultingMerges = this.getDirectResultingMerges(diffA);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertSame((Object)diffB, (Object)resultingMerges.iterator().next());
        resultingMerges = this.getDirectResultingMerges(diffB);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertSame((Object)diffA, (Object)resultingMerges.iterator().next());
        this.mergeLeftToRight(diffB);
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffA.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffB.getState());
    }

    @Test
    public void testsAImpliesBImpliesCMergeA() {
        Diff diffA = this.createDiff("DiffA");
        Diff diffB = this.createDiff("DiffB");
        Diff diffC = this.createDiff("DiffC");
        diffA.getImplies().add((Object)diffB);
        diffB.getImplies().add((Object)diffC);
        Set<Diff> resultingMerges = this.getDirectResultingMerges(diffA);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertSame((Object)diffB, (Object)resultingMerges.iterator().next());
        resultingMerges = this.getDirectResultingMerges(diffB);
        Assert.assertEquals((long)2L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffA));
        Assert.assertTrue((boolean)resultingMerges.contains(diffC));
        resultingMerges = this.getDirectResultingMerges(diffC);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffB));
        this.mergeLeftToRight(diffA);
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffA.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffB.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffC.getState());
    }

    @Test
    public void testsAImpliesBImpliesCMergeB() {
        Diff diffA = this.createDiff("DiffA");
        Diff diffB = this.createDiff("DiffB");
        Diff diffC = this.createDiff("DiffC");
        diffA.getImplies().add((Object)diffB);
        diffB.getImplies().add((Object)diffC);
        Set<Diff> resultingMerges = this.getDirectResultingMerges(diffA);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertSame((Object)diffB, (Object)resultingMerges.iterator().next());
        resultingMerges = this.getDirectResultingMerges(diffB);
        Assert.assertEquals((long)2L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffA));
        Assert.assertTrue((boolean)resultingMerges.contains(diffC));
        resultingMerges = this.getDirectResultingMerges(diffC);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffB));
        this.mergeLeftToRight(diffB);
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffA.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffB.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffC.getState());
    }

    @Test
    public void testsAImpliesBImpliesCMergeC() {
        Diff diffA = this.createDiff("DiffA");
        Diff diffB = this.createDiff("DiffB");
        Diff diffC = this.createDiff("DiffC");
        diffA.getImplies().add((Object)diffB);
        diffB.getImplies().add((Object)diffC);
        Set<Diff> resultingMerges = this.getDirectResultingMerges(diffA);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertSame((Object)diffB, (Object)resultingMerges.iterator().next());
        resultingMerges = this.getDirectResultingMerges(diffB);
        Assert.assertEquals((long)2L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffA));
        Assert.assertTrue((boolean)resultingMerges.contains(diffC));
        resultingMerges = this.getDirectResultingMerges(diffC);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffB));
        this.mergeLeftToRight(diffC);
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffA.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffB.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffC.getState());
    }

    @Test
    public void testsAImpliesBCMergeA() {
        Diff diffA = this.createDiff("DiffA");
        Diff diffB = this.createDiff("DiffB");
        Diff diffC = this.createDiff("DiffC");
        diffA.getImplies().add((Object)diffB);
        diffA.getImplies().add((Object)diffC);
        Set<Diff> resultingMerges = this.getDirectResultingMerges(diffA);
        Assert.assertEquals((long)2L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffB));
        Assert.assertTrue((boolean)resultingMerges.contains(diffC));
        resultingMerges = this.getDirectResultingMerges(diffB);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffA));
        resultingMerges = this.getDirectResultingMerges(diffC);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffA));
        this.mergeLeftToRight(diffA);
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffA.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffB.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffC.getState());
    }

    @Test
    public void testsAImpliesBCMergeB() {
        Diff diffA = this.createDiff("DiffA");
        Diff diffB = this.createDiff("DiffB");
        Diff diffC = this.createDiff("DiffC");
        diffA.getImplies().add((Object)diffB);
        diffA.getImplies().add((Object)diffC);
        Set<Diff> resultingMerges = this.getDirectResultingMerges(diffA);
        Assert.assertEquals((long)2L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffB));
        Assert.assertTrue((boolean)resultingMerges.contains(diffC));
        resultingMerges = this.getDirectResultingMerges(diffB);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffA));
        resultingMerges = this.getDirectResultingMerges(diffC);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffA));
        this.mergeLeftToRight(diffB);
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffA.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffB.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffC.getState());
    }

    @Test
    public void testsAImpliesBCMergeC() {
        Diff diffA = this.createDiff("DiffA");
        Diff diffB = this.createDiff("DiffB");
        Diff diffC = this.createDiff("DiffC");
        diffA.getImplies().add((Object)diffB);
        diffA.getImplies().add((Object)diffC);
        Set<Diff> resultingMerges = this.getDirectResultingMerges(diffA);
        Assert.assertEquals((long)2L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffB));
        Assert.assertTrue((boolean)resultingMerges.contains(diffC));
        resultingMerges = this.getDirectResultingMerges(diffB);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffA));
        resultingMerges = this.getDirectResultingMerges(diffC);
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(diffA));
        this.mergeLeftToRight(diffC);
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffA.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffB.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)diffC.getState());
    }

    protected Diff createDiff(final String name) {
        return new DiffSpec(){

            public String toString() {
                return name;
            }
        };
    }
}

