/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server;

import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.generator.Generator;
import org.eclipse.jetty.fcgi.generator.ServerGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransportOverFCGI
implements HttpTransport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTransportOverFCGI.class);
    private final ServerGenerator generator;
    private final Flusher flusher;
    private final int request;
    private volatile boolean shutdown;
    private volatile boolean aborted;

    public HttpTransportOverFCGI(ByteBufferPool byteBufferPool, boolean useDirectByteBuffers, boolean sendStatus200, Flusher flusher, int request) {
        this.generator = new ServerGenerator(byteBufferPool, useDirectByteBuffers, sendStatus200);
        this.flusher = flusher;
        this.request = request;
    }

    public void send(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean lastContent, Callback callback) {
        boolean head = HttpMethod.HEAD.is(request.getMethod());
        if (response != null) {
            this.commit(response, head, content, lastContent, callback);
        } else {
            if (head) {
                if (lastContent) {
                    Generator.Result result = this.generateResponseContent(BufferUtil.EMPTY_BUFFER, true, callback);
                    this.flusher.flush(new Generator.Result[]{result});
                } else {
                    callback.succeeded();
                }
            } else {
                Generator.Result result = this.generateResponseContent(content, lastContent, callback);
                this.flusher.flush(new Generator.Result[]{result});
            }
            if (lastContent && this.shutdown) {
                this.flusher.shutdown();
            }
        }
    }

    public boolean isPushSupported() {
        return false;
    }

    public void push(MetaData.Request request) {
    }

    private void commit(MetaData.Response info, boolean head, ByteBuffer content, boolean lastContent, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("commit {} {} l={}", new Object[]{this, info, lastContent});
        }
        boolean shutdown = this.shutdown = info.getFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
        if (head) {
            if (lastContent) {
                Generator.Result headersResult = this.generateResponseHeaders(info, Callback.NOOP);
                Generator.Result contentResult = this.generateResponseContent(BufferUtil.EMPTY_BUFFER, true, callback);
                this.flusher.flush(new Generator.Result[]{headersResult, contentResult});
            } else {
                Generator.Result headersResult = this.generateResponseHeaders(info, callback);
                this.flusher.flush(new Generator.Result[]{headersResult});
            }
        } else {
            Generator.Result headersResult = this.generateResponseHeaders(info, Callback.NOOP);
            Generator.Result contentResult = this.generateResponseContent(content, lastContent, callback);
            this.flusher.flush(new Generator.Result[]{headersResult, contentResult});
        }
        if (lastContent && shutdown) {
            this.flusher.shutdown();
        }
    }

    protected Generator.Result generateResponseHeaders(MetaData.Response info, Callback callback) {
        return this.generator.generateResponseHeaders(this.request, info.getStatus(), info.getReason(), info.getFields(), callback);
    }

    protected Generator.Result generateResponseContent(ByteBuffer buffer, boolean lastContent, Callback callback) {
        return this.generator.generateResponseContent(this.request, buffer, lastContent, this.aborted, callback);
    }

    public void abort(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("abort {} {}", (Object)this, (Object)failure);
        }
        this.aborted = true;
        this.flusher.shutdown();
    }

    public void onCompleted() {
    }
}

