/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.internal.qvt.oml.common.launch.BaseProcess;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.library.IConfiguration;
import org.eclipse.m2m.internal.qvt.oml.library.QvtConfiguration;
import org.eclipse.m2m.internal.qvt.oml.runtime.ant.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchConfigurationDelegateBase;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractApplyTransformationTask
extends Task {
    private static final String TAG_TRANSFORMATION = "transformation";
    private static final String TAG_TARGET_URI = "targeturi";
    private IConfiguration myConfiguration;
    private String myTransformation;
    private String mySourceUri;
    private String myTargetType;
    private String myTargetUri;
    private String myFeature;
    private String myClearContents;
    private String myTraceFile;
    private String myResultUriProperty;
    private final List<ConfigurationProperty> myConfigurationProperties = new ArrayList<ConfigurationProperty>();
    private final List<TargetUriDef> myTargetUris = new ArrayList<TargetUriDef>();

    public void checkAttribute(Object attr, String attrName) throws BuildException {
        if (attr == null) {
            throw new BuildException(NLS.bind((String)Messages.AbstractApplyTransformationTask_Required_attribute_is_not_specified, (Object)attrName));
        }
    }

    public void execute() throws BuildException {
        this.checkAttribute(this.myTransformation, TAG_TRANSFORMATION);
        if (this.myTargetUris.isEmpty()) {
            throw new BuildException(NLS.bind((String)Messages.AbstractApplyTransformationTask_Required_attribute_is_not_specified, (Object)TAG_TARGET_URI));
        }
        final ArrayList<TargetUriData> targetUris = new ArrayList<TargetUriData>(this.myTargetUris.size());
        for (TargetUriDef targetUriDef : this.myTargetUris) {
            if (targetUriDef.targeturi == null) {
                throw new BuildException(NLS.bind((String)Messages.AbstractApplyTransformationTask_Required_attribute_is_not_specified, (Object)TAG_TARGET_URI));
            }
            TargetUriData.TargetType type = targetUriDef.targettype != null ? TargetUriData.TargetType.valueOf((String)targetUriDef.targettype) : TargetUriData.TargetType.NEW_MODEL;
            String feature = targetUriDef.feature != null ? targetUriDef.feature : "";
            boolean isClear = targetUriDef.clearcontents != null ? Boolean.valueOf(targetUriDef.clearcontents) : false;
            targetUris.add(new TargetUriData(type, targetUriDef.targeturi, feature, isClear));
        }
        final ArrayList inUris = new ArrayList();
        final ArrayList outUris = new ArrayList();
        try {
            BaseProcess.IRunnable r = new BaseProcess.IRunnable(){

                public void run() throws Exception {
                    QvtTransformation transf = AbstractApplyTransformationTask.this.getTransformationObject();
                    ArrayList<EObject> inObjects = new ArrayList<EObject>();
                    ArrayList<TargetUriData> targetData = new ArrayList<TargetUriData>();
                    Iterator itrTargetData = targetUris.iterator();
                    for (QvtTransformation.TransformationParameter transfParam : transf.getParameters()) {
                        if (!itrTargetData.hasNext()) {
                            throw new BuildException(NLS.bind((String)Messages.AbstractApplyTransformationTask_Required_attribute_is_not_specified, (Object)transfParam.getName()));
                        }
                        TargetUriData nextUri = (TargetUriData)itrTargetData.next();
                        if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN || transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.INOUT) {
                            URI inUri = AbstractApplyTransformationTask.resolveUri(nextUri.getUriString());
                            inUris.add(inUri);
                            EObject inObj = transf.loadInput(inUri);
                            inObjects.add(inObj);
                        }
                        if (transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.OUT && transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.INOUT) continue;
                        targetData.add(nextUri);
                    }
                    List<URI> resultUris = QvtLaunchConfigurationDelegateBase.doLaunch(transf, inObjects, targetData, AbstractApplyTransformationTask.this.getConfiguration(), AbstractApplyTransformationTask.this.getTraceFile());
                    outUris.addAll(resultUris);
                }
            };
            r = QvtLaunchConfigurationDelegateBase.getSafeRunnable(this.getTransformationObject(), r);
            r.run();
            if (this.getProject() != null && this.getResultUriProperty() != null) {
                int index = 1;
                for (URI uri : outUris) {
                    this.getProject().setProperty(String.valueOf(this.getResultUriProperty()) + index, uri == null ? "" : uri.toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(StatusUtil.getExceptionMessages((Throwable)e), (Throwable)e);
        }
        System.out.println(NLS.bind((String)Messages.AbstractApplyTransformationTask_Transformation_has_been_applied, (Object[])new String[]{this.getTransformation(), ((Object)inUris).toString(), ((Object)outUris).toString()}));
    }

    protected abstract QvtTransformation getTransformationObject();

    public boolean isTraceUsed() {
        return this.getTraceFile() != null;
    }

    public String getTransformation() {
        return this.myTransformation;
    }

    public void setTransformation(String transformation) {
        this.myTransformation = transformation;
    }

    public String getSourceUri() {
        return this.mySourceUri;
    }

    public void setSourceUri(String input) {
        this.mySourceUri = input;
    }

    public String getTargetUri() {
        return this.myTargetUri;
    }

    public void setTargetUri(String output) {
        this.myTargetUri = output;
    }

    public String getFeature() {
        return this.myFeature;
    }

    public void setFeature(String feature) {
        this.myFeature = feature;
    }

    public String getTargetType() {
        return this.myTargetType;
    }

    public void setTargetType(String targetType) {
        this.myTargetType = targetType;
    }

    public String getClearContents() {
        return this.myClearContents;
    }

    public void setClearContents(String clearContents) {
        this.myClearContents = clearContents;
    }

    public String getTraceFile() {
        return this.myTraceFile;
    }

    public void setTraceFile(String trace) {
        this.myTraceFile = trace;
    }

    public String getResultUriProperty() {
        return this.myResultUriProperty;
    }

    public void setResultUriProperty(String resultUriProperty) {
        this.myResultUriProperty = resultUriProperty;
    }

    public ConfigurationProperty createConfigurationProperty() {
        ConfigurationProperty configurationProperty = new ConfigurationProperty();
        this.myConfigurationProperties.add(configurationProperty);
        return configurationProperty;
    }

    public void addConfigurationProperty(ConfigurationProperty configurationProperty) {
        if (!this.myConfigurationProperties.contains(configurationProperty)) {
            this.myConfigurationProperties.add(configurationProperty);
        }
    }

    public void addConfiguredConfigurationProperty(ConfigurationProperty configurationProperty) {
        this.addConfigurationProperty(configurationProperty);
    }

    public TargetUriDef createTargetUriDef() {
        TargetUriDef targetUriDef = new TargetUriDef();
        this.myTargetUris.add(targetUriDef);
        return targetUriDef;
    }

    public void addTargetUriDef(TargetUriDef targetUriDef) {
        if (!this.myTargetUris.contains(targetUriDef)) {
            this.myTargetUris.add(targetUriDef);
        }
    }

    public void addConfiguredTargetUriDef(TargetUriDef targetUriDef) {
        this.addTargetUriDef(targetUriDef);
    }

    protected static IFile resolveFile(String path) throws BuildException {
        IFile file = WorkspaceUtils.getWorkspaceFile((String)path);
        if (file == null) {
            throw new BuildException(NLS.bind((String)Messages.AbstractApplyTransformationTask_File_not_found, (Object)path));
        }
        return file;
    }

    protected static URI resolveUri(String uriString) throws BuildException {
        try {
            URI uri = URI.createURI((String)uriString);
            if (uri == null) {
                throw new BuildException(NLS.bind((String)Messages.AbstractApplyTransformationTask_File_not_found, (Object)uriString));
            }
            return uri;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected IConfiguration getConfiguration() {
        if (this.myConfiguration == null) {
            HashMap<String, String> props = new HashMap<String, String>();
            for (ConfigurationProperty property : this.myConfigurationProperties) {
                props.put(property.getName(), property.getValue());
            }
            this.myConfiguration = new QvtConfiguration(props);
        }
        return this.myConfiguration;
    }

    public static class ConfigurationProperty {
        private String name;
        private String value;

        public ConfigurationProperty() {
        }

        public ConfigurationProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class TargetUriDef {
        private String targeturi;
        private String targettype;
        private String feature;
        private String clearcontents;

        public TargetUriDef() {
        }

        public TargetUriDef(String targeturi, String targettype, String feature, String clearcontents) {
            this.targeturi = targeturi;
            this.targettype = targettype;
            this.feature = feature;
            this.clearcontents = clearcontents;
        }

        public String getTargetUri() {
            return this.targeturi;
        }

        public void setTargetUri(String targeturi) {
            this.targeturi = targeturi;
        }

        public String getTargetType() {
            return this.targettype;
        }

        public void setTargetType(String targettype) {
            this.targettype = targettype;
        }

        public String getFeature() {
            return this.feature;
        }

        public void setFeature(String feature) {
            this.feature = feature;
        }

        public String getClearContents() {
            return this.clearcontents;
        }

        public void setClearContents(String clearcontents) {
            this.clearcontents = clearcontents;
        }
    }
}

