/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.CallExpCS;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.cst.VariableExpCS;
import org.eclipse.ocl.expressions.CallExp;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.expressions.VariableExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeprecatedImplicitSourceCallHelper {
    DeprecatedImplicitSourceCallHelper() {
    }

    static void validateCallExp(OCLExpressionCS callExpCS, CallExp<EClassifier> resultAST, QvtOperationalEnv env) {
        VariableExp varExp;
        Variable refVar;
        CallExp<EClassifier> call;
        OCLExpressionCS causeNode = null;
        if (callExpCS instanceof CallExpCS) {
            CallExpCS actualCallExpCS = (CallExpCS)callExpCS;
            if (actualCallExpCS.getSource() != null) {
                return;
            }
            causeNode = actualCallExpCS.getSimpleNameCS() != null ? actualCallExpCS.getSimpleNameCS() : callExpCS;
        } else if (callExpCS instanceof VariableExpCS && resultAST instanceof PropertyCallExp) {
            causeNode = callExpCS;
        }
        if (causeNode != null && resultAST instanceof CallExp && (call = resultAST).getSource() instanceof VariableExp && (refVar = (varExp = (VariableExp)call.getSource()).getReferredVariable()) != null && refVar.getName() != null) {
            String refVarName = refVar.getName();
            if ("self".equals(refVarName)) {
                env.reportError(ValidationMessages.DeprecatedImplicitSourceCall_contextualImplicitCall, (CSTNode)causeNode);
            } else if (refVarName != null && refVarName.endsWith(".this")) {
                PropertyCallExp propCall;
                EStructuralFeature referredProperty;
                if (resultAST instanceof OperationCallExp) {
                    OperationCallExp operCall = (OperationCallExp)resultAST;
                    EOperation referredOperation = (EOperation)operCall.getReferredOperation();
                    if (referredOperation != null && !DeprecatedImplicitSourceCallHelper.isModuleOperation(referredOperation, env)) {
                        env.reportWarning(ValidationMessages.DeprecatedImplicitSourceCall_moduleScopeImplicitCall, (CSTNode)causeNode);
                    }
                } else if (resultAST instanceof PropertyCallExp && (referredProperty = (EStructuralFeature)(propCall = (PropertyCallExp)resultAST).getReferredProperty()) != null && !DeprecatedImplicitSourceCallHelper.isModuleProperty(referredProperty, env)) {
                    env.reportWarning(ValidationMessages.DeprecatedImplicitSourceCall_moduleScopeImplicitCall, (CSTNode)causeNode);
                }
            }
        }
    }

    private static boolean isModuleOperation(EOperation operation, QvtOperationalEnv env) {
        EClassifier owningClassifier = (EClassifier)env.getUMLReflection().getOwningClassifier((Object)operation);
        return owningClassifier instanceof Module;
    }

    private static boolean isModuleProperty(EStructuralFeature feature, QvtOperationalEnv env) {
        return env.getUMLReflection().getOwningClassifier((Object)feature) instanceof Module;
    }
}

