/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ConnectionManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ScheduleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.Connection;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingPartition;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.RootPartition;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class CallTreeBuilder {
    private final @NonNull ScheduleAnalysis scheduleCache;
    private final @NonNull ConnectionManager connectionManager;
    private final @NonNull RootPartition rootPartition;
    private final @NonNull LoadingPartition loadingPartition;
    private final @NonNull Map<@NonNull NodeConnection, @NonNull Partition> connection2commonPartition = new HashMap<NodeConnection, Partition>();

    public CallTreeBuilder(@NonNull ScheduleAnalysis scheduleCache, @NonNull RootPartition rootPartition, @NonNull LoadingPartition loadingPartition) {
        this.scheduleCache = scheduleCache;
        this.connectionManager = scheduleCache.getConnectionManager();
        this.rootPartition = rootPartition;
        this.loadingPartition = loadingPartition;
    }

    public void buildTree(@NonNull Iterable<@NonNull Concurrency> partitionSchedule) {
        Stack<@NonNull Partition> callStack = new Stack<Partition>();
        callStack.push((Partition)this.rootPartition);
        for (Concurrency concurrency : partitionSchedule) {
            for (PartitionAnalysis partition : concurrency) {
                this.updateCallStack(callStack, partition.getPartition());
            }
        }
        this.installConnections();
    }

    protected @NonNull Partition getCommonPartition(@NonNull Partition firstPartition, @NonNull Partition secondPartition) {
        if (firstPartition instanceof RootPartition) {
            return firstPartition;
        }
        if (secondPartition instanceof RootPartition) {
            return secondPartition;
        }
        return this.loadingPartition;
    }

    protected @NonNull Partition getMinimumDepthParentPartition(@NonNull Partition childPartition) {
        if (childPartition instanceof RootPartition) {
            return childPartition;
        }
        if (childPartition instanceof LoadingPartition) {
            return this.rootPartition;
        }
        return this.loadingPartition;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void installConnections() {
        Partition commonPartition;
        ArrayList<@NonNull NodeConnection> connections = new ArrayList<NodeConnection>(this.connection2commonPartition.keySet());
        Collections.sort(connections, new Comparator<NodeConnection>(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public int compare(@NonNull NodeConnection o1, @NonNull NodeConnection o2) {
                @NonNull List l1 = o1.getPasses();
                @NonNull List l2 = o2.getPasses();
                int x1 = l1.size() > 0 ? (Integer)l1.get(0) : -1;
                int x2 = l2.size() > 0 ? (Integer)l2.get(0) : -1;
                return x1 - x2;
            }
        });
        for (NodeConnection connection : connections) {
            if (!connection.isPassed()) continue;
            commonPartition = this.connection2commonPartition.get(connection);
            assert (commonPartition != null);
            ArrayList<@NonNull Partition> intermediatePartitions = new ArrayList<Partition>();
            for (Partition sourcePartition : this.scheduleCache.getSourcePartitions((Connection)connection)) {
                if (sourcePartition == commonPartition) continue;
                List<@NonNull Partition> sourcePartitions = Collections.singletonList(sourcePartition);
                this.installConnectionsLocateIntermediates(intermediatePartitions, sourcePartitions, commonPartition);
            }
            for (Partition targetPartition : this.scheduleCache.getTargetPartitions((Connection)connection)) {
                if (targetPartition == commonPartition || !connection.isPassed(targetPartition)) continue;
                List<@NonNull Partition> targetPartitions2 = this.connectionManager.getCallableParents(targetPartition);
                this.installConnectionsLocateIntermediates(intermediatePartitions, targetPartitions2, commonPartition);
            }
            connection.setCommonPartition(commonPartition, intermediatePartitions);
        }
        for (NodeConnection connection : connections) {
            if (!connection.isPassed()) continue;
            commonPartition = connection.getCommonPartition();
            assert (commonPartition != null);
            RootPartition rootPartition = this.scheduleCache.getRootPartition();
            @NonNull List intermediatePartitions = QVTscheduleUtil.getIntermediatePartitions((NodeConnection)connection);
            for (Partition intermediatePartition : intermediatePartitions) {
                RootPartition checkCommonPartition;
                Object object = checkCommonPartition = this.connectionManager.getLoopingConnections(commonPartition).size() > 0 ? rootPartition : commonPartition;
                assert (!(this.connectionManager.getLoopingConnections(commonPartition).size() > 0 ? !Iterables.contains(this.connectionManager.getCallableParents(commonPartition), (Object)this.getCommonPartition(commonPartition, intermediatePartition)) : this.getCommonPartition(commonPartition, intermediatePartition) != checkCommonPartition));
            }
        }
    }

    protected void installConnectionsLocateIntermediates(@NonNull List<@NonNull Partition> intermediatePartitions, @NonNull Iterable<@NonNull Partition> callableParents, @NonNull Partition commonPartition) {
        for (Partition callableParent : callableParents) {
            if (callableParent == commonPartition || intermediatePartitions.contains(callableParent)) continue;
            intermediatePartitions.add(callableParent);
            this.installConnectionsLocateIntermediates(intermediatePartitions, this.connectionManager.getCallableParents(callableParent), commonPartition);
        }
    }

    protected void updateCallStack(@NonNull Stack<@NonNull Partition> callStack, @NonNull Partition partition) {
        QVTm2QVTs.REGION_STACK.println(partition + " => " + callStack);
        Partition topOfStack = callStack.peek();
        assert (topOfStack != null);
        Partition commonPartition = this.getCommonPartition(topOfStack, partition);
        for (Connection incomingConnection1 : this.scheduleCache.getIncomingConnections(partition)) {
            for (Partition sourcePartition1 : this.scheduleCache.getSourcePartitions(incomingConnection1)) {
                for (Connection incomingConnection2 : this.scheduleCache.getIncomingConnections(sourcePartition1)) {
                    for (Partition sourcePartition2 : this.scheduleCache.getSourcePartitions(incomingConnection2)) {
                        commonPartition = this.getCommonPartition(commonPartition, sourcePartition2);
                    }
                }
            }
        }
        while (!callStack.contains(commonPartition)) {
            commonPartition = this.getMinimumDepthParentPartition(commonPartition);
            assert (commonPartition != null);
        }
        while (topOfStack != commonPartition && topOfStack != partition) {
            callStack.pop();
            Partition topOfStack2 = callStack.peek();
            assert (topOfStack2 != null);
            topOfStack = topOfStack2;
        }
        for (Connection incomingConnection : this.scheduleCache.getIncomingConnections(partition)) {
            if (!incomingConnection.isPassed(partition)) continue;
            commonPartition = this.updateConnectionLocality((NodeConnection)incomingConnection, commonPartition);
        }
        if (topOfStack != partition) {
            this.connectionManager.addCallToChild(topOfStack, partition);
            callStack.push(partition);
            topOfStack = partition;
        }
        assert (topOfStack == callStack.peek());
        assert (topOfStack == partition);
    }

    protected @NonNull Partition updateConnectionLocality(@NonNull NodeConnection connection, @NonNull Partition commonStackPartition) {
        Partition commonPartition;
        assert (connection.isPassed());
        Partition oldCommonPartition = this.connection2commonPartition.get(connection);
        if (oldCommonPartition == null) {
            commonPartition = commonStackPartition;
            for (Partition sourcePartition : this.scheduleCache.getSourcePartitions((Connection)connection)) {
                commonPartition = this.getCommonPartition(commonPartition, sourcePartition);
            }
        } else {
            commonPartition = this.getCommonPartition(oldCommonPartition, commonStackPartition);
        }
        if (oldCommonPartition != commonPartition) {
            this.connection2commonPartition.put(connection, commonPartition);
        }
        return commonPartition;
    }
}

