/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractCompositePartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceElementPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.CyclicPartition;

public class CyclicPartitionAnalysis
extends AbstractCompositePartitionAnalysis<CyclicPartition> {
    protected final @NonNull Set<@NonNull PartitionAnalysis> externalPredecessors;

    public static @NonNull CyclicPartitionAnalysis createCyclicPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull String name, @NonNull Set<@NonNull PartitionAnalysis> partitionAnalyses, @NonNull Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> partitionAnalysis2predecessors) {
        HashMap<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> nestedPartitionAnalysis2predecessors = new HashMap<PartitionAnalysis, Set<PartitionAnalysis>>();
        HashSet<@NonNull PartitionAnalysis> externalPredecessors = new HashSet<PartitionAnalysis>();
        for (PartitionAnalysis partitionAnalysis : partitionAnalyses) {
            HashSet<@NonNull E> internalPredecessors = new HashSet(partitionAnalysis2predecessors.get(partitionAnalysis));
            externalPredecessors.addAll(internalPredecessors);
            internalPredecessors.remove(partitionAnalysis);
            internalPredecessors.retainAll(partitionAnalyses);
            nestedPartitionAnalysis2predecessors.put(partitionAnalysis, internalPredecessors);
        }
        externalPredecessors.removeAll(partitionAnalyses);
        assert (!partitionAnalyses.isEmpty());
        ScheduleManager scheduleManager = partitionedTransformationAnalysis.getScheduleManager();
        CyclicPartition cyclicPartition = RegionHelper.createCyclicPartition(name, scheduleManager);
        return new CyclicPartitionAnalysis(partitionedTransformationAnalysis, cyclicPartition, nestedPartitionAnalysis2predecessors, externalPredecessors);
    }

    private CyclicPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull CyclicPartition cyclicPartition, @NonNull Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> partitionAnalysis2predecessors, @NonNull Set<@NonNull PartitionAnalysis> externalPredecessors) {
        super(partitionedTransformationAnalysis, cyclicPartition, partitionAnalysis2predecessors);
        this.externalPredecessors = externalPredecessors;
        partitionedTransformationAnalysis.addPartitionAnalysis(this);
    }

    protected @NonNull List<@NonNull Concurrency> computeRecursiveSchedule(@NonNull Set<@NonNull PartitionAnalysis> recursingSteps) {
        Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> immediatePredecessors = CompilerUtil.computeImmediatePredecessors(recursingSteps);
        for (PartitionAnalysis partitionAnalysis : recursingSteps) {
            Set<@NonNull PartitionAnalysis> predecessors = immediatePredecessors.get(partitionAnalysis);
            assert (predecessors != null);
            predecessors.retainAll(recursingSteps);
        }
        Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> partitionAnalysis2predecessors = CompilerUtil.computeClosure(immediatePredecessors);
        return CompilerUtil.computeParallelSchedule(partitionAnalysis2predecessors);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull List<@NonNull Concurrency> createPartitionSchedule() {
        assert (this.partitionAnalyses.equals(this.originalPartitionAnalysis2predecessors.keySet()));
        HashMap<@NonNull PartitionAnalysis, @NonNull HashSet<@NonNull TraceElementPartitionAnalysis>> partitionAnalysis2acyclicTraceClassAnalyses = new HashMap<PartitionAnalysis, HashSet<TraceElementPartitionAnalysis>>();
        HashMap<@NonNull K, @NonNull @NonNull V> partitionAnalysis2cyclicTraceClassAnalyses = new HashMap();
        HashMap<@NonNull K, @NonNull @NonNull V> partitionAnalysis2mixedTraceClassAnalyses = new HashMap();
        for (PartitionAnalysis consumingPartitionAnalysis : this.partitionAnalyses) {
            Iterable consumedTracePropertyAnalyses;
            assert (!this.externalPredecessors.contains(consumingPartitionAnalysis));
            Iterable<@NonNull TC> consumedTraceClassAnalyses = consumingPartitionAnalysis.getConsumedTraceClassAnalyses();
            if (consumedTraceClassAnalyses != null) {
                for (TraceClassPartitionAnalysis consumedTraceClassAnalysis : consumedTraceClassAnalyses) {
                    Iterable<PartitionAnalysis> producingPartitionAnalyses = consumedTraceClassAnalysis.getProducers();
                    boolean isExternal = false;
                    boolean isInternal = false;
                    Iterator iterator = producingPartitionAnalyses.iterator();
                    while (iterator.hasNext()) {
                        @NonNull PartitionAnalysis producingPartitionAnalysis = (PartitionAnalysis)iterator.next();
                        if (this.partitionAnalyses.contains(producingPartitionAnalysis)) {
                            isInternal = true;
                            continue;
                        }
                        isExternal = true;
                    }
                    HashMap<PartitionAnalysis, HashSet<TraceElementPartitionAnalysis>> partitionAnalysis2traceClassAnalyses = !isInternal ? partitionAnalysis2acyclicTraceClassAnalyses : (!isExternal ? partitionAnalysis2cyclicTraceClassAnalyses : partitionAnalysis2mixedTraceClassAnalyses);
                    HashSet<@NonNull TraceClassPartitionAnalysis> traceClassAnalyses = (HashSet<TraceClassPartitionAnalysis>)partitionAnalysis2traceClassAnalyses.get(consumingPartitionAnalysis);
                    if (traceClassAnalyses == null) {
                        traceClassAnalyses = new HashSet<TraceClassPartitionAnalysis>();
                        partitionAnalysis2traceClassAnalyses.put(consumingPartitionAnalysis, traceClassAnalyses);
                    }
                    traceClassAnalyses.add(consumedTraceClassAnalysis);
                }
            }
            if ((consumedTracePropertyAnalyses = consumingPartitionAnalysis.getConsumedTracePropertyAnalyses()) == null) continue;
            for (TracePropertyPartitionAnalysis tracePropertyPartitionAnalysis : consumedTracePropertyAnalyses) {
                Iterable<@NonNull PartitionAnalysis> producingPartitionAnalyses = tracePropertyPartitionAnalysis.getProducers();
                boolean isExternal = false;
                boolean isInternal = false;
                for (PartitionAnalysis producingPartitionAnalysis : producingPartitionAnalyses) {
                    boolean isInternallyContained = this.partitionAnalyses.contains(producingPartitionAnalysis);
                    boolean isExternallyContained = this.externalPredecessors.contains(producingPartitionAnalysis);
                    assert (!isInternallyContained || !isExternallyContained);
                    if (isInternallyContained) {
                        isInternal = true;
                        continue;
                    }
                    isExternal = true;
                }
                HashMap<PartitionAnalysis, HashSet<TraceElementPartitionAnalysis>> partitionAnalysis2traceClassAnalyses = !isInternal ? partitionAnalysis2acyclicTraceClassAnalyses : (!isExternal ? partitionAnalysis2cyclicTraceClassAnalyses : partitionAnalysis2mixedTraceClassAnalyses);
                HashSet<@NonNull TracePropertyPartitionAnalysis> traceClassAnalyses = (HashSet<TracePropertyPartitionAnalysis>)partitionAnalysis2traceClassAnalyses.get(consumingPartitionAnalysis);
                if (traceClassAnalyses == null) {
                    traceClassAnalyses = new HashSet<TracePropertyPartitionAnalysis>();
                    partitionAnalysis2traceClassAnalyses.put(consumingPartitionAnalysis, traceClassAnalyses);
                }
                traceClassAnalyses.add(tracePropertyPartitionAnalysis);
            }
        }
        HashSet<@NonNull PartitionAnalysis> baseCases = new HashSet<PartitionAnalysis>();
        HashSet<@NonNull PartitionAnalysis> recursiveCases = new HashSet<PartitionAnalysis>();
        HashSet<@NonNull PartitionAnalysis> recursingSteps = new HashSet<PartitionAnalysis>();
        for (PartitionAnalysis partitionAnalysis : this.partitionAnalyses) {
            @NonNull Set acyclicTraceClassAnalyses = (Set)partitionAnalysis2acyclicTraceClassAnalyses.get(partitionAnalysis);
            @NonNull Set cyclicTraceClassAnalyses = (Set)partitionAnalysis2cyclicTraceClassAnalyses.get(partitionAnalysis);
            @NonNull Set mixedTraceClassAnalyses = (Set)partitionAnalysis2mixedTraceClassAnalyses.get(partitionAnalysis);
            if (mixedTraceClassAnalyses == null) {
                if (cyclicTraceClassAnalyses == null) {
                    if (acyclicTraceClassAnalyses == null ? !$assertionsDisabled : !$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue;
                }
                recursingSteps.add(partitionAnalysis);
                continue;
            }
            if (cyclicTraceClassAnalyses == null) {
                baseCases.add(partitionAnalysis);
                continue;
            }
            recursiveCases.add(partitionAnalysis);
        }
        ArrayList<@NonNull Concurrency> partitionSchedule = new ArrayList<Concurrency>();
        this.appendConcurrency(partitionSchedule, baseCases);
        if (recursingSteps.size() <= 1) {
            this.appendConcurrency(partitionSchedule, recursingSteps);
        } else {
            for (Iterable iterable : this.computeRecursiveSchedule(recursingSteps)) {
                this.appendConcurrency(partitionSchedule, iterable);
            }
        }
        this.appendConcurrency(partitionSchedule, recursiveCases);
        ((Concurrency)partitionSchedule.get(0)).setCycleStart();
        ((Concurrency)partitionSchedule.get(partitionSchedule.size() - 1)).setCycleEnd();
        return partitionSchedule;
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassPartitionAnalysis> getConsumedTraceClassAnalyses() {
        return null;
    }

    @Override
    public @Nullable Iterable<@NonNull TracePropertyPartitionAnalysis> getConsumedTracePropertyAnalyses() {
        return null;
    }

    @Override
    public @NonNull Set<@NonNull PartitionAnalysis> getExplicitPredecessors() {
        return this.externalPredecessors;
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassPartitionAnalysis> getProducedTraceClassAnalyses() {
        return null;
    }

    @Override
    public @Nullable Iterable<@NonNull TracePropertyPartitionAnalysis> getProducedTracePropertyAnalyses() {
        return null;
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassPartitionAnalysis> getSuperProducedTraceClassAnalyses() {
        return null;
    }
}

