/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.Partitioner;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class AssignmentPartition
extends AbstractPartition {
    protected final @NonNull Edge realizedEdge;

    public AssignmentPartition(@NonNull Partitioner partitioner, @NonNull Edge realizedEdge) {
        super(partitioner);
        this.realizedEdge = realizedEdge;
        for (Node node : partitioner.getRealizedMiddleNodes()) {
            this.addNode(node, QVTscheduleUtil.asPredicated((Role)RegionUtil.getNodeRole((Node)node)));
        }
        this.gatherSourceNavigations(realizedEdge.getEdgeSource());
        this.gatherSourceNavigations(realizedEdge.getEdgeTarget());
        this.resolveEdgeRoles();
    }

    private void gatherSourceNavigations(@NonNull Node targetNode) {
        if (!this.hasNode(targetNode)) {
            Role targetNodeRole = RegionUtil.getNodeRole((Node)targetNode);
            if (targetNodeRole == Role.REALIZED) {
                targetNodeRole = QVTscheduleUtil.asPredicated((Role)targetNodeRole);
            }
            this.addNode(targetNode, targetNodeRole);
            boolean hasPredecessor = false;
            for (Node sourceNode : this.getPredecessors(targetNode)) {
                hasPredecessor = true;
                this.gatherSourceNavigations(sourceNode);
            }
            if (!hasPredecessor && targetNode.isPredicated()) {
                for (NavigableEdge edge : targetNode.getNavigationEdges()) {
                    if (!edge.isPredicated() || edge.getOppositeEdge() != null) continue;
                    Node nonUnitSourceNode = edge.getEdgeTarget();
                    this.gatherSourceNavigations(nonUnitSourceNode);
                }
            }
        }
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Role edgeRole = RegionUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED && this.partitioner.hasRealizedEdge(edge)) {
            edgeRole = Role.PREDICATED;
        }
        return edgeRole;
    }
}

