/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.DatumConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduleCache;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Scheduler;

public class CallTreeBuilder {
    private final @NonNull ScheduleCache scheduleCache;
    private final @NonNull Map<@NonNull NodeConnection, @NonNull Region> connection2commonRegion = new HashMap<NodeConnection, Region>();

    public CallTreeBuilder(@NonNull ScheduleCache scheduleCache) {
        this.scheduleCache = scheduleCache;
    }

    public void buildTree(@NonNull RootScheduledRegion rootScheduledRegion, @NonNull List<@NonNull Region> orderedRegions) {
        Stack<@NonNull Region> callStack = new Stack<Region>();
        callStack.push(rootScheduledRegion);
        for (Region region : orderedRegions) {
            this.updateCallStack(callStack, region);
        }
        this.installConnections();
    }

    protected @NonNull Region getCommonRegion(@NonNull Region firstRegion, @NonNull Region secondRegion) {
        Region commonRegion = this.scheduleCache.getCommonRegion(firstRegion, secondRegion);
        assert (commonRegion != null);
        return commonRegion;
    }

    protected @NonNull Region getMinimumDepthParentRegion(@NonNull Region childRegion) {
        Region minimumDepthParentRegion = this.scheduleCache.getMinimumDepthParentRegion(childRegion);
        assert (minimumDepthParentRegion != null);
        return minimumDepthParentRegion;
    }

    protected void installConnections() {
        List<Object> intermediateRegions;
        Region commonRegion;
        for (NodeConnection connection : this.connection2commonRegion.keySet()) {
            if (!connection.isPassed()) continue;
            commonRegion = this.connection2commonRegion.get(connection);
            assert (commonRegion != null);
            intermediateRegions = new ArrayList();
            for (Region region : this.scheduleCache.getSourceRegions(connection)) {
                if (region == commonRegion) continue;
                List<@NonNull Region> sourceRegions = Collections.singletonList(region);
                this.installConnectionsLocateIntermediates(intermediateRegions, sourceRegions, commonRegion);
            }
            for (Region region : this.scheduleCache.getTargetRegions(connection)) {
                if (region == commonRegion || !connection.isPassed(region)) continue;
                Iterable<@NonNull Region> targetRegions2 = region.getCallableParents();
                this.installConnectionsLocateIntermediates(intermediateRegions, targetRegions2, commonRegion);
            }
            connection.setCommonRegion(commonRegion, intermediateRegions);
        }
        for (NodeConnection connection : this.connection2commonRegion.keySet()) {
            if (!connection.isPassed()) continue;
            commonRegion = connection.getCommonRegion();
            assert (commonRegion != null);
            intermediateRegions = connection.getIntermediateRegions();
            for (Region region : intermediateRegions) {
                Region checkCommonRegion;
                Region region2 = checkCommonRegion = commonRegion.getLoopingConnections().size() > 0 ? commonRegion.getInvokingRegion() : commonRegion;
                assert (!(commonRegion.getLoopingConnections().size() > 0 ? !Iterables.contains(commonRegion.getCallableParents(), (Object)this.getCommonRegion(commonRegion, region)) : this.getCommonRegion(commonRegion, region) != checkCommonRegion));
            }
        }
    }

    protected void installConnectionsLocateIntermediates(@NonNull List<@NonNull Region> intermediateRegions, @NonNull Iterable<@NonNull Region> callableParents, @NonNull Region commonRegion) {
        for (Region callableParent : callableParents) {
            if (callableParent == commonRegion || intermediateRegions.contains(callableParent)) continue;
            intermediateRegions.add(callableParent);
            this.installConnectionsLocateIntermediates(intermediateRegions, callableParent.getCallableParents(), commonRegion);
        }
    }

    protected void updateCallStack(@NonNull Stack<@NonNull Region> callStack, @NonNull Region region) {
        Scheduler.REGION_STACK.println(String.valueOf(region.getSymbolName()) + " => " + callStack);
        Region topOfStack = callStack.peek();
        assert (topOfStack != null);
        @NonNull Region commonRegion = this.getCommonRegion(topOfStack, region);
        for (DatumConnection incomingConnection1 : this.scheduleCache.getIncomingConnections(region)) {
            for (Region sourceRegion1 : this.scheduleCache.getSourceRegions(incomingConnection1)) {
                for (DatumConnection incomingConnection2 : this.scheduleCache.getIncomingConnections(sourceRegion1)) {
                    for (Region sourceRegion2 : this.scheduleCache.getSourceRegions(incomingConnection2)) {
                        commonRegion = this.getCommonRegion(commonRegion, sourceRegion2);
                    }
                }
            }
        }
        while (!callStack.contains(commonRegion)) {
            commonRegion = this.getMinimumDepthParentRegion(commonRegion);
            assert (commonRegion != null);
        }
        while (topOfStack != commonRegion && topOfStack != region) {
            callStack.pop();
            Region topOfStack2 = callStack.peek();
            assert (topOfStack2 != null);
            topOfStack = topOfStack2;
        }
        for (DatumConnection incomingConnection : this.scheduleCache.getIncomingConnections(region)) {
            if (!incomingConnection.isPassed(region)) continue;
            commonRegion = this.updateConnectionLocality((NodeConnection)incomingConnection, commonRegion);
        }
        if (topOfStack != region) {
            topOfStack.addCallToChild(region);
            callStack.push(region);
            topOfStack = region;
        }
        assert (topOfStack == callStack.peek());
        assert (topOfStack == region);
    }

    protected @NonNull Region updateConnectionLocality(@NonNull NodeConnection connection, @NonNull Region commonStackRegion) {
        Region commonRegion;
        assert (connection.isPassed());
        Region oldCommonRegion = this.connection2commonRegion.get(connection);
        if (oldCommonRegion == null) {
            commonRegion = commonStackRegion;
            for (Region sourceRegion : this.scheduleCache.getSourceRegions(connection)) {
                commonRegion = this.getCommonRegion(commonRegion, sourceRegion);
            }
        } else {
            commonRegion = this.getCommonRegion(oldCommonRegion, commonStackRegion);
        }
        if (oldCommonRegion != commonRegion) {
            this.connection2commonRegion.put(connection, commonRegion);
        }
        return commonRegion;
    }
}

