/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.etl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.eol.EolModule;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.dom.Operation;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.qvtd.compiler.internal.etl.EpsilonTask;
import org.eclipse.qvtd.compiler.internal.etl.QvtMtcExecutionException;

public class EolTask
extends EpsilonTask {
    public EolTask(URI eolSourceURI) {
        this.sourceURI = eolSourceURI;
        this.models = new ArrayList();
    }

    public EolModule createModule() {
        return new EolModule();
    }

    @Override
    public List<IModel> getModels() {
        return this.models;
    }

    public void prepare() throws QvtMtcExecutionException {
        this.module = this.createModule();
        try {
            this.module.parse(this.sourceURI);
        }
        catch (Exception e) {
            throw new QvtMtcExecutionException("There was an error loading the source.", e.getCause());
        }
        if (this.module.getParseProblems().size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (ParseProblem problem : this.module.getParseProblems()) {
                sb.append(String.valueOf(problem.toString()) + "\\n");
            }
            throw new QvtMtcExecutionException("Parse errors occured: " + sb.toString());
        }
        for (IModel model : this.getModels()) {
            this.module.getContext().getModelRepository().addModel(model);
        }
    }

    public void close() throws QvtMtcExecutionException {
        for (IModel model : this.getModels()) {
            if (model.isStoredOnDisposal()) {
                try {
                    model.store();
                }
                catch (Exception e) {
                    throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
                }
            }
            this.module.getContext().getModelRepository().removeModel(model);
        }
    }

    public void executeOperation(String operationName) throws QvtMtcExecutionException {
        this.prepare();
        this.preProcess();
        this.result = this.executeOperation(this.module, operationName);
        this.postProcess();
    }

    public void executeFromFirstOperation() throws QvtMtcExecutionException {
        this.prepare();
        Operation operation = (Operation)this.module.getDeclaredOperations().get(0);
        this.preProcess();
        try {
            this.result = operation.execute(null, Collections.EMPTY_LIST, this.module.getContext());
        }
        catch (EolRuntimeException e) {
            throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
        }
        this.postProcess();
        for (IModel model : this.getModels()) {
            if (model.isStoredOnDisposal()) {
                try {
                    model.store();
                }
                catch (Exception e) {
                    throw new QvtMtcExecutionException(e.getMessage(), e.getCause());
                }
            }
            this.module.getContext().getModelRepository().removeModel(model);
        }
    }

    private Object executeOperation(IEolExecutableModule module, String operationName) throws QvtMtcExecutionException {
        Operation operation = module.getDeclaredOperations().getOperation(operationName);
        if (operation != null) {
            try {
                return operation.execute(null, Collections.EMPTY_LIST, module.getContext());
            }
            catch (EolRuntimeException e) {
                e.printStackTrace();
                throw new QvtMtcExecutionException(e.getMessage());
            }
        }
        return null;
    }
}

