/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.library.stdlib;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.PrimitiveValueExpression;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.program.ArrayAccessExpression;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.GeneratedFunctionDefinition;
import org.eclipse.mita.program.NewInstanceExpression;
import org.eclipse.mita.program.ReturnStatement;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.inferrer.ElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.ElementSizeInferrer;
import org.eclipse.mita.program.inferrer.InvalidElementSizeInferenceResult;
import org.eclipse.mita.program.inferrer.ValidElementSizeInferenceResult;
import org.eclipse.mita.program.model.ModelUtils;

public class OptionalSizeInferrer
extends ElementSizeInferrer {
    @Inject
    private ITypeSystemInferrer typeInferrer;

    protected ElementSizeInferenceResult _doInfer(VariableDeclaration obj) {
        TypeSpecifier type;
        ElementSizeInferenceResult result;
        Expression _initialization = obj.getInitialization();
        ElementSizeInferenceResult _infer = null;
        if (_initialization != null) {
            _infer = this.infer((EObject)_initialization);
        }
        if ((result = _infer) instanceof ValidElementSizeInferenceResult) {
            return result;
        }
        TypeSpecifier _typeSpecifier = obj.getTypeSpecifier();
        EList _typeArguments = null;
        if (_typeSpecifier != null) {
            _typeArguments = _typeSpecifier.getTypeArguments();
        }
        TypeSpecifier _get = null;
        if (_typeArguments != null) {
            _get = (TypeSpecifier)_typeArguments.get(0);
        }
        if ((type = _get) != null) {
            return new ValidElementSizeInferenceResult((EObject)obj, type, 1);
        }
        return this.newInvalidResult((EObject)obj, "Cannot infer size for this optional, since I can't infer the type of it");
    }

    protected ElementSizeInferenceResult _doInfer(ElementReferenceExpression obj) {
        boolean _isOperationCall = obj.isOperationCall();
        if (_isOperationCall) {
            EObject refFun = obj.getReference();
            ITypeSystemInferrer.InferenceResult refType = this.typeInferrer.infer(refFun);
            if (refFun instanceof GeneratedFunctionDefinition) {
                boolean _and = false;
                if (!Objects.equal((Object)((GeneratedFunctionDefinition)refFun).getName(), (Object)"none") && !Objects.equal((Object)((GeneratedFunctionDefinition)refFun).getName(), (Object)"some")) {
                    _and = false;
                } else {
                    boolean _equals;
                    Type _type = null;
                    if (refType != null) {
                        _type = refType.getType();
                    }
                    String _name = null;
                    if (_type != null) {
                        _name = _type.getName();
                    }
                    _and = _equals = Objects.equal((Object)_name, (Object)"optional");
                }
                if (_and) {
                    TypeSpecifier _specifier = ModelUtils.toSpecifier((ITypeSystemInferrer.InferenceResult)refType);
                    return new ValidElementSizeInferenceResult((EObject)obj, _specifier, 1);
                }
            }
        }
        return super.infer(obj.getReference());
    }

    protected ElementSizeInferenceResult _doInfer(PrimitiveValueExpression obj) {
        TypeSpecifier parentType = ModelUtils.toSpecifier((ITypeSystemInferrer.InferenceResult)this.typeInferrer.infer(obj.eContainer()));
        if (parentType == null) {
            return new InvalidElementSizeInferenceResult((EObject)obj, parentType, "parent type unknown");
        }
        return new ValidElementSizeInferenceResult((EObject)obj, parentType, 1);
    }

    protected ElementSizeInferenceResult inferFromType(EObject obj, TypeSpecifier typeSpec) {
        if (typeSpec != null) {
            ValidElementSizeInferenceResult res = new ValidElementSizeInferenceResult(obj, typeSpec, 1);
            return res;
        }
        return super.inferFromType(obj, typeSpec);
    }

    protected ElementSizeInferenceResult doInfer(EObject obj) {
        if (obj instanceof FunctionDefinition) {
            return this._doInfer((FunctionDefinition)obj);
        }
        if (obj instanceof VariableDeclaration) {
            return this._doInfer((VariableDeclaration)obj);
        }
        if (obj instanceof NewInstanceExpression) {
            return this._doInfer((NewInstanceExpression)obj);
        }
        if (obj instanceof ElementReferenceExpression) {
            return this._doInfer((ElementReferenceExpression)obj);
        }
        if (obj instanceof PrimitiveValueExpression) {
            return this._doInfer((PrimitiveValueExpression)obj);
        }
        if (obj instanceof ArrayAccessExpression) {
            return this._doInfer((ArrayAccessExpression)obj);
        }
        if (obj instanceof ReturnStatement) {
            return this._doInfer((ReturnStatement)obj);
        }
        if (obj != null) {
            return this._doInfer(obj);
        }
        if (obj == null) {
            return this._doInfer(null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(obj).toString());
    }
}

