/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.arduino.platform;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.TimeIntervalEvent;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IPlatformEventLoopGenerator;
import org.eclipse.mita.program.generator.IPlatformTimeGenerator;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.xbase.lib.Extension;

public class TimeGenerator
implements IPlatformTimeGenerator {
    @Inject
    @Extension
    protected CodeFragmentProvider codeFragmentProvider;
    @Inject
    protected IPlatformEventLoopGenerator eventLoopGenerator;
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;

    public CodeFragment generateTimeEnable(CompilationContext context, EventHandlerDeclaration handler) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Timer_Enable();");
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateTimeGoLive(CompilationContext context) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateTimeSetup(final CompilationContext context) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Exception_T result = STATUS_OK;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"result = Timer_Connect();");
                _builder.newLine();
                _builder.append((Object)"if(result != STATUS_OK)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"return result;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        CodeFragment body = this.codeFragmentProvider.create(_client);
        CodeFragment _create = this.codeFragmentProvider.create((CompositeGeneratorNode)body);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Iterable _allTimeEvents = TimeGenerator.this._generatorUtils.getAllTimeEvents(context);
                for (EventHandlerDeclaration handler : _allTimeEvents) {
                    EventSource _event = handler.getEvent();
                    int period = ModelUtils.getIntervalInMilliseconds((TimeIntervalEvent)((TimeIntervalEvent)_event));
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"static uint32_t count_");
                    _builder.append((Object)period);
                    _builder.append((Object)" = 0;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"bool get");
                    String _handlerName = TimeGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName);
                    _builder.append((Object)"_flag(){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"return ");
                    String _handlerName_1 = TimeGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName_1, "\t");
                    _builder.append((Object)"_flag;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append((Object)"void set");
                    String _handlerName_2 = TimeGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName_2);
                    _builder.append((Object)"_flag(bool val){");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    String _handlerName_3 = TimeGenerator.this._generatorUtils.getHandlerName((EObject)handler);
                    _builder.append((Object)_handlerName_3, "\t");
                    _builder.append((Object)"_flag = val;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"Exception_T Tick_Timer(void)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                Iterable _allTimeEvents_1 = TimeGenerator.this._generatorUtils.getAllTimeEvents(context);
                for (EventHandlerDeclaration handler_1 : _allTimeEvents_1) {
                    EventSource _event_1 = handler_1.getEvent();
                    int period_1 = ModelUtils.getIntervalInMilliseconds((TimeIntervalEvent)((TimeIntervalEvent)_event_1));
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"count_");
                    _builder.append((Object)period_1, "\t");
                    _builder.append((Object)"++;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"if(count_");
                    _builder.append((Object)period_1, "\t");
                    _builder.append((Object)" % ");
                    _builder.append((Object)period_1, "\t");
                    _builder.append((Object)" == 0)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"count_");
                    _builder.append((Object)period_1, "\t\t");
                    _builder.append((Object)" = 0;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t");
                    String _handlerName_4 = TimeGenerator.this._generatorUtils.getHandlerName((EObject)handler_1);
                    _builder.append((Object)_handlerName_4, "\t\t");
                    _builder.append((Object)"_flag = true;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"return STATUS_OK;");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
            }
        };
        return _create.setPreamble(_client_1).addHeader("MitaExceptions.h", false).addHeader("MitaEvents.h", false).addHeader("MitaTime.h", false).addHeader("Timer.h", false);
    }

    public CodeFragment generateAdditionalHeaderContent(CompilationContext context) {
        return CodeFragment.EMPTY;
    }
}

