/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.base.scoping;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mita.base.scoping.ILibraryProvider;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypesPackage;
import org.eclipse.mita.base.types.typesystem.GenericTypeSystem;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class MitaTypeSystem
extends GenericTypeSystem {
    @Inject
    protected ILibraryProvider libraryProvider;
    public static final String ITERABLE_TYPE = "iterable";
    public static final String REFERENCE_TYPE = "reference";
    public static final String OPTINAL_TYPE = "optional";
    public static final String SIGINST_TYPE = "siginst";
    public static final String MODALITY_TYPE = "modality";
    public static final String ARRAY_TYPE = "array";
    public static final String INT32_TYPE = "int32";
    public static final String DOUBLE_TYPE = "double";
    public static final String FLOAT_TYPE = "float";
    public static final String BOOL_TYPE = "bool";
    private static MitaTypeSystem INSTANCE = new MitaTypeSystem();
    private boolean nativeTypesLoaded = false;

    protected MitaTypeSystem() {
    }

    public static MitaTypeSystem getInstance() {
        return INSTANCE;
    }

    @Override
    protected void initRegistries() {
        super.initRegistries();
        Type _type = this.getType("integer");
        _type.setAbstract(true);
        Type _type_1 = this.getType("real");
        _type_1.setAbstract(true);
        Type _type_2 = this.getType("boolean");
        _type_2.setAbstract(true);
        Type _type_3 = this.getType("any");
        _type_3.setAbstract(true);
        Type _type_4 = this.getType("string");
        _type_4.setAbstract(true);
    }

    @Override
    public Type getType(String type) {
        Type _xblockexpression = null;
        Type result = super.getType(type);
        if (result == null) {
            this.lazyLoadNativeTypes();
            return super.getType(type);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    @Override
    public Collection<Type> getTypes() {
        Collection<Type> _xblockexpression = null;
        this.lazyLoadNativeTypes();
        _xblockexpression = super.getTypes();
        return _xblockexpression;
    }

    protected boolean lazyLoadNativeTypes() {
        boolean _xifexpression = false;
        if (!this.nativeTypesLoaded) {
            boolean _xblockexpression = false;
            Consumer<URI> _function = new Consumer<URI>(){

                @Override
                public void accept(URI it) {
                    Consumer<IEObjectDescription> _function = new Consumer<IEObjectDescription>(){

                        @Override
                        public void accept(IEObjectDescription type) {
                            EObject _eObjectOrProxy = type.getEObjectOrProxy();
                            EObject _eObjectOrProxy_1 = type.getEObjectOrProxy();
                            MitaTypeSystem.this.declareType((Type)_eObjectOrProxy, ((Type)_eObjectOrProxy_1).getName());
                        }
                    };
                    MitaTypeSystem.this.getExportedTypes(it).forEach(_function);
                }
            };
            IterableExtensions.toSet(this.libraryProvider.getDefaultLibraries()).forEach(_function);
            this.nativeTypesLoaded = true;
            _xifexpression = _xblockexpression = true;
        }
        return _xifexpression;
    }

    public Iterable<IEObjectDescription> getExportedTypes(URI libraryUri) {
        XtextResourceSet set = new XtextResourceSet();
        Resource resource = set.getResource(libraryUri, true);
        IResourceServiceProvider.Registry registry = IResourceServiceProvider.Registry.INSTANCE;
        IResourceServiceProvider resourceServiceProvider = registry.getResourceServiceProvider(libraryUri);
        if (resourceServiceProvider == null) {
            return Collections.emptySet();
        }
        IResourceDescription.Manager resourceDescriptionManager = resourceServiceProvider.getResourceDescriptionManager();
        if (resourceDescriptionManager == null) {
            return Collections.emptySet();
        }
        IResourceDescription resourceDescription = resourceDescriptionManager.getResourceDescription(resource);
        if (resourceDescription == null) {
            return Collections.emptySet();
        }
        return resourceDescription.getExportedObjectsByType(TypesPackage.Literals.TYPE);
    }
}

