/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.sensors;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.Event;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.program.EventHandlerDeclaration;
import org.eclipse.mita.program.EventSource;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.ModalityAccessPreparation;
import org.eclipse.mita.program.SystemEventSource;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.CodeFragmentProvider;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ButtonGenerator
extends AbstractSystemResourceGenerator {
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected CodeFragmentProvider codeFragmentProvider;

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"return BSP_Button_Connect();");
                _builder.newLine();
            }
        };
        CodeFragment _addHeader = this.codeFragmentProvider.create(_client).addHeader("BCDS_Basics.h", true, 1000).addHeader("BCDS_CmdProcessor.h", true).addHeader("BSP_BoardType.h", true, 750).addHeader("BCDS_BSP_Button.h", true).addHeader("MitaEvents.h", true);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                Functions.Function1<EventHandlerDeclaration, Integer> _function = new Functions.Function1<EventHandlerDeclaration, Integer>(){

                    public Integer apply(EventHandlerDeclaration it) {
                        return ButtonGenerator.this.getButtonNumber(ButtonGenerator.this.getSensorInstance(it));
                    }
                };
                Collection _values = IterableExtensions.groupBy((Iterable)ButtonGenerator.this.eventHandler, (Functions.Function1)_function).values();
                for (List handlergrp : _values) {
                    _builder.append((Object)"void ");
                    CharSequence _internalHandlerName = ButtonGenerator.this.getInternalHandlerName((EventHandlerDeclaration)IterableExtensions.head((Iterable)handlergrp));
                    _builder.append((Object)_internalHandlerName);
                    _builder.append((Object)"(uint32_t data)");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    Iterable _indexed = IterableExtensions.indexed((Iterable)handlergrp);
                    for (Pair idx_handler : _indexed) {
                        boolean _greaterThan;
                        _builder.append((Object)"\t");
                        Integer _key = (Integer)idx_handler.getKey();
                        boolean bl = _greaterThan = _key > 0;
                        if (_greaterThan) {
                            _builder.append((Object)"else ");
                        }
                        _builder.append((Object)"if(data == ");
                        String _buttonStatusEnumName = ButtonGenerator.this.getButtonStatusEnumName((EventHandlerDeclaration)idx_handler.getValue());
                        _builder.append((Object)_buttonStatusEnumName, "\t");
                        _builder.append((Object)") {");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"Retcode_T retcode = CmdProcessor_enqueueFromIsr(&Mita_EventQueue, ");
                        String _handlerName = ButtonGenerator.this._generatorUtils.getHandlerName((EObject)idx_handler.getValue());
                        _builder.append((Object)_handlerName, "\t\t");
                        _builder.append((Object)", NULL, data);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"if(retcode != RETCODE_OK)");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"Retcode_RaiseErrorFromIsr(retcode);");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}");
                        _builder.newLine();
                    }
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.newLine();
                }
            }
        };
        return _addHeader.setPreamble(_client_1);
    }

    public CodeFragment generateEnable() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T retcode = NO_EXCEPTION;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"retcode = BSP_Button_Enable((uint32_t) BSP_XDK_BUTTON_");
                int _buttonNumber = ButtonGenerator.this.getButtonNumber(ButtonGenerator.this.getSensorInstance((EventHandlerDeclaration)IterableExtensions.head((Iterable)ButtonGenerator.this.eventHandler)));
                _builder.append((Object)_buttonNumber);
                _builder.append((Object)", ");
                CharSequence _internalHandlerName = ButtonGenerator.this.getInternalHandlerName((EventHandlerDeclaration)IterableExtensions.head((Iterable)ButtonGenerator.this.eventHandler));
                _builder.append((Object)_internalHandlerName);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"if(retcode != NO_EXCEPTION) return retcode;");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    private CharSequence getInternalHandlerName(EventHandlerDeclaration handler) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Button");
        String _firstUpper = StringExtensions.toFirstUpper((String)this.getButtonName(this.getSensorInstance(handler)));
        _builder.append(_firstUpper);
        _builder.append("_OnEvent");
        return _builder;
    }

    private String getButtonStatusEnumName(EventHandlerDeclaration handler) {
        boolean _equals;
        String _xifexpression = null;
        EventSource _event = handler.getEvent();
        Event _source = null;
        if ((SystemEventSource)_event != null) {
            _source = ((SystemEventSource)_event).getSource();
        }
        String _name = null;
        if (_source != null) {
            _name = _source.getName();
        }
        _xifexpression = (_equals = Objects.equal((Object)_name, (Object)"released")) ? "RELEASE" : "PRESS";
        return "BSP_XDK_BUTTON_" + _xifexpression;
    }

    private AbstractSystemResource getSensorInstance(EventHandlerDeclaration declaration) {
        EventSource _event = declaration.getEvent();
        SystemEventSource event = (SystemEventSource)_event;
        AbstractSystemResource _origin = event.getOrigin();
        return _origin;
    }

    private String getButtonName(AbstractSystemResource origin) {
        return (String)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)origin.getName().split("_"))));
    }

    private int getButtonNumber(AbstractSystemResource declaration) {
        int _xifexpression = 0;
        String _buttonName = this.getButtonName(declaration);
        boolean _equals = Objects.equal((Object)_buttonName, (Object)"one");
        _xifexpression = _equals ? 1 : 2;
        return _xifexpression;
    }

    public CodeFragment generateAccessPreparationFor(ModalityAccessPreparation preparation) {
        return CodeFragment.EMPTY;
    }

    public CodeFragment generateModalityAccessFor(ModalityAccess modality) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"(BSP_Button_GetState((uint32_t) BSP_XDK_BUTTON_");
                int _buttonNumber = ButtonGenerator.this.getButtonNumber(ButtonGenerator.this.component);
                _builder.append((Object)_buttonNumber);
                _builder.append((Object)") == 1)");
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BSP_BoardType.h", true, 750).addHeader("BCDS_BSP_Button.h", true);
    }
}

