/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.cli;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.eclipse.mita.base.TypeDslStandaloneSetup;
import org.eclipse.mita.cli.commands.AbstractCommand;
import org.eclipse.mita.cli.commands.CompileCommand;
import org.eclipse.mita.cli.commands.LanguageServerCommand;
import org.eclipse.mita.cli.commands.UnknownCommand;
import org.eclipse.mita.cli.loader.StandaloneModule;
import org.eclipse.mita.platform.PlatformDSLRuntimeModule;
import org.eclipse.mita.platform.PlatformDSLStandaloneSetup;
import org.eclipse.mita.program.ProgramDslRuntimeModule;
import org.eclipse.mita.program.ProgramDslStandaloneSetup;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class Main {
    protected static final Map<String, Class<? extends AbstractCommand>> commands = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{Pair.of((Object)"compile", CompileCommand.class), Pair.of((Object)"language-server", LanguageServerCommand.class), Pair.of((Object)"", UnknownCommand.class)}));

    public static void main(String[] args) {
        try {
            Class<? extends AbstractCommand> _get_1;
            boolean _lessThan;
            int _length = args.length;
            boolean bl = _lessThan = _length < 1;
            if (_lessThan) {
                Main.printUsage();
                return;
            }
            String commandName = args[0];
            Class<? extends AbstractCommand> _elvis = null;
            Class<? extends AbstractCommand> _get = commands.get(commandName);
            _elvis = _get != null ? _get : (_get_1 = commands.get(""));
            Class<? extends AbstractCommand> commandClass = _elvis;
            AbstractCommand command = commandClass.newInstance();
            Options commandOptions = command.getOptions();
            CommandLine _xifexpression = null;
            if (commandOptions != null) {
                CommandLine _xblockexpression = null;
                GnuParser parser = new GnuParser();
                CommandLine _xtrycatchfinallyexpression = null;
                try {
                    _xtrycatchfinallyexpression = parser.parse(commandOptions, (String[])Conversions.unwrapArray(((List)Conversions.doWrapArray((Object)args)).subList(1, args.length), String.class));
                }
                catch (Throwable _t) {
                    if (_t instanceof MissingOptionException) {
                        MissingOptionException e = (MissingOptionException)_t;
                        System.err.println(e.getMessage());
                        Main.printUsage(commandName, commandOptions);
                        return;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                _xifexpression = _xblockexpression = _xtrycatchfinallyexpression;
            } else {
                _xifexpression = null;
            }
            CommandLine commandLine = _xifexpression;
            TypeDslStandaloneSetup.doSetup();
            ProgramDslRuntimeModule _programDslRuntimeModule = new ProgramDslRuntimeModule();
            Modules.OverriddenModuleBuilder _override = Modules.override((Module[])new Module[]{_programDslRuntimeModule});
            StandaloneModule _standaloneModule = new StandaloneModule();
            Injector injector = Guice.createInjector((Module[])new Module[]{_override.with(new Module[]{_standaloneModule})});
            new ProgramDslStandaloneSetup().register(injector);
            PlatformDSLRuntimeModule _platformDSLRuntimeModule = new PlatformDSLRuntimeModule();
            Modules.OverriddenModuleBuilder _override_1 = Modules.override((Module[])new Module[]{_platformDSLRuntimeModule});
            StandaloneModule _standaloneModule_1 = new StandaloneModule();
            Injector platformInjector = Guice.createInjector((Module[])new Module[]{_override_1.with(new Module[]{_standaloneModule_1})});
            new PlatformDSLStandaloneSetup().register(platformInjector);
            injector.injectMembers((Object)command);
            InputOutput.println((Object)"Warning: mita CLI tooling is still experimental. Here be dragons.");
            boolean execute = command.init(commandName, commandLine);
            if (execute) {
                command.run();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String printUsage() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("usage: mita [command]");
        _builder.newLine();
        _builder.append("where command is: ");
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String it) {
                boolean _isEmpty = it.isEmpty();
                return !_isEmpty;
            }
        };
        String _join = IterableExtensions.join((Iterable)IterableExtensions.filter(commands.keySet(), (Functions.Function1)_function), (CharSequence)", ");
        _builder.append(_join);
        return (String)InputOutput.println((Object)_builder.toString());
    }

    public static void printUsage(String command, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("mita " + command, options);
    }
}

