/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.logging.Logger;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.interfaces.ProducesConsumesClient;
import org.eclipse.microprofile.rest.client.tck.providers.ProducesConsumesFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProducesConsumesTest
extends Arquillian {
    private static final Logger LOG = Logger.getLogger(ProducesConsumesTest.class.getName());
    public static final String XML_PAYLOAD = "<some><wrapped>value</wrapped></some>";
    public static final String JSON_PAYLOAD = "{\"some\": \"value\"}";

    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ProducesConsumesTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{ProducesConsumesClient.class, ProducesConsumesFilter.class});
    }

    @Test
    public void testProducesConsumesAnnotationOnMethod() {
        String m = "testProducesConsumesAnnotationOnClientInterface";
        ProducesConsumesClient client = (ProducesConsumesClient)((RestClientBuilder)RestClientBuilder.newBuilder().baseUri(URI.create("http://localhost:8080/null")).register(ProducesConsumesFilter.class)).build(ProducesConsumesClient.class);
        LOG.info("testProducesConsumesAnnotationOnClientInterface @Produce(application/json) @Consume(application/xml)");
        Response r = client.produceJSONConsumeXML(XML_PAYLOAD);
        String acceptHeader = r.getHeaderString("Sent-Accept");
        LOG.info("testProducesConsumesAnnotationOnClientInterfaceSent-Accept: " + acceptHeader);
        String contentTypeHeader = r.getHeaderString("Sent-ContentType");
        LOG.info("testProducesConsumesAnnotationOnClientInterfaceSent-ContentType: " + contentTypeHeader);
        Assert.assertEquals((String)acceptHeader, (String)"application/json");
        Assert.assertEquals((String)contentTypeHeader, (String)"application/xml");
        LOG.info("testProducesConsumesAnnotationOnClientInterface @Produce(application/xml) @Consume(application/json)");
        r = client.produceXMLConsumeJSON(JSON_PAYLOAD);
        acceptHeader = r.getHeaderString("Sent-Accept");
        LOG.info("testProducesConsumesAnnotationOnClientInterfaceSent-Accept: " + acceptHeader);
        contentTypeHeader = r.getHeaderString("Sent-ContentType");
        LOG.info("testProducesConsumesAnnotationOnClientInterfaceSent-ContentType: " + contentTypeHeader);
        Assert.assertEquals((String)acceptHeader, (String)"application/xml");
        Assert.assertEquals((String)contentTypeHeader, (String)"application/json");
    }

    @Test
    public void testProducesConsumesAnnotationOnInterface() {
        String m = "testProducesConsumesAnnotationOnInterface";
        ProducesConsumesClient client = (ProducesConsumesClient)((RestClientBuilder)RestClientBuilder.newBuilder().baseUri(URI.create("http://localhost:8080/null")).register(ProducesConsumesFilter.class)).build(ProducesConsumesClient.class);
        LOG.info("testProducesConsumesAnnotationOnInterface @Produce(text/html) @Consume(text/plain)");
        Response r = client.produceHtmlConsumeText("1", "whatever");
        String acceptHeader = r.getHeaderString("Sent-Accept");
        LOG.info("testProducesConsumesAnnotationOnInterfaceSent-Accept: " + acceptHeader);
        String contentTypeHeader = r.getHeaderString("Sent-ContentType");
        LOG.info("testProducesConsumesAnnotationOnInterfaceSent-ContentType: " + contentTypeHeader);
        Assert.assertEquals((String)acceptHeader, (String)"text/html");
        Assert.assertEquals((String)contentTypeHeader, (String)"text/plain");
    }
}

