/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import jakarta.json.JsonObject;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.ext.HeaderGenerator;
import org.eclipse.microprofile.rest.client.tck.interfaces.ClientHeaderParamClient;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWithAllClientHeadersFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ClientHeaderParamTest
extends WiremockArquillianTest {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ClientHeaderParamTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{ClientHeaderParamClient.class, ReturnWithAllClientHeadersFilter.class, HeaderGenerator.class, WiremockArquillianTest.class});
    }

    private static ClientHeaderParamClient client(Class<?> ... providers) {
        try {
            RestClientBuilder builder = RestClientBuilder.newBuilder().baseUri(ClientHeaderParamTest.getServerURI());
            for (Class<?> provider : providers) {
                builder.register(provider);
            }
            return (ClientHeaderParamClient)builder.build(ClientHeaderParamClient.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static void stub(String expectedHeaderName, String ... expectedHeaderValue) {
        String expectedIncomingHeader = Arrays.stream(expectedHeaderValue).collect(Collectors.joining(","));
        String outputBody = expectedIncomingHeader.replace(',', '-');
        MappingBuilder mappingBuilder = WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/"));
        Arrays.stream(expectedHeaderValue).forEach(val -> mappingBuilder.withHeader(expectedHeaderName, WireMock.containing((String)val)));
        WireMock.stubFor((MappingBuilder)mappingBuilder.willReturn(WireMock.aResponse().withStatus(200).withBody(outputBody)));
    }

    @BeforeTest
    public void resetWiremock() {
        ClientHeaderParamTest.setupServer();
    }

    @Test
    public void testExplicitClientHeaderParamOnInterface() {
        ClientHeaderParamTest.stub("InterfaceHeaderExplicit", "interfaceExplicit");
        Assert.assertEquals((String)ClientHeaderParamTest.client(new Class[0]).interfaceExplicit(), (String)"interfaceExplicit");
    }

    @Test
    public void testExplicitClientHeaderParamOnMethod() {
        ClientHeaderParamTest.stub("MethodHeaderExplicit", "methodExplicit");
        Assert.assertEquals((String)ClientHeaderParamTest.client(new Class[0]).methodExplicit(), (String)"methodExplicit");
    }

    @Test
    public void testHeaderParamOverridesExplicitClientHeaderParamOnInterface() {
        ClientHeaderParamTest.stub("InterfaceHeaderExplicit", "header");
        Assert.assertEquals((String)ClientHeaderParamTest.client(new Class[0]).headerParamOverridesInterfaceExplicit("header"), (String)"header");
    }

    @Test
    public void testHeaderParamOverridesExplicitClientHeaderParamOnMethod() {
        ClientHeaderParamTest.stub("MethodHeaderExplicit", "header2");
        Assert.assertEquals((String)ClientHeaderParamTest.client(new Class[0]).headerParamOverridesMethodExplicit("header2"), (String)"header2");
    }

    @Test
    public void testExplicitClientHeaderParamOnMethodOverridesClientHeaderParamOnInterface() {
        ClientHeaderParamTest.stub("OverrideableExplicit", "overriddenMethodExplicit");
        Assert.assertEquals((String)ClientHeaderParamTest.client(new Class[0]).methodClientHeaderParamOverridesInterfaceExplicit(), (String)"overriddenMethodExplicit");
    }

    @Test
    public void testComputedClientHeaderParamOnInterface() {
        ClientHeaderParamTest.stub("InterfaceHeaderComputed", "interfaceComputed");
        Assert.assertEquals((String)ClientHeaderParamTest.client(new Class[0]).interfaceComputed(), (String)"interfaceComputed");
    }

    @Test
    public void testComputedClientHeaderParamOnMethod() {
        ClientHeaderParamTest.stub("MethodHeaderComputed", "MethodHeaderComputed-X");
        Assert.assertEquals((String)ClientHeaderParamTest.client(new Class[0]).methodComputed(), (String)"MethodHeaderComputed-X");
    }

    @Test
    public void testHeaderParamOverridesComputedClientHeaderParamOnInterface() {
        ClientHeaderParamTest.stub("InterfaceHeaderComputed", "override");
        Assert.assertEquals((String)ClientHeaderParamTest.client(new Class[0]).headerParamOverridesInterfaceComputed("override"), (String)"override");
    }

    @Test
    public void testHeaderParamOverridesComputedClientHeaderParamOnMethod() {
        ClientHeaderParamTest.stub("MethodHeaderComputed", "override2");
        Assert.assertEquals((String)ClientHeaderParamTest.client(new Class[0]).headerParamOverridesMethodComputed("override2"), (String)"override2");
    }

    @Test
    public void testComputedClientHeaderParamOnMethodOverridesClientHeaderParamOnInterface() {
        ClientHeaderParamTest.stub("OverrideableComputed", "overriddenMethodComputed");
        Assert.assertEquals((String)ClientHeaderParamTest.client(new Class[0]).methodClientHeaderParamOverridesInterfaceComputed(), (String)"overriddenMethodComputed");
    }

    @Test
    public void testExceptionInRequiredComputeMethodThrowsClientErrorException() {
        try {
            ClientHeaderParamTest.client(new Class[0]).methodRequiredComputeMethodFails();
            Assert.fail((String)"Expected exception to be thrown");
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                Assert.assertEquals((String)t.getMessage(), (String)"intentional");
            }
            Assert.fail((String)("Threw unexpected exception, " + t + ", expected RuntimeException"));
        }
    }

    @Test
    public void testHeaderNotSentWhenExceptionThrownAndRequiredIsFalse() {
        JsonObject headers = ClientHeaderParamTest.client(ReturnWithAllClientHeadersFilter.class).methodOptionalMethodHeaderNotSentWhenComputeThrowsException();
        Assert.assertFalse((boolean)headers.containsKey((Object)"OptionalInterfaceHeader"));
        Assert.assertFalse((boolean)headers.containsKey((Object)"OptionalMethodHeader"));
        Assert.assertEquals((String)headers.getString("OverrideableExplicit"), (String)"overrideableInterfaceExplicit");
        Assert.assertEquals((String)headers.getString("InterfaceHeaderComputed"), (String)"interfaceComputed");
        Assert.assertEquals((String)headers.getString("MethodHeaderExplicit"), (String)"SomeValue");
    }

    @Test
    public void testMultivaluedHeaderSentWhenInvokingComputeMethodFromSeparateClass() {
        ClientHeaderParamTest.stub("MultiValueInvokedFromAnotherClass", "value1", "value2");
        Assert.assertEquals((String)ClientHeaderParamTest.client(new Class[0]).methodComputeMultiValuedHeaderFromOtherClass(), (String)"value1-value2");
    }

    @Test
    public void testMultivaluedHeaderInterfaceExplicit() {
        ClientHeaderParamTest.stub("InterfaceMultiValuedHeaderExplicit", "abc", "xyz");
        Assert.assertEquals((String)ClientHeaderParamTest.client(new Class[0]).methodComputeMultiValuedHeaderFromOtherClass(), (String)"abc-xyz");
    }
}

