/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.jsonb;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.time.LocalDate;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.JsonBClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.JsonBPrivateClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.MyJsonBContextResolver;
import org.eclipse.microprofile.rest.client.tck.interfaces.MyJsonBObject;
import org.eclipse.microprofile.rest.client.tck.interfaces.MyJsonBObjectWithPrivateProperties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class InvokeWithJsonBProviderTest
extends WiremockArquillianTest {
    private static final String BASE_STUB_BODY = "{\"objectName\": \"myObject\",\"quantity\": 17,\"date\": \"2018-12-04\"}";
    private static final String PRIVATE_STUB_BODY = "{\"objectName\": \"myObject\",\"quantity\": 17,\"date\": \"2018-12-04\",\"privateObjectName\": \"myPrivateObject\",\"privateQty\": 18}";
    @RestClient
    @Inject
    private JsonBClient cdiJsonBClient;
    @RestClient
    @Inject
    private Instance<JsonBPrivateClient> cdiJsonBPrivateClient;

    @Deployment
    public static WebArchive createDeployment() {
        StringAsset mpConfig = new StringAsset("jsonb/mp-rest/uri=" + InvokeWithJsonBProviderTest.getStringURL());
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(InvokeWithJsonBProviderTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{JsonBClient.class, WiremockArquillianTest.class, MyJsonBObject.class, JsonBPrivateClient.class, MyJsonBContextResolver.class, MyJsonBObjectWithPrivateProperties.class, InvokeWithJsonBProviderTest.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsWebInfResource((Asset)mpConfig, "classes/META-INF/microprofile-config.properties");
    }

    private static void assumeJsonbApiExists() throws SkipException {
        try {
            Class.forName("jakarta.json.bind.annotation.JsonbProperty");
        }
        catch (Throwable t) {
            throw new SkipException("Skipping since JSON-B APIs were not found.");
        }
    }

    @Test
    public void testGetExecutesForBothClients() throws Exception {
        InvokeWithJsonBProviderTest.assumeJsonbApiExists();
        JsonBClient builtJsonBClient = (JsonBClient)RestClientBuilder.newBuilder().baseUri(InvokeWithJsonBProviderTest.getServerURI()).build(JsonBClient.class);
        this.setupStub("/myObject", BASE_STUB_BODY);
        MyJsonBObject obj = builtJsonBClient.get("myObject");
        this.testBaseGet(obj);
        this.setupStub("/myObject", BASE_STUB_BODY);
        obj = this.cdiJsonBClient.get("myObject");
        this.testBaseGet(obj);
    }

    @Test
    public void testCanSeePrivatePropertiesViaContextResolver() throws Exception {
        InvokeWithJsonBProviderTest.assumeJsonbApiExists();
        JsonBPrivateClient builtJsonBClient = (JsonBPrivateClient)((RestClientBuilder)RestClientBuilder.newBuilder().baseUri(InvokeWithJsonBProviderTest.getServerURI()).register(MyJsonBContextResolver.class)).build(JsonBPrivateClient.class);
        this.setupStub("/private/myObject", PRIVATE_STUB_BODY);
        MyJsonBObjectWithPrivateProperties obj = builtJsonBClient.getPrivate("myObject");
        this.testBaseGet(obj);
        Assert.assertEquals((String)((Object)obj).toString(), (String)"PRIVATE_CTOR|myPrivateObject|18");
        this.setupStub("/private/myObject", PRIVATE_STUB_BODY);
        obj = ((JsonBPrivateClient)this.cdiJsonBPrivateClient.get()).getPrivate("myObject");
        this.testBaseGet(obj);
        Assert.assertEquals((String)((Object)obj).toString(), (String)"PRIVATE_CTOR|myPrivateObject|18");
    }

    private void setupStub(String path, String body) throws Exception {
        WireMock.reset();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)path)).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody(body)));
    }

    private void testBaseGet(MyJsonBObject obj) throws Exception {
        Assert.assertEquals((String)obj.getName(), (String)"myObject");
        Assert.assertEquals((int)obj.getQty(), (int)17);
        Assert.assertEquals((String)obj.getIgnoredField(), (String)"CTOR");
        Assert.assertEquals((Object)obj.getDate(), (Object)LocalDate.of(2018, 12, 4));
    }
}

