/*
 * Copyright (c) 2020 Contributors to the Eclipse Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.eclipse.microprofile.graphql;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation provides way how to set custom number format to field or JavaBean property. (or collection there of) This
 * is similar to Jsonb (JsonbNumberFormat) except that it adds support for TYPE_USE
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE,
        ElementType.ANNOTATION_TYPE,
        ElementType.FIELD,
        ElementType.METHOD,
        ElementType.TYPE,
        ElementType.PARAMETER,
        ElementType.PACKAGE})
@Documented
public @interface NumberFormat {
    String DEFAULT_LOCALE = "##default";
    String DEFAULT_FORMAT = "##default";

    String value() default "";
    String locale() default DEFAULT_LOCALE;
}