/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.tck;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.tck.TckThread;
import org.eclipse.microprofile.context.tck.TckThreadFactory;
import org.eclipse.microprofile.context.tck.contexts.buffer.Buffer;
import org.eclipse.microprofile.context.tck.contexts.buffer.spi.BufferContextProvider;
import org.eclipse.microprofile.context.tck.contexts.label.Label;
import org.eclipse.microprofile.context.tck.contexts.label.spi.LabelContextProvider;
import org.eclipse.microprofile.context.tck.contexts.priority.spi.ThreadPriorityContextProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ThreadContextTest
extends Arquillian {
    private static final long MAX_WAIT_NS = TimeUnit.MINUTES.toNanos(2L);
    private ExecutorService unmanagedThreads;

    @AfterClass
    public void after() {
        this.unmanagedThreads.shutdownNow();
    }

    @AfterMethod
    public void afterMethod(Method m, ITestResult result) {
        System.out.println("<<< END " + m.getClass().getSimpleName() + '.' + m.getName() + (result.isSuccess() ? " SUCCESS" : " FAILED"));
        Throwable failure = result.getThrowable();
        if (failure != null) {
            failure.printStackTrace(System.out);
        }
    }

    @BeforeClass
    public void before() {
        this.unmanagedThreads = Executors.newFixedThreadPool(5);
    }

    @BeforeMethod
    public void beforeMethod(Method m) {
        System.out.println(">>> BEGIN " + m.getClass().getSimpleName() + '.' + m.getName());
    }

    @Deployment
    public static WebArchive createDeployment() {
        JavaArchive threadPriorityContextProvider = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"threadPriorityContext.jar")).addPackage("org.eclipse.microprofile.context.tck.contexts.priority.spi")).addAsServiceProvider(ThreadContextProvider.class, new Class[]{ThreadPriorityContextProvider.class});
        JavaArchive multiContextProvider = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"bufferAndLabelContext.jar")).addPackages(true, new String[]{"org.eclipse.microprofile.context.tck.contexts.buffer"})).addPackages(true, new String[]{"org.eclipse.microprofile.context.tck.contexts.label"})).addAsServiceProvider(ThreadContextProvider.class, new Class[]{BufferContextProvider.class, LabelContextProvider.class});
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ThreadContextTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{ThreadContextTest.class, TckThread.class, TckThreadFactory.class})).addAsLibraries(new Archive[]{threadPriorityContextProvider, multiContextProvider});
    }

    @Test
    public void builderForThreadContextIsProvided() {
        Assert.assertNotNull((Object)ThreadContext.builder(), (String)"MicroProfile Context Propagation implementation does not provide a ThreadContext builder.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clearTransactionContextJTA() throws Exception {
        UserTransaction tx;
        UserTransaction txFromJNDI = null;
        try {
            txFromJNDI = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        UserTransaction txFromCDI = null;
        try {
            CDI cdi = CDI.current();
            Instance transactionInstance = cdi.select(UserTransaction.class, new Annotation[0]);
            if (transactionInstance.isResolvable()) {
                txFromCDI = (UserTransaction)transactionInstance.get();
            } else {
                System.out.println("CDI implementation is present, but UserTransaction cannot be retrieved.");
            }
        }
        catch (IllegalStateException x) {
            System.out.println("CDI implementation not present, cannot retrieve UserTransaction from CDI." + x);
        }
        UserTransaction userTransaction = tx = txFromJNDI == null ? txFromCDI : txFromJNDI;
        if (tx == null) {
            System.out.println("Skipping test clearTransactionContextJTA. JTA transactions are not supported.");
            return;
        }
        ThreadContext threadContext = ThreadContext.builder().cleared(new String[]{"Transaction"}).unchanged(new String[0]).propagated(new String[]{"Remaining"}).build();
        Callable taskWithNewTransaction = threadContext.contextualCallable(() -> {
            Assert.assertEquals((int)tx.getStatus(), (int)6, (String)"Transaction status should indicate no transaction is active on thread.");
            tx.begin();
            tx.commit();
            return "SUCCESS";
        });
        tx.begin();
        try {
            Assert.assertEquals((String)((String)taskWithNewTransaction.call()), (String)"SUCCESS");
            Assert.assertEquals((int)tx.getStatus(), (int)0, (String)"Transaction status should indicate active transaction on thread.");
        }
        finally {
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clearUnspecifiedContexts() throws Exception {
        ThreadContext threadContext = ThreadContext.builder().propagated(new String[]{"Buffer"}).unchanged(new String[]{"Label"}).cleared(new String[0]).build();
        int originalPriority = Thread.currentThread().getPriority();
        try {
            int newPriority = originalPriority == 3 ? 2 : 3;
            Thread.currentThread().setPriority(newPriority);
            Buffer.set(new StringBuffer("clearUnspecifiedContexts-test-buffer-A"));
            Label.set("clearUnspecifiedContexts-test-label-A");
            Callable callable = threadContext.contextualCallable(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"clearUnspecifiedContexts-test-buffer-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"clearUnspecifiedContexts-test-label-C", (String)"Context type was not left unchanged by contextual action.");
                Buffer.set(new StringBuffer("clearUnspecifiedContexts-test-buffer-B"));
                Label.set("clearUnspecifiedContexts-test-label-B");
                return Thread.currentThread().getPriority();
            });
            Buffer.set(new StringBuffer("clearUnspecifiedContexts-test-buffer-C"));
            Label.set("clearUnspecifiedContexts-test-label-C");
            Assert.assertEquals(callable.call(), (Object)5, (String)"Context type that remained unspecified was not cleared by default.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"clearUnspecifiedContexts-test-buffer-C", (String)"Previous context (Buffer) was not restored after context was propagated for contextual action.");
            Assert.assertEquals((String)Label.get(), (String)"clearUnspecifiedContexts-test-label-B", (String)"Context type was not left unchanged by contextual action.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextualBiConsumerRunsWithContext() throws InterruptedException {
        ThreadContext bufferContext = ThreadContext.builder().propagated(new String[]{"Buffer"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.get().append("contextualBiConsumer-test-buffer");
            Label.set("contextualBiConsumer-test-label");
            CountDownLatch completed = new CountDownLatch(1);
            CompletableFuture<String> stage1a = CompletableFuture.supplyAsync(() -> "supplied-value-A");
            CompletableFuture<String> stage1b = CompletableFuture.supplyAsync(() -> "supplied-value-B");
            CompletionStage stage2 = stage1a.thenAcceptBothAsync(stage1b, bufferContext.contextualConsumer((a, b) -> {
                Assert.assertEquals((String)a, (String)"supplied-value-A", (String)"First value supplied to BiConsumer was lost or altered.");
                Assert.assertEquals((String)b, (String)"supplied-value-B", (String)"Second value supplied to BiConsumer was lost or altered.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"contextualBiConsumer-test-buffer", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
            }), (Executor)this.unmanagedThreads);
            ((CompletableFuture)stage2).whenComplete((unused, failure) -> completed.countDown());
            Assert.assertTrue((boolean)completed.await(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Completable future did not finish in a reasonable amount of time.");
            ((CompletableFuture)stage2).join();
        }
        finally {
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextualBiFunctionRunsWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext labelContext = ThreadContext.builder().propagated(new String[]{"Label"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.get().append("contextualBiFunction-test-buffer");
            Label.set("contextualBiFunction-test-label");
            CompletableFuture stage1a = new CompletableFuture();
            CompletableFuture stage1b = new CompletableFuture();
            CompletionStage stage2 = stage1a.thenCombine((CompletionStage)stage1b, labelContext.contextualFunction((a, b) -> {
                Assert.assertEquals((Object)a, (Object)10, (String)"First value supplied to BiFunction was lost or altered.");
                Assert.assertEquals((Object)b, (Object)20, (String)"Second value supplied to BiFunction was lost or altered.");
                Assert.assertEquals((String)Label.get(), (String)"contextualBiFunction-test-label", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                return a + b;
            }));
            Future<Integer> future = this.unmanagedThreads.submit(() -> ThreadContextTest.lambda$contextualBiFunctionRunsWithContext$7(stage1a, stage1b, (CompletableFuture)stage2));
            Assert.assertEquals((Object)future.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)30, (String)"Result of BiFunction was lost or altered.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextualCallableRunsWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext priorityContext = ThreadContext.builder().propagated(new String[]{"ThreadPriority"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        int originalPriority = Thread.currentThread().getPriority();
        try {
            int newPriority = originalPriority == 4 ? 3 : 4;
            Thread.currentThread().setPriority(newPriority);
            Buffer.get().append("contextualCallable-test-buffer");
            Label.set("contextualCallable-test-label");
            Future future = this.unmanagedThreads.submit(priorityContext.contextualCallable(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type (Buffer) that is configured to be cleared was not cleared.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type (Label) that is configured to be cleared was not cleared.");
                return Thread.currentThread().getPriority();
            }));
            Assert.assertEquals(future.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)newPriority, (String)"Callable returned incorrect value.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextualConsumerRunsWithContext() throws InterruptedException {
        ThreadContext labelContext = ThreadContext.builder().propagated(new String[]{"Label"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.get().append("contextualConsumer-test-buffer");
            Label.set("contextualConsumer-test-label");
            CountDownLatch completed = new CountDownLatch(1);
            CompletableFuture<String> stage1 = new CompletableFuture<String>();
            CompletionStage stage2 = ((CompletableFuture)stage1.thenApplyAsync(unused -> "supply-to-consumer", (Executor)this.unmanagedThreads)).thenAccept(labelContext.contextualConsumer(s -> {
                Assert.assertEquals((String)s, (String)"supply-to-consumer", (String)"Value supplied to Consumer was lost or altered.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Assert.assertEquals((String)Label.get(), (String)"contextualConsumer-test-label", (String)"Context type was not propagated to contextual action.");
            }));
            stage1.complete("unblock");
            ((CompletableFuture)stage2).whenComplete((unused, failure) -> completed.countDown());
            Assert.assertTrue((boolean)completed.await(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Completable future did not finish in a reasonable amount of time.");
            ((CompletableFuture)stage2).join();
        }
        finally {
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextualFunctionRunsWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext bufferContext = ThreadContext.builder().propagated(new String[]{"Buffer"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.get().append("contextualFunction-test-buffer");
            Label.set("contextualFunction-test-label");
            Function contextualFunction = bufferContext.contextualFunction(i -> {
                Buffer.get().append("-" + i);
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                return i * 2L;
            });
            CompletableFuture stage1 = new CompletableFuture();
            CompletionStage stage2 = ((CompletableFuture)((CompletableFuture)stage1.thenApply(contextualFunction)).thenApply(i -> i + 10L)).thenApply(contextualFunction);
            Future<Long> future = this.unmanagedThreads.submit(() -> ThreadContextTest.lambda$contextualFunctionRunsWithContext$14(stage1, (CompletableFuture)stage2));
            Assert.assertEquals((Object)future.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)320L, (String)"Result of Function was lost or altered.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"contextualFunction-test-buffer-75-160", (String)"Context not propagated or incorrectly propagated to contextualFunctions.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextualRunnableRunsWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext priorityAndBufferContext = ThreadContext.builder().propagated(new String[]{"ThreadPriority", "Buffer"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        int originalPriority = Thread.currentThread().getPriority();
        try {
            int newPriority = originalPriority == 2 ? 1 : 2;
            Thread.currentThread().setPriority(newPriority);
            Buffer.get().append("contextualRunnable-test-buffer");
            Label.set("contextualRunnable-test-label");
            Runnable contextualRunnable = priorityAndBufferContext.contextualRunnable(() -> {
                int priority = Thread.currentThread().getPriority();
                Buffer.get().append("-" + priority);
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
            });
            Thread.currentThread().setPriority(originalPriority);
            CompletableFuture stage1 = new CompletableFuture();
            CompletionStage stage2 = ((CompletableFuture)((CompletableFuture)stage1.thenRun(contextualRunnable)).thenRun(() -> Buffer.get().append("-non-contextual-runnable"))).thenRun(contextualRunnable);
            Future<Void> future = this.unmanagedThreads.submit(() -> ThreadContextTest.lambda$contextualRunnableRunsWithContext$17(stage1, (CompletableFuture)stage2));
            future.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            Assert.assertEquals((String)Buffer.get().toString(), (String)("contextualRunnable-test-buffer-" + newPriority + "-" + newPriority), (String)"Context not propagated or incorrectly propagated to contextualFunctions.");
        }
        finally {
            Thread.currentThread().setPriority(originalPriority);
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextualSupplierRunsWithContext() throws InterruptedException {
        ThreadContext bufferContext = ThreadContext.builder().propagated(new String[]{"Buffer"}).unchanged(new String[]{"Application"}).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.get().append("contextualSupplier-test-buffer");
            Label.set("contextualSupplier-test-label");
            CountDownLatch completed = new CountDownLatch(1);
            CompletableFuture stage1 = CompletableFuture.supplyAsync(bufferContext.contextualSupplier(() -> {
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                String bufferContents = Buffer.get().toString();
                Assert.assertEquals((String)bufferContents, (String)"contextualSupplier-test-buffer", (String)"Context type was not propagated to contextual action.");
                return bufferContents;
            }));
            stage1.whenComplete((unused, failure) -> completed.countDown());
            Assert.assertTrue((boolean)completed.await(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Completable future did not finish in a reasonable amount of time.");
            String result = (String)stage1.join();
            Assert.assertEquals((String)result, (String)"contextualSupplier-test-buffer", (String)"Supplier result was lost or altered.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reuseThreadContextBuilder() throws Exception {
        ThreadContext.Builder builder = ThreadContext.builder().propagated(new String[0]).cleared(new String[]{"Buffer", "ThreadPriority"}).unchanged(new String[0]);
        ThreadContext clearingContext = builder.build();
        ThreadContext propagatingContext = builder.propagated(new String[]{"Buffer", "ThreadPriority"}).cleared(new String[0]).build();
        int originalPriority = Thread.currentThread().getPriority();
        try {
            int newPriority = originalPriority == 3 ? 2 : 3;
            Thread.currentThread().setPriority(newPriority);
            Buffer.set(new StringBuffer("reuseBuilder-test-buffer-A"));
            Callable clearedCallable = clearingContext.contextualCallable(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Buffer.set(new StringBuffer("reuseBuilder-test-buffer-B"));
                return Thread.currentThread().getPriority();
            });
            Callable propagatedCallable = propagatingContext.contextualCallable(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"reuseBuilder-test-buffer-A", (String)"Context type was not propagated to contextual action.");
                Buffer.set(new StringBuffer("reuseBuilder-test-buffer-C"));
                return Thread.currentThread().getPriority();
            });
            Buffer.set(new StringBuffer("reuseBuilder-test-buffer-D"));
            Thread.currentThread().setPriority(newPriority - 1);
            Assert.assertEquals(propagatedCallable.call(), (Object)newPriority, (String)"Context type was not propagated to contextual action.");
            Assert.assertEquals(clearedCallable.call(), (Object)5, (String)"Context type that is configured to be cleared was not cleared.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"reuseBuilder-test-buffer-D", (String)"Previous context (Buffer) was not restored after context was propagated for contextual action.");
        }
        finally {
            Buffer.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unchangedContextListDefaultsToEmpty() {
        ThreadContext labelContext = ThreadContext.builder().propagated(new String[]{"Label"}).cleared(new String[]{"Remaining"}).build();
        int originalPriority = Thread.currentThread().getPriority();
        int newPriority = originalPriority == 3 ? 2 : 3;
        try {
            Buffer.get().append("test-unchangedContextListDefaultsToEmpty-buffer-A");
            Label.set("test-unchangedContextListDefaultsToEmpty-label-A");
            Thread.currentThread().setPriority(newPriority);
            Runnable testPropagateLabelContextAndClearOthers = labelContext.contextualRunnable(() -> {
                Assert.assertEquals((String)Label.get(), (String)"test-unchangedContextListDefaultsToEmpty-label-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type (Buffer) that is defaulted to be cleared was not cleared.");
                Assert.assertEquals((int)Thread.currentThread().getPriority(), (int)5, (String)"Context type (ThreadContext) that is defaulted to be cleared was not cleared.");
            });
            Label.set("test-unchangedContextListDefaultsToEmpty-label-B");
            testPropagateLabelContextAndClearOthers.run();
            Assert.assertEquals((String)Buffer.get().toString(), (String)"test-unchangedContextListDefaultsToEmpty-buffer-A", (String)"Previous context (Buffer) was not restored after context was cleared for contextual action.");
            Assert.assertEquals((String)Label.get(), (String)"test-unchangedContextListDefaultsToEmpty-label-B", (String)"Previous context (Label) was not restored after context was propagated for contextual action.");
            Assert.assertEquals((int)Thread.currentThread().getPriority(), (int)newPriority, (String)"Previous context (ThreadPriority) was not restored after context was propagated for contextual action.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void thirdPartyContextProvidersAreIncludedInThreadContext() {
        ThreadContext labelAndPriorityContext = ThreadContext.builder().propagated(new String[]{"ThreadPriority", "Label"}).cleared(new String[]{"Buffer"}).unchanged(new String[]{"Remaining"}).build();
        int originalPriority = Thread.currentThread().getPriority();
        int priorityA = originalPriority == 3 ? 2 : 3;
        int priorityB = priorityA - 1;
        try {
            Buffer.get().append("test-buffer-content-A");
            Label.set("test-label-A");
            Thread.currentThread().setPriority(priorityA);
            Supplier contextualSupplier = labelAndPriorityContext.contextualSupplier(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Assert.assertEquals((String)Label.get(), (String)"test-label-A", (String)"Context type was not propagated to contextual action.");
                return Thread.currentThread().getPriority();
            });
            Buffer.get().append("-and-B");
            Label.set("test-label-B");
            Thread.currentThread().setPriority(priorityB);
            int priority = (Integer)contextualSupplier.get();
            Assert.assertEquals((int)priority, (int)priorityA, (String)"Context type was not propagated to contextual action.");
            priority = (Integer)contextualSupplier.get();
            Assert.assertEquals((int)priority, (int)priorityA, (String)"Context type was not propagated to contextual action.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"test-buffer-content-A-and-B", (String)"Previous context was not restored after context was cleared for contextual action.");
            Assert.assertEquals((String)Label.get(), (String)"test-label-B", (String)"Previous context (Label) was not restored after context was propagated for contextual action.");
            Assert.assertEquals((int)Thread.currentThread().getPriority(), (int)priorityB, (String)"Previous context (ThreadPriority) was not restored after context was propagated for contextual action.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void withContextCaptureDependentCompletableFuturesRunWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext labelContext = ThreadContext.builder().propagated(new String[]{"Label"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        ManagedExecutor bufferContextExecutor = ManagedExecutor.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Remaining"}).build();
        long testThreadId = Thread.currentThread().getId();
        try {
            Buffer.get().append("withContextCapture-CompletableFuture-test-buffer");
            Label.set("withContextCapture-CompletableFuture-test-label-A");
            CompletableFuture<Integer> unmanagedStage1 = new CompletableFuture<Integer>();
            CompletableFuture stage2 = labelContext.withContextCapture(unmanagedStage1);
            CompletionStage stage3 = stage2.thenApply(i -> {
                Assert.assertEquals((Object)i, (Object)1010, (String)"Value supplied to function does not match the value with which the dependent stage was completed.");
                Assert.assertEquals((String)Label.get(), (String)"withContextCapture-CompletableFuture-test-label-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Assert.assertEquals((long)Thread.currentThread().getId(), (long)testThreadId, (String)"Completion stages created via withContextCapture must run on the test case's main thread because it both completes the original stage and requests the result.");
                Label.set("withContextCapture-CompletableFuture-test-label-B");
                return i * 2;
            });
            Label.set("withContextCapture-CompletableFuture-test-label-C");
            CompletionStage stage4 = ((CompletableFuture)stage3).thenApplyAsync(i -> {
                Assert.assertEquals((Object)i, (Object)2020, (String)"Incorrect value supplied to function.");
                Assert.assertEquals((String)Label.get(), (String)"withContextCapture-CompletableFuture-test-label-C", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("withContextCapture-CompletableFuture-test-label-D");
                return i + i;
            }, (Executor)bufferContextExecutor);
            CompletionStage unmanagedStage5 = unmanagedStage1.thenApply(i -> i / 2);
            Label.set("withContextCapture-CompletableFuture-test-label-E");
            unmanagedStage1.complete(1010);
            Assert.assertEquals((Object)stage2.getNow(9090), (Object)1010, (String)"Completion stage created by withContextCapture did not complete with same value as original stage.");
            Assert.assertEquals(((CompletableFuture)stage3).get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)2020, (String)"Incorrect or missing result of completion stage.");
            Assert.assertEquals(((CompletableFuture)stage4).join(), (Object)4040, (String)"Incorrect or missing result of completion stage.");
            Assert.assertEquals(((CompletableFuture)unmanagedStage5).get(), (Object)505, (String)"Incorrect or missing result of completion stage.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"withContextCapture-CompletableFuture-test-buffer", (String)"Previous context was not restored after context was cleared for contextual action.");
            Assert.assertEquals((String)Label.get(), (String)"withContextCapture-CompletableFuture-test-label-E", (String)"Previous context was not restored after context was propagated for contextual action.");
        }
        finally {
            bufferContextExecutor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void withContextCaptureDependentCompletionStagesRunWithContext() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext bufferContext = ThreadContext.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Remaining"}).unchanged(new String[0]).build();
        ManagedExecutor labelContextExecutor = ManagedExecutor.builder().propagated(new String[]{"Label"}).cleared(new String[]{"Remaining"}).build();
        long testThreadId = Thread.currentThread().getId();
        try {
            StringBuffer buffer = new StringBuffer("withContextCapture-CompletionStage-test-buffer-A");
            Buffer.set(buffer);
            Label.set("withContextCapture-CompletionStage-test-label");
            CompletableFuture<Integer> unmanagedStage1 = new CompletableFuture<Integer>();
            CompletionStage stage2 = bufferContext.withContextCapture(unmanagedStage1);
            if (stage2 instanceof CompletableFuture) {
                try {
                    ((CompletableFuture)stage2).complete(4321);
                    Assert.fail((String)"Must not be possible to forcibly complete the CompletionStage that is returned by the variantof withContextCapture that accepts and returns a CompletionStage rather than CompletableFuture.");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            CompletionStage<Integer> stage3 = stage2.thenApply(i -> {
                Assert.assertEquals((Object)i, (Object)1234, (String)"Value supplied to function does not match the value with which the dependent stage was completed.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"withContextCapture-CompletionStage-test-buffer-A", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Label.get().toString(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Assert.assertEquals((long)Thread.currentThread().getId(), (long)testThreadId, (String)"Completion stages created via withContextCapture must run on the test case's main thread because it both completes the original stage and requests the result.");
                Buffer.get().append("-stage3");
                Buffer.set(new StringBuffer("withContextCapture-CompletionStage-test-buffer-B"));
                return i * 2;
            });
            CompletionStage<Integer> stage4 = stage3.thenApplyAsync(i -> {
                Assert.assertEquals((Object)i, (Object)2468, (String)"Incorrect value supplied to function.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"withContextCapture-CompletionStage-test-buffer-A-stage3", (String)"Context type was not propagated to contextual action.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Buffer.get().append("-stage4");
                Buffer.set(new StringBuffer("withContextCapture-CompletionStage-test-buffer-D"));
                return i - 2345;
            }, (Executor)labelContextExecutor);
            Buffer.set(new StringBuffer("withContextCapture-CompletionStage-test-buffer-E"));
            unmanagedStage1.complete(1234);
            CompletableFuture<Integer> cf4 = stage4.toCompletableFuture();
            Assert.assertEquals((Object)cf4.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)123, (String)"Completion stage created by withContextCapture did not complete with same value as original stage.");
            Assert.assertEquals((String)buffer.toString(), (String)"withContextCapture-CompletionStage-test-buffer-A-stage3-stage4");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"withContextCapture-CompletionStage-test-buffer-E", (String)"Previous context was not restored after context was propagated for contextual action.");
            Assert.assertEquals((String)Label.get(), (String)"withContextCapture-CompletionStage-test-label", (String)"Previous context was not restored after context was cleared for contextual action.");
        }
        finally {
            labelContextExecutor.shutdownNow();
            Buffer.set(null);
            Label.set(null);
        }
    }

    @Test
    public void withContextCaptureDependentStageForcedCompletion() throws ExecutionException, InterruptedException {
        ThreadContext contextPropagator = ThreadContext.builder().propagated(new String[0]).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        CompletableFuture<String> stage1 = new CompletableFuture<String>();
        CompletableFuture stage2 = contextPropagator.withContextCapture(stage1);
        Assert.assertTrue((boolean)stage2.complete("stage_2_done"), (String)"It should be possible to complete a CompletableFuture created via withContextCapture without completing the original stage.");
        Assert.assertFalse((boolean)stage1.isDone(), (String)"Completion of the dependent stage must not imply completion of the original stage.");
        Assert.assertTrue((boolean)stage1.complete("stage_1_done"), (String)"It should be possible to complete the original stage with a different result after dependent stage was forcibly completed.");
        Assert.assertEquals((String)((String)stage1.get()), (String)"stage_1_done", (String)"Completion stage result does not match the result with which it was forcibly completed.");
        Assert.assertEquals((String)((String)stage2.get()), (String)"stage_2_done", (String)"Completion stage result does not match the result with which it was forcibly completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void withContextCaptureMultipleThreadContexts() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext bufferContext = ThreadContext.builder().propagated(new String[]{"Buffer"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        ThreadContext labelContext = ThreadContext.builder().propagated(new String[]{"Label"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        try {
            Function<Character, String> getContext = c -> Buffer.get().append(c).append(Label.get()).toString();
            Buffer.set(new StringBuffer("withContextCaptureMultipleThreadContexts-test-buffer-A"));
            Label.set("withContextCaptureMultipleThreadContexts-test-label-A");
            CompletableFuture<Character> unmanagedStage1 = new CompletableFuture<Character>();
            CompletableFuture stage2 = bufferContext.withContextCapture(unmanagedStage1);
            CompletableFuture stage3 = labelContext.withContextCapture(unmanagedStage1);
            CompletionStage stage4 = stage2.thenApply(getContext);
            CompletionStage stage5 = stage3.thenApply(getContext);
            Buffer.set(new StringBuffer("withContextCaptureMultipleThreadContexts-test-buffer-B"));
            Label.set("withContextCaptureMultipleThreadContexts-test-label-B");
            unmanagedStage1.complete(Character.valueOf(';'));
            Assert.assertEquals((String)((String)((CompletableFuture)stage4).get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"withContextCaptureMultipleThreadContexts-test-buffer-A;", (String)"Context was incorrectly established on contextual function.");
            Assert.assertEquals((String)((String)((CompletableFuture)stage5).get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)";withContextCaptureMultipleThreadContexts-test-label-A", (String)"Context was incorrectly established on contextual function.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void withContextCaptureSwitchThreadContext() throws ExecutionException, InterruptedException, TimeoutException {
        ThreadContext bufferContext = ThreadContext.builder().propagated(new String[]{"Buffer"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        ThreadContext labelContext = ThreadContext.builder().propagated(new String[]{"Label"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.set(new StringBuffer("withContextCaptureSwitchThreadContext-test-buffer-A"));
            Label.set("withContextCaptureSwitchThreadContext-test-label-A");
            CompletableFuture<Character> unmanagedStage1 = new CompletableFuture<Character>();
            CompletableFuture stage2 = bufferContext.withContextCapture(unmanagedStage1);
            CompletionStage stage3 = stage2.thenApply(c -> Buffer.get().append(c).append(Label.get()).toString());
            Buffer.set(new StringBuffer("withContextCaptureSwitchThreadContext-test-buffer-B"));
            Label.set("withContextCaptureSwitchThreadContext-test-label-B");
            CompletableFuture stage4 = labelContext.withContextCapture((CompletableFuture)stage3);
            CompletionStage stage5 = stage4.thenApply(s -> s + ';' + Buffer.get().toString() + ';' + Label.get());
            Buffer.set(new StringBuffer("withContextCaptureSwitchThreadContext-test-buffer-C"));
            Label.set("withContextCaptureSwitchThreadContext-test-label-C");
            unmanagedStage1.complete(Character.valueOf(';'));
            Assert.assertEquals((String)((String)((CompletableFuture)stage5).get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"withContextCaptureSwitchThreadContext-test-buffer-A;;;withContextCaptureSwitchThreadContext-test-label-B", (String)"Context was incorrectly established on contextual function.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void contextControlsForThreadContextBuilder() throws InterruptedException, ExecutionException, TimeoutException {
        ThreadContext bufferContext = ThreadContext.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Label"}).unchanged(new String[]{"ThreadPriority"}).build();
        try {
            ThreadContext.builder().propagated(new String[]{"Buffer"}).cleared(new String[]{"Label", "Buffer"}).unchanged(new String[]{"ThreadPriority"}).build();
            Assert.fail((String)"ThreadContext.Builder.build() should throw an IllegalStateException for set overlap between propagated and cleared");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        int originalPriority = Thread.currentThread().getPriority();
        try {
            int newPriority = originalPriority == 4 ? 3 : 4;
            Buffer.get().append("contextControls-test-buffer-A");
            Label.set("contextControls-test-label-A");
            Callable callable = bufferContext.contextualCallable(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"contextControls-test-buffer-A-B", (String)"Context type was not propagated to contextual action.");
                Buffer.get().append("-C");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("contextControls-test-label-C");
                return Thread.currentThread().getPriority();
            });
            Buffer.get().append("-B");
            Label.set("contextControls-test-label-B");
            Future<Integer> future = this.unmanagedThreads.submit(() -> {
                try {
                    Buffer.get().append("unpropagated-buffer");
                    Label.set("unpropagated-label");
                    Thread.currentThread().setPriority(newPriority);
                    Integer returnedPriority = (Integer)callable.call();
                    Assert.assertEquals((String)Buffer.get().toString(), (String)"unpropagated-buffer", (String)"Context type was not left unchanged by contextual action.");
                    Assert.assertEquals((String)Label.get(), (String)"unpropagated-label", (String)"Context type was not left unchanged by contextual action.");
                    Integer n = returnedPriority;
                    return n;
                }
                finally {
                    Buffer.set(null);
                    Label.set(null);
                    Thread.currentThread().setPriority(originalPriority);
                }
            });
            Assert.assertEquals((Object)future.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (Object)newPriority, (String)"Callable returned incorrect value.");
            Assert.assertEquals((String)Buffer.get().toString(), (String)"contextControls-test-buffer-A-B-C", (String)"Context type was not propagated to contextual action.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void currentContextExecutorRunsWithContext() throws InterruptedException, ExecutionException, TimeoutException {
        ThreadContext bufferContext = ThreadContext.builder().propagated(new String[]{"Buffer"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        try {
            Buffer.get().append("currentContextExecutor-test-buffer-A");
            Label.set("currentContextExecutor-test-label-A");
            Executor contextSnapshot = bufferContext.currentContextExecutor();
            Buffer.get().append("-B");
            Label.set("currentContextExecutor-test-label-B");
            Future<Void> future = this.unmanagedThreads.submit(() -> {
                try {
                    Buffer.get().append("currentContextExecutor-test-buffer-C");
                    Label.set("currentContextExecutor-test-label-C");
                    contextSnapshot.execute(() -> {
                        Assert.assertEquals((String)Buffer.get().toString(), (String)"currentContextExecutor-test-buffer-A-B", (String)"Context type was not propagated to contextual action.");
                        Buffer.get().append("-D");
                        Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                        Label.set("currentContextExecutor-test-label-D");
                    });
                    Assert.assertEquals((String)Buffer.get().toString(), (String)"currentContextExecutor-test-buffer-C", (String)"Existing context was altered by a contextual Executor.execute().");
                    Assert.assertEquals((String)Label.get(), (String)"currentContextExecutor-test-label-C", (String)"Existing context was altered by a contextual Executor.execute().");
                    Void void_ = null;
                    return void_;
                }
                finally {
                    Buffer.set(null);
                    Label.set(null);
                }
            });
            future.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            Assert.assertEquals((String)Buffer.get().toString(), (String)"currentContextExecutor-test-buffer-A-B-D", (String)"Existing context was altered by a contextual Executor.execute().");
            Assert.assertEquals((String)Label.get(), (String)"currentContextExecutor-test-label-B", (String)"Existing context was altered by a contextual Executor.execute().");
            contextSnapshot.execute(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"currentContextExecutor-test-buffer-A-B-D", (String)"Context type was not propagated to contextual action.");
                Buffer.get().append("-E");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type that is configured to be cleared was not cleared.");
                Label.set("currentContextExecutor-test-label-E");
            });
            Assert.assertEquals((String)Buffer.get().toString(), (String)"currentContextExecutor-test-buffer-A-B-D-E", (String)"Existing context was altered by a contextual Executor.execute().");
            Assert.assertEquals((String)Label.get(), (String)"currentContextExecutor-test-label-B", (String)"Existing context was altered by a contextual Executor.execute().");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void withDefaultExecutorServiceContextCanInvokeAsyncActions() throws ExecutionException, InterruptedException, TimeoutException {
        ContextManager.Builder builder = ThreadContextTest.getContextManagerBuilderIfSupported();
        ExecutorService executorService = Executors.newSingleThreadExecutor(new TckThreadFactory());
        ContextManager contextManager = builder.withDefaultExecutorService(executorService).addDiscoveredThreadContextProviders().build();
        ThreadContext labelContext = contextManager.newThreadContextBuilder().propagated(new String[]{"Label"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        try {
            Label.set("default-executor-service-context-test-label-A");
            CompletableFuture<String> noContextCF = new CompletableFuture<String>();
            CompletionStage noContextCFStage1 = noContextCF.thenApplyAsync(res -> {
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type should not be propagated to non-contextual action.");
                return res;
            });
            CompletionStage contextCF = labelContext.withContextCapture((CompletableFuture)noContextCFStage1).thenApplyAsync(res -> {
                Assert.assertEquals((String)Label.get(), (String)"default-executor-service-context-test-label-A", (String)"Context type should be propagated to contextual CompletableFuture.");
                Assert.assertTrue((boolean)(Thread.currentThread() instanceof TckThread), (String)"Current thread should have been created by default executor service");
                return res;
            });
            CompletionStage<String> contextCS = labelContext.withContextCapture(noContextCFStage1).thenApplyAsync(res -> {
                Assert.assertEquals((String)Label.get(), (String)"default-executor-service-context-test-label-A", (String)"Context type should be propagated to contextual CompletionStage.");
                Assert.assertTrue((boolean)(Thread.currentThread() instanceof TckThread), (String)"Current thread should have been created by default executor service");
                return res;
            });
            noContextCF.complete("OK");
            ((CompletableFuture)contextCF).get(MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            contextCS.toCompletableFuture().get(MAX_WAIT_NS, TimeUnit.NANOSECONDS);
        }
        finally {
            Label.set(null);
            executorService.shutdownNow();
        }
    }

    static ContextManager.Builder getContextManagerBuilderIfSupported() {
        try {
            return ContextManagerProvider.instance().getContextManagerBuilder();
        }
        catch (UnsupportedOperationException x) {
            throw new SkipException("getContextManagerBuilder not supported", (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void withoutDefaultExecutorServiceContextCannotInvokeAsyncActions() throws ExecutionException, InterruptedException, TimeoutException {
        ContextManager contextManager;
        boolean noExecutorService = false;
        try {
            contextManager = ThreadContextTest.getContextManagerBuilderIfSupported().addDiscoveredThreadContextProviders().withDefaultExecutorService(null).build();
            noExecutorService = true;
        }
        catch (SkipException x) {
            contextManager = ContextManagerProvider.instance().getContextManager();
        }
        ThreadContext labelContext = contextManager.newThreadContextBuilder().propagated(new String[]{"Label"}).unchanged(new String[0]).cleared(new String[]{"Remaining"}).build();
        try {
            Label.set("default-executor-service-context-test-label-A");
            CompletableFuture noContextCF = new CompletableFuture();
            CompletionStage noContextCFStage1 = noContextCF.thenApplyAsync(res -> {
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type should not be propagated to non-contextual action.");
                return res;
            });
            try {
                labelContext.withContextCapture((CompletableFuture)noContextCFStage1).thenApplyAsync(res -> res);
                if (noExecutorService) {
                    Assert.fail((String)"Async action should not be allowed without a default executor service");
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                labelContext.withContextCapture(noContextCFStage1).thenApplyAsync(res -> res);
                if (noExecutorService) {
                    Assert.fail((String)"Async action should not be allowed without a default executor service");
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        finally {
            Label.set(null);
        }
    }

    private static /* synthetic */ Void lambda$contextualRunnableRunsWithContext$17(CompletableFuture stage1, CompletableFuture stage2) throws Exception {
        stage1.complete(null);
        stage2.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS);
        return null;
    }

    private static /* synthetic */ Long lambda$contextualFunctionRunsWithContext$14(CompletableFuture stage1, CompletableFuture stage2) throws Exception {
        stage1.complete(75L);
        return (Long)stage2.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS);
    }

    private static /* synthetic */ Integer lambda$contextualBiFunctionRunsWithContext$7(CompletableFuture stage1a, CompletableFuture stage1b, CompletableFuture stage2) throws Exception {
        stage1a.complete(10);
        stage1b.complete(20);
        return (Integer)stage2.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS);
    }
}

