/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.tck;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.tck.MPConfigBean;
import org.eclipse.microprofile.context.tck.ProducerBean;
import org.eclipse.microprofile.context.tck.contexts.buffer.Buffer;
import org.eclipse.microprofile.context.tck.contexts.buffer.spi.BufferContextProvider;
import org.eclipse.microprofile.context.tck.contexts.label.Label;
import org.eclipse.microprofile.context.tck.contexts.label.spi.LabelContextProvider;
import org.eclipse.microprofile.context.tck.contexts.priority.spi.ThreadPriorityContextProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MPConfigTest
extends Arquillian {
    private static final long MAX_WAIT_NS = TimeUnit.MINUTES.toNanos(2L);
    @Inject
    protected MPConfigBean bean;
    @Inject
    @MPConfigBean.Max5Queue
    protected ManagedExecutor producedExecutor;
    @Inject
    @Named(value="producedThreadContext")
    protected ThreadContext producedThreadContext;

    @AfterMethod
    public void afterMethod(Method m, ITestResult result) {
        System.out.println("<<< END " + m.getClass().getSimpleName() + '.' + m.getName() + (result.isSuccess() ? " SUCCESS" : " FAILED"));
        Throwable failure = result.getThrowable();
        if (failure != null) {
            failure.printStackTrace(System.out);
        }
    }

    @BeforeMethod
    public void beforeMethod(Method m) {
        System.out.println(">>> BEGIN " + m.getClass().getSimpleName() + '.' + m.getName());
    }

    @Deployment
    public static WebArchive createDeployment() {
        JavaArchive fakeContextProviders = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"fakeContextTypes.jar")).addPackages(true, new String[]{"org.eclipse.microprofile.context.tck.contexts.buffer"})).addPackages(true, new String[]{"org.eclipse.microprofile.context.tck.contexts.label"})).addPackage("org.eclipse.microprofile.context.tck.contexts.priority.spi")).addAsServiceProvider(ThreadContextProvider.class, new Class[]{BufferContextProvider.class, LabelContextProvider.class, ThreadPriorityContextProvider.class});
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(MPConfigTest.class.getSimpleName() + ".war"))).addClass(MPConfigBean.class)).addClass(MPConfigTest.class)).addClass(ProducerBean.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsWebInfResource((Asset)new StringAsset("mp.context.ManagedExecutor.maxAsync=1\nmp.context.ManagedExecutor.maxQueued=4\nmp.context.ManagedExecutor.propagated=Label,ThreadPriority\nmp.context.ManagedExecutor.cleared=Remaining\nmp.context.ThreadContext.cleared=Buffer\nmp.context.ThreadContext.propagated=None\nmp.context.ThreadContext.unchanged=Remaining"), "classes/META-INF/microprofile-config.properties")).addAsLibraries(new Archive[]{fakeContextProviders});
    }

    @Test
    public void beanInjected() {
        Assert.assertNotNull((Object)this.bean, (String)"Unable to inject CDI bean. Expect other tests to fail.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void defaultContextPropagationForManagedExecutorViaMPConfig() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().build();
        int originalPriority = Thread.currentThread().getPriority();
        try {
            int newPriority = originalPriority == 4 ? 3 : 4;
            Thread.currentThread().setPriority(newPriority);
            Buffer.set(new StringBuffer("defaultContextPropagationForManagedExecutorViaMPConfig-test-buffer"));
            Label.set("defaultContextPropagationForManagedExecutorViaMPConfig-test-label");
            CompletionStage stage1 = executor.completedFuture((Object)newPriority).thenAcceptAsync(expectedPriority -> {
                Assert.assertEquals((String)Label.get(), (String)"defaultContextPropagationForManagedExecutorViaMPConfig-test-label", (String)"Context type (Label) that MicroProfile config defaults to be propagated was not correctly propagated.");
                Assert.assertEquals((Object)Thread.currentThread().getPriority(), (Object)expectedPriority, (String)"Context type (ThreadPriority) that MicroProfile config defaults to be propagated was not correctly propagated.");
            });
            Assert.assertNull(((CompletableFuture)stage1).get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Non-null value returned by stage that runs async Consumer.");
            CompletionStage stage2 = ((CompletableFuture)stage1).thenRun(() -> Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type (Buffer) that MicroProfile config overrides to be cleared was not cleared."));
            Assert.assertNull(((CompletableFuture)stage2).get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Non-null value returned by stage that runs Runnable.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void defaultContextPropagationForThreadContextViaMPConfig() {
        ThreadContext threadContext = ThreadContext.builder().build();
        int originalPriority = Thread.currentThread().getPriority();
        try {
            Buffer.set(new StringBuffer("defaultContextPropagationForThreadContextViaMPConfig-test-buffer-A"));
            int newPriority = originalPriority == 3 ? 2 : 3;
            Runnable task = threadContext.contextualRunnable(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type that MicroProfile config defaults to be cleared was not cleared.");
                Assert.assertEquals((int)Thread.currentThread().getPriority(), (int)newPriority, (String)"Context type (ThreadPriority) that MicroProfile Config defaults to remain unchanged was changed.");
                Assert.assertEquals((String)Label.get(), (String)"defaultContextPropagationForThreadContextViaMPConfig-test-label-B", (String)"Context type (Label) that MicroProfile Config defaults to remain unchanged was changed.");
                Label.set("defaultContextPropagationForThreadContextViaMPConfig-test-label-A");
            });
            Thread.currentThread().setPriority(newPriority);
            Label.set("defaultContextPropagationForThreadContextViaMPConfig-test-label-B");
            task.run();
            Assert.assertEquals((String)Label.get(), (String)"defaultContextPropagationForThreadContextViaMPConfig-test-label-A", (String)"Context type that MicroProfile Config defaults to remain unchanged was changed when task completed.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"beanInjected"})
    public void defaultMaxAsyncAndMaxQueuedForManagedExecutorViaMPConfig() throws ExecutionException, InterruptedException, TimeoutException {
        ManagedExecutor executor = ManagedExecutor.builder().propagated(new String[]{"Buffer"}).build();
        Phaser barrier = new Phaser(1);
        try {
            Buffer.set(new StringBuffer("defaultMaxAsyncAndMaxQueuedForManagedExecutorViaMPConfig-test-buffer"));
            Label.set("defaultMaxAsyncAndMaxQueuedForManagedExecutorViaMPConfig-test-label");
            executor.submit(() -> barrier.awaitAdvanceInterruptibly(barrier.arrive() + 1));
            barrier.awaitAdvanceInterruptibly(0, MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            CompletableFuture cf1 = executor.supplyAsync(() -> Buffer.get().toString());
            CompletableFuture cf2 = executor.supplyAsync(() -> Label.get());
            CompletableFuture cf3 = executor.supplyAsync(() -> "III");
            CompletableFuture cf4 = executor.supplyAsync(() -> "IV");
            try {
                CompletableFuture cf5 = executor.supplyAsync(() -> "V");
                Assert.assertTrue((cf5.isDone() && cf5.isCompletedExceptionally() ? 1 : 0) != 0, (String)("Exceeded maxQueued of 4. Future for 5th queued task/action is " + cf5));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
            barrier.arrive();
            Assert.assertEquals((String)((String)cf1.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"defaultMaxAsyncAndMaxQueuedForManagedExecutorViaMPConfig-test-buffer", (String)"First task: Context not propagated as configured on the builder.");
            Assert.assertEquals((String)((String)cf2.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"", (String)"Second task: Context not cleared as defaulted by MicroProfile Config property.");
            Assert.assertEquals((String)((String)cf3.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"III", (String)"Unexpected result of third task.");
            Assert.assertEquals((String)((String)cf4.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"IV", (String)"Unexpected result of fourth task.");
        }
        finally {
            barrier.forceTermination();
            Buffer.set(null);
            Label.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"beanInjected"})
    public void explicitlySpecifiedPropagatedTakesPrecedenceOverDefaults() throws ExecutionException, InterruptedException, TimeoutException {
        CompletableFuture<Integer> completedFuture = this.bean.getCompletedFuture();
        Assert.assertNotNull(completedFuture);
        int originalPriority = Thread.currentThread().getPriority();
        try {
            int newPriority = originalPriority == 2 ? 1 : 2;
            Thread.currentThread().setPriority(newPriority);
            Buffer.set(new StringBuffer("explicitlySpecifiedPropagatedTakesPrecedenceOverDefaults-test-buffer"));
            Label.set("explicitlySpecifiedPropagatedTakesPrecedenceOverDefaults-test-label");
            CompletionStage stage1 = completedFuture.thenRun(() -> {
                Assert.assertEquals((int)Thread.currentThread().getPriority(), (int)5, (String)"Context type (ThreadPriority) that is explicitly configured to be cleared was not cleared.");
                Assert.assertEquals((String)Buffer.get().toString(), (String)"", (String)"Context type (Buffer) that is explicitly configured to be cleared was not cleared.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type (Label) that is explicitly configured to be cleared was not cleared.");
            });
            Assert.assertNull(((CompletableFuture)stage1).get(MAX_WAIT_NS, TimeUnit.NANOSECONDS), (String)"Non-null value returned by stage that runs Runnable.");
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"beanInjected"})
    public void explicitlySpecifyAllAttributesOfThreadContext() {
        Executor contextSnapshot = this.bean.getContextSnapshot();
        Assert.assertNotNull((Object)contextSnapshot);
        int originalPriority = Thread.currentThread().getPriority();
        try {
            Buffer.set(new StringBuffer("explicitlySpecifyAllAttributesOfThreadContext-test-buffer"));
            Label.set("explicitlySpecifyAllAttributesOfThreadContext-test-label");
            int newPriority = originalPriority == 2 ? 1 : 2;
            Thread.currentThread().setPriority(newPriority);
            contextSnapshot.execute(() -> {
                Assert.assertEquals((String)Buffer.get().toString(), (String)"setContextSnapshot-test-buffer", (String)"Context type that is explicitly configured to propagated was not propagated.");
                Assert.assertEquals((String)Label.get(), (String)"", (String)"Context type (Label) that is explicitly configured to be cleared was not cleared.");
                Assert.assertEquals((int)Thread.currentThread().getPriority(), (int)5, (String)"Context type (ThreadPriority) that is explicitly configured to be cleared was not cleared.");
            });
        }
        finally {
            Buffer.set(null);
            Label.set(null);
            Thread.currentThread().setPriority(originalPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"beanInjected"})
    public void explicitlySpecifyMaxQueued5() throws ExecutionException, InterruptedException, TimeoutException {
        Assert.assertNotNull((Object)this.producedExecutor, (String)"Injection failure. Cannot run test.");
        Phaser barrier = new Phaser(1);
        try {
            this.producedExecutor.submit(() -> barrier.awaitAdvanceInterruptibly(barrier.arrive() + 1));
            barrier.awaitAdvanceInterruptibly(0, MAX_WAIT_NS, TimeUnit.NANOSECONDS);
            CompletableFuture future1 = this.producedExecutor.supplyAsync(() -> "Q_1");
            CompletableFuture future2 = this.producedExecutor.supplyAsync(() -> "Q_2");
            CompletableFuture future3 = this.producedExecutor.supplyAsync(() -> "Q_3");
            Future future4 = this.producedExecutor.submit(() -> "Q_4");
            Future future5 = this.producedExecutor.submit(() -> "Q_5");
            try {
                Future future6 = this.producedExecutor.submit(() -> "Q_6");
                Assert.fail((String)("Exceeded maxQueued of 5. Future for 6th queued task/action is " + future6));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
            barrier.arrive();
            Assert.assertEquals((String)((String)future1.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"Q_1", (String)"Unexpected result of first task.");
            Assert.assertEquals((String)((String)future2.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"Q_2", (String)"Unexpected result of second task.");
            Assert.assertEquals((String)((String)future3.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"Q_3", (String)"Unexpected result of third task.");
            Assert.assertEquals((String)((String)future4.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"Q_4", (String)"Unexpected result of fourth task.");
            Assert.assertEquals((String)((String)future5.get(MAX_WAIT_NS, TimeUnit.NANOSECONDS)), (String)"Q_5", (String)"Unexpected result of fifth task.");
        }
        finally {
            barrier.forceTermination();
        }
    }
}

