/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.tck.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.tck.cdi.AbstractBean;
import org.eclipse.microprofile.context.tck.cdi.ConversationScopedBean;
import org.eclipse.microprofile.context.tck.cdi.RequestScopedBean;
import org.eclipse.microprofile.context.tck.cdi.SessionScopedBean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CDIContextTest
extends Arquillian {
    static final int TIMEOUT_MIN = 2;
    @Inject
    Instance<Object> instance;
    @Inject
    BeanManager bm;

    @AfterMethod
    public void afterMethod(Method m, ITestResult result) {
        System.out.println("<<< END " + m.getClass().getSimpleName() + '.' + m.getName() + (result.isSuccess() ? " SUCCESS" : " FAILED"));
        Throwable failure = result.getThrowable();
        if (failure != null) {
            failure.printStackTrace(System.out);
        }
    }

    @BeforeMethod
    public void beforeMethod(Method m) {
        System.out.println(">>> BEGIN " + m.getClass().getSimpleName() + '.' + m.getName());
    }

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(CDIContextTest.class.getSimpleName() + ".war"))).addClass(AbstractBean.class)).addClass(RequestScopedBean.class)).addClass(SessionScopedBean.class)).addClass(ConversationScopedBean.class)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        System.out.println(war.toString(true));
        return war;
    }

    @Test
    public void testCDIMECtxPropagatesRequestScopedBean() throws Exception {
        try {
            this.bm.getContext(RequestScoped.class);
        }
        catch (ContextNotActiveException e) {
            return;
        }
        ManagedExecutor propagateCDI = ManagedExecutor.builder().propagated(new String[]{"CDI"}).cleared(new String[]{"Remaining"}).build();
        Instance selectedInstance = this.instance.select(RequestScopedBean.class, new Annotation[0]);
        Assert.assertTrue((boolean)selectedInstance.isResolvable());
        try {
            this.checkCDIPropagation(true, "testCDI_ME_Ctx_Propagate-REQUEST", propagateCDI, (AbstractBean)selectedInstance.get());
        }
        finally {
            propagateCDI.shutdown();
        }
    }

    @Test
    public void testCDIMECtxPropagatesSessionScopedBean() throws Exception {
        try {
            this.bm.getContext(SessionScoped.class);
        }
        catch (ContextNotActiveException e) {
            return;
        }
        ManagedExecutor propagateCDI = ManagedExecutor.builder().propagated(new String[]{"CDI"}).cleared(new String[]{"Remaining"}).build();
        Instance selectedInstance = this.instance.select(SessionScopedBean.class, new Annotation[0]);
        Assert.assertTrue((boolean)selectedInstance.isResolvable());
        try {
            this.checkCDIPropagation(true, "testCDI_ME_Ctx_Propagate-SESSION", propagateCDI, (AbstractBean)selectedInstance.get());
        }
        finally {
            propagateCDI.shutdown();
        }
    }

    @Test
    public void testCDIMECtxPropagatesConversationScopedBean() throws Exception {
        try {
            this.bm.getContext(ConversationScoped.class);
        }
        catch (ContextNotActiveException e) {
            return;
        }
        ManagedExecutor propagateCDI = ManagedExecutor.builder().propagated(new String[]{"CDI"}).cleared(new String[]{"Remaining"}).build();
        Instance selectedInstance = this.instance.select(ConversationScopedBean.class, new Annotation[0]);
        Assert.assertTrue((boolean)selectedInstance.isResolvable());
        try {
            this.checkCDIPropagation(true, "testCDI_ME_Ctx_Propagate-CONVERSATION", propagateCDI, (AbstractBean)selectedInstance.get());
        }
        finally {
            propagateCDI.shutdown();
        }
    }

    @Test
    public void testCDIMECtxClearsRequestScopedBean() throws Exception {
        try {
            this.bm.getContext(RequestScoped.class);
        }
        catch (ContextNotActiveException e) {
            return;
        }
        ManagedExecutor propagatedNone = ManagedExecutor.builder().propagated(new String[0]).cleared(new String[]{"Remaining"}).build();
        Instance selectedInstance = this.instance.select(RequestScopedBean.class, new Annotation[0]);
        Assert.assertTrue((boolean)selectedInstance.isResolvable());
        try {
            this.checkCDIPropagation(false, "testCDI_ME_Ctx_Clear-REQUEST", propagatedNone, (AbstractBean)selectedInstance.get());
        }
        finally {
            propagatedNone.shutdown();
        }
    }

    @Test
    public void testCDIMECtxClearsSessionScopedBeans() throws Exception {
        try {
            this.bm.getContext(SessionScoped.class);
        }
        catch (ContextNotActiveException e) {
            return;
        }
        ManagedExecutor propagatedNone = ManagedExecutor.builder().propagated(new String[0]).cleared(new String[]{"Remaining"}).build();
        Instance selectedInstance = this.instance.select(SessionScopedBean.class, new Annotation[0]);
        Assert.assertTrue((boolean)selectedInstance.isResolvable());
        try {
            this.checkCDIPropagation(false, "testCDI_ME_Ctx_Clear-SESSION", propagatedNone, (AbstractBean)selectedInstance.get());
        }
        finally {
            propagatedNone.shutdown();
        }
    }

    @Test
    public void testCDIMECtxClearsConversationScopedBeans() throws Exception {
        try {
            this.bm.getContext(ConversationScoped.class);
        }
        catch (ContextNotActiveException e) {
            return;
        }
        ManagedExecutor propagatedNone = ManagedExecutor.builder().propagated(new String[0]).cleared(new String[]{"Remaining"}).build();
        Instance selectedInstance = this.instance.select(ConversationScopedBean.class, new Annotation[0]);
        Assert.assertTrue((boolean)selectedInstance.isResolvable());
        try {
            this.checkCDIPropagation(false, "testCDI_ME_Ctx_Clear-CONVERSATION", propagatedNone, (AbstractBean)selectedInstance.get());
        }
        finally {
            propagatedNone.shutdown();
        }
    }

    private void checkCDIPropagation(boolean expectPropagate, String stateToPropagate, ManagedExecutor me, AbstractBean bean) throws Exception {
        bean.setState(stateToPropagate);
        CompletableFuture cf = me.supplyAsync(() -> {
            String state = bean.getState();
            return state;
        });
        Assert.assertEquals((String)((String)cf.get(2L, TimeUnit.MINUTES)), (String)(expectPropagate ? stateToPropagate : "UNINITIALIZED"));
    }

    @Test
    public void testCDITCCtxPropagate() throws Exception {
        ThreadContext defaultTC = ThreadContext.builder().propagated(new String[]{"CDI"}).cleared(new String[]{"Remaining"}).unchanged(new String[0]).build();
        Instance selectedInstance = this.instance.select(RequestScopedBean.class, new Annotation[0]);
        Assert.assertTrue((boolean)selectedInstance.isResolvable());
        RequestScopedBean requestBean = (RequestScopedBean)selectedInstance.get();
        requestBean.setState("testCDIContextPropagate-STATE2");
        Callable getState = defaultTC.contextualCallable(() -> {
            String state = requestBean.getState();
            return state;
        });
        Assert.assertEquals((String)((String)getState.call()), (String)"testCDIContextPropagate-STATE2");
    }

    @Test
    public void testCDITCCtxClear() throws Exception {
        ThreadContext clearAllCtx = ThreadContext.builder().propagated(new String[0]).cleared(new String[]{"Remaining"}).unchanged(new String[0]).build();
        Instance selectedInstance = this.instance.select(RequestScopedBean.class, new Annotation[0]);
        Assert.assertTrue((boolean)selectedInstance.isResolvable());
        RequestScopedBean requestBean = (RequestScopedBean)selectedInstance.get();
        requestBean.setState("testCDIThreadCtxClear-STATE1");
        Callable getState = clearAllCtx.contextualCallable(() -> {
            String state = requestBean.getState();
            return state;
        });
        Assert.assertEquals((String)((String)getState.call()), (String)"UNINITIALIZED");
    }
}

