/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config.tck;

import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConfigValueTest
extends Arquillian {
    @Inject
    private ConfigValueBean configValueBean;

    @Deployment
    public static WebArchive deployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ConfigValueTest.war")).addClasses(new Class[]{ConfigValueBean.class})).addAsServiceProvider(ConfigSource.class, new Class[]{ConfigValueConfigSource.class, ConfigValueLowerConfigSource.class})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    void configValue() {
        ConfigValue configValue = ConfigProvider.getConfig().getConfigValue("my.prop");
        Assert.assertNotNull((Object)configValue);
        Assert.assertEquals((String)configValue.getName(), (String)"my.prop");
        Assert.assertEquals((String)configValue.getValue(), (String)"1234");
        Assert.assertEquals((String)configValue.getSourceName(), (String)"ConfigValueConfigSource");
        Assert.assertEquals((int)configValue.getSourceOrdinal(), (int)1000);
    }

    @Test
    public void configValueEmpty() {
        ConfigValue configValue = ConfigProvider.getConfig().getConfigValue("not.found");
        Assert.assertNotNull((Object)configValue);
        Assert.assertEquals((String)configValue.getName(), (String)"not.found");
        Assert.assertNull((Object)configValue.getValue());
        Assert.assertNull((Object)configValue.getSourceName());
        Assert.assertEquals((int)configValue.getSourceOrdinal(), (int)0);
    }

    @Test
    public void configValueInjection() {
        ConfigValue configValue = this.configValueBean.getConfigValue();
        Assert.assertNotNull((Object)configValue);
        Assert.assertEquals((String)configValue.getName(), (String)"my.prop");
        Assert.assertEquals((String)configValue.getValue(), (String)"1234");
        Assert.assertEquals((String)configValue.getSourceName(), (String)ConfigValueConfigSource.class.getSimpleName());
        Assert.assertEquals((int)configValue.getSourceOrdinal(), (int)1000);
        ConfigValue configValueDefault = this.configValueBean.getConfigValueDefault();
        Assert.assertNotNull((Object)configValueDefault);
        Assert.assertEquals((String)configValue.getName(), (String)"my.prop");
        Assert.assertEquals((String)configValueDefault.getValue(), (String)"default");
        Assert.assertNull((Object)configValueDefault.getSourceName());
    }

    @Dependent
    public static class ConfigValueBean {
        @Inject
        @ConfigProperty(name="my.prop")
        private ConfigValue configValue;
        @Inject
        @ConfigProperty(name="my.prop.default", defaultValue="default")
        private ConfigValue configValueDefault;

        ConfigValue getConfigValue() {
            return this.configValue;
        }

        ConfigValue getConfigValueDefault() {
            return this.configValueDefault;
        }
    }

    public static class ConfigValueLowerConfigSource
    implements ConfigSource {
        private Map<String, String> properties = new HashMap<String, String>();

        public ConfigValueLowerConfigSource() {
            this.properties.put("my.prop", "5678");
        }

        public Set<String> getPropertyNames() {
            return this.properties.keySet();
        }

        public String getValue(String propertyName) {
            return this.properties.get(propertyName);
        }

        public String getName() {
            return this.getClass().getSimpleName();
        }

        public int getOrdinal() {
            return 900;
        }
    }

    public static class ConfigValueConfigSource
    implements ConfigSource {
        private Map<String, String> properties = new HashMap<String, String>();

        public ConfigValueConfigSource() {
            this.properties.put("my.prop", "1234");
        }

        public Set<String> getPropertyNames() {
            return this.properties.keySet();
        }

        public String getValue(String propertyName) {
            return this.properties.get(propertyName);
        }

        public String getName() {
            return this.getClass().getSimpleName();
        }

        public int getOrdinal() {
            return 1000;
        }
    }
}

