/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.compiler;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.oql.compiler.CompilerImpl;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.parser.internal.oql.compiler.PathExpression;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.PatternUtil;

class MethodCallExpression
extends Expression {
    String name;
    List<Expression> parameters;

    public MethodCallExpression(String name, List<Expression> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    @Override
    public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
        int n;
        List<?> subject = ctx.getSubject();
        if (subject == null) {
            return null;
        }
        if (subject.getClass().isArray()) {
            subject = PathExpression.asList(subject);
        }
        Object[] arguments = new Object[this.parameters.size()];
        int ii = 0;
        while (ii < arguments.length) {
            arguments[ii] = this.parameters.get(ii).compute(ctx);
            ++ii;
        }
        if (subject instanceof IObject && "toString".equals(this.name) && this.parameters.isEmpty()) {
            String name = ((IObject)subject).getClassSpecificName();
            return name != null ? name : ((IObject)subject).getTechnicalName();
        }
        ArrayList<Method> extraMethods = new ArrayList<Method>();
        Class<?> subjectClass = subject.getClass();
        Method[] methods = subjectClass.getMethods();
        boolean alwaysInterfaces = true;
        if (!Modifier.isPublic(subjectClass.getModifiers()) || alwaysInterfaces) {
            Class<?> c;
            int n2;
            Class<?>[] classArray;
            Class<?> superClass = subjectClass;
            while (superClass != null) {
                classArray = superClass.getInterfaces();
                n2 = classArray.length;
                n = 0;
                while (n < n2) {
                    c = classArray[n];
                    this.firstChoiceMethods(extraMethods, c, arguments);
                    ++n;
                }
                superClass = superClass.getSuperclass();
            }
            this.firstChoiceMethods(extraMethods, subjectClass, arguments);
            superClass = subjectClass;
            while (superClass != null) {
                classArray = superClass.getInterfaces();
                n2 = classArray.length;
                n = 0;
                while (n < n2) {
                    c = classArray[n];
                    extraMethods.addAll(Arrays.asList(c.getMethods()));
                    ++n;
                }
                superClass = superClass.getSuperclass();
            }
        } else {
            this.firstChoiceMethods(extraMethods, subjectClass, arguments);
        }
        if (subject instanceof Class) {
            Method[] methodArray = ((Class)((Object)subject)).getMethods();
            n = methodArray.length;
            int c = 0;
            while (c < n) {
                Method m = methodArray[c];
                if (Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers())) {
                    extraMethods.add(m);
                }
                ++c;
            }
        }
        if (extraMethods.size() > 0) {
            extraMethods.addAll(Arrays.asList(methods));
            extraMethods = new ArrayList<Method>(new LinkedHashSet<Method>(extraMethods));
            methods = extraMethods.toArray(new Method[extraMethods.size()]);
        }
        SnapshotException deferred = null;
        int ii2 = 0;
        while (ii2 < methods.length) {
            block35: {
                Class<?>[] parameterTypes;
                if (methods[ii2].getName().equals(this.name) && ((parameterTypes = methods[ii2].getParameterTypes()).length == arguments.length || methods[ii2].isVarArgs() && parameterTypes.length < arguments.length)) {
                    Object[] savedArgs = null;
                    int jj = 0;
                    while (jj < arguments.length) {
                        if (arguments[jj] == CompilerImpl.ConstantExpression.NULL) {
                            arguments[jj] = null;
                        }
                        if (!(methods[ii2].isVarArgs() && jj >= parameterTypes.length - 1 || arguments[jj] == null || this.isConvertible(parameterTypes[jj], arguments[jj]))) {
                            if (!parameterTypes[jj].isAssignableFrom(Pattern.class)) {
                                if (savedArgs != null) {
                                    int ia = 0;
                                    while (ia < savedArgs.length) {
                                        if (savedArgs[ia] != null) {
                                            arguments[ia] = savedArgs[ia];
                                        }
                                        ++ia;
                                    }
                                }
                                break block35;
                            }
                            if (savedArgs == null) {
                                savedArgs = new Object[arguments.length];
                            }
                            savedArgs[jj] = arguments[jj];
                            arguments[jj] = Pattern.compile(PatternUtil.smartFix((String)String.valueOf(arguments[jj]), (boolean)false));
                        }
                        ++jj;
                    }
                    try {
                        MethodCallExpression.checkMethodAccess(methods[ii2]);
                        if (methods[ii2].isVarArgs()) {
                            Object[] args2 = this.convertVarArgs(parameterTypes, arguments);
                            if (args2 != null) {
                                return methods[ii2].invoke(subject, args2);
                            }
                            break block35;
                        }
                        return methods[ii2].invoke(subject, arguments);
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnapshotException(Arrays.toString(arguments), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new SnapshotException(methods[ii2].toString(), (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new SnapshotException((Throwable)e);
                    }
                    catch (SecurityException e) {
                        deferred = new SnapshotException(methods[ii2].toString(), (Throwable)e);
                    }
                }
            }
            ++ii2;
        }
        if (deferred != null) {
            throw deferred;
        }
        StringBuilder argTypes = new StringBuilder();
        Object[] objectArray = arguments;
        int n3 = arguments.length;
        int n4 = 0;
        while (n4 < n3) {
            Object arg = objectArray[n4];
            if (argTypes.length() > 0) {
                argTypes.append(", ");
            }
            if (arg == CompilerImpl.ConstantExpression.NULL) {
                arg = null;
            }
            argTypes.append(arg != null ? this.unboxedType(arg.getClass()).getName() : null);
            ++n4;
        }
        throw new SnapshotException(MessageUtil.format((String)Messages.MethodCallExpression_Error_MethodNotFound, (Object[])new Object[]{this.name, argTypes, subject, subjectClass.getName()}));
    }

    private void firstChoiceMethods(List<Method> extraMethods, Class<? extends Object> subjectClass, Object[] arguments) {
        Class[] argumentTypes1 = new Class[arguments.length];
        Class[] argumentTypes2 = new Class[arguments.length];
        int i = 0;
        boolean unbox = false;
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object args = objectArray[n2];
            if (args == CompilerImpl.ConstantExpression.NULL) {
                args = null;
            }
            if (args != null) {
                argumentTypes1[i] = args.getClass();
            }
            argumentTypes2[i] = this.unboxedType(argumentTypes1[i]);
            if (argumentTypes2[i] != argumentTypes1[i]) {
                unbox = true;
            }
            ++i;
            ++n2;
        }
        this.extracted(extraMethods, subjectClass, argumentTypes1);
        if (unbox) {
            this.extracted(extraMethods, subjectClass, argumentTypes2);
        }
    }

    private void extracted(List<Method> extraMethods, Class<? extends Object> subjectClass, Class<?>[] argumentTypes1) {
        try {
            Method[] methodArray = subjectClass.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    int parameterCount;
                    Method m2 = methodArray[n2];
                    if (m2.getName().equals(this.name) && (parameterCount = m2.getParameterCount()) == argumentTypes1.length) {
                        Class<?>[] parameterTypes = m2.getParameterTypes();
                        int j = 0;
                        while (j < parameterCount) {
                            Class<?> pt = parameterTypes[j];
                            if (argumentTypes1[j] == null || pt.isAssignableFrom(argumentTypes1[j])) {
                                ++j;
                                continue;
                            }
                            break block7;
                        }
                        Method m1 = subjectClass.getMethod(this.name, argumentTypes1);
                        extraMethods.add(m1);
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private Class<?> unboxedType(Class<?> arg) {
        if (arg == Boolean.class) {
            arg = Boolean.TYPE;
        }
        if (arg == Byte.class) {
            arg = Byte.TYPE;
        } else if (arg == Short.class) {
            arg = Short.TYPE;
        } else if (arg == Character.class) {
            arg = Character.TYPE;
        } else if (arg == Integer.class) {
            arg = Integer.TYPE;
        } else if (arg == Long.class) {
            arg = Long.TYPE;
        } else if (arg == Float.class) {
            arg = Float.TYPE;
        } else if (arg == Double.class) {
            arg = Double.TYPE;
        }
        return arg;
    }

    private boolean isConvertible(Class<?> parameterType, Object argument) {
        Class<?> argumentType = argument.getClass();
        if (parameterType.isAssignableFrom(argumentType)) {
            return true;
        }
        if (argumentType == Boolean.class && (parameterType == Boolean.TYPE || parameterType == Boolean.class)) {
            return true;
        }
        if (argumentType == Byte.class && (parameterType == Byte.TYPE || parameterType == Byte.class || parameterType == Short.TYPE || parameterType == Short.class || parameterType == Integer.TYPE || parameterType == Integer.class || parameterType == Long.TYPE || parameterType == Long.class || parameterType == Float.TYPE || parameterType == Float.class || parameterType == Double.TYPE || parameterType == Double.class)) {
            return true;
        }
        if (argumentType == Short.class && (parameterType == Short.TYPE || parameterType == Short.class || parameterType == Integer.TYPE || parameterType == Integer.class || parameterType == Long.TYPE || parameterType == Long.class || parameterType == Float.TYPE || parameterType == Float.class || parameterType == Double.TYPE || parameterType == Double.class)) {
            return true;
        }
        if (argumentType == Character.class && (parameterType == Character.TYPE || parameterType == Character.class || parameterType == Integer.TYPE || parameterType == Integer.class || parameterType == Long.TYPE || parameterType == Long.class || parameterType == Float.TYPE || parameterType == Float.class || parameterType == Double.TYPE || parameterType == Double.class)) {
            return true;
        }
        if (argumentType == Integer.class && (parameterType == Integer.TYPE || parameterType == Integer.class || parameterType == Long.TYPE || parameterType == Long.class || parameterType == Float.TYPE || parameterType == Float.class || parameterType == Double.TYPE || parameterType == Double.class)) {
            return true;
        }
        if (argumentType == Long.class && (parameterType == Long.TYPE || parameterType == Long.class || parameterType == Float.TYPE || parameterType == Float.class || parameterType == Double.TYPE || parameterType == Double.class)) {
            return true;
        }
        if (argumentType == Float.class && (parameterType == Float.TYPE || parameterType == Float.class || parameterType == Double.TYPE || parameterType == Double.class)) {
            return true;
        }
        return argumentType == Double.class && (parameterType == Double.TYPE || parameterType == Double.class);
    }

    static void checkMethodAccess(Method method) {
        String match = System.getProperty("mat.oql.methodFilter", "org.eclipse.mat.snapshot.model.*;!org.eclipse.mat.snapshot.ISnapshot#dispose;org.eclipse.mat.snapshot.*;java.util.*;!java.lang.ClassLoader#*;!java.lang.Compiler#*;!java.lang.Module*;!java.lang.Process*;!java.lang.Runtime#*;!java.lang.SecurityManager#*;!java.lang.System#*;!java.lang.Thread*;java.lang.*;!*");
        String nm = String.valueOf(method.getDeclaringClass().getName()) + "#" + method.getName();
        String[] stringArray = match.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i;
            String pt = stringArray[n2];
            boolean not = pt.startsWith("!");
            if (not) {
                pt = pt.substring(1);
            }
            boolean m = pt.endsWith(".**") ? nm.startsWith(pt.substring(0, pt.length() - 2)) : (pt.endsWith(".*") ? nm.startsWith(pt.substring(0, pt.length() - 1)) && !nm.substring(pt.length() - 1).contains(".") : (pt.endsWith("*") ? nm.startsWith(pt.substring(0, pt.length() - 1)) : (pt.contains("*") ? nm.startsWith(pt.substring(0, i = pt.indexOf("*"))) && nm.endsWith(pt.substring(i + 1)) : nm.equals(pt))));
            if (not && m) {
                throw new AccessControlException(MessageUtil.format((String)Messages.MethodCallExpression_Error_MethodProhibited, (Object[])new Object[]{nm, "!" + pt, match}));
            }
            if (m) break;
            ++n2;
        }
    }

    private Object[] convertVarArgs(Class<?>[] parameterTypes, Object[] arguments) {
        if (arguments.length != parameterTypes.length || arguments[arguments.length - 1] != null && !parameterTypes[parameterTypes.length - 1].isAssignableFrom(arguments[arguments.length - 1].getClass())) {
            Object[] varargs;
            Object[] args2 = new Object[parameterTypes.length];
            int i = 0;
            while (i < parameterTypes.length - 1) {
                args2[i] = arguments[i];
                ++i;
            }
            Class<?> componentType = parameterTypes[parameterTypes.length - 1].getComponentType();
            args2[parameterTypes.length - 1] = varargs = (Object[])Array.newInstance(componentType, arguments.length - (parameterTypes.length - 1));
            int i2 = parameterTypes.length - 1;
            while (i2 < arguments.length) {
                if (arguments[i2] != null && !componentType.isAssignableFrom(arguments[i2].getClass())) {
                    return null;
                }
                varargs[i2 - (parameterTypes.length - 1)] = arguments[i2];
                ++i2;
            }
            return args2;
        }
        return arguments;
    }

    @Override
    public boolean isContextDependent(EvaluationContext ctx) {
        for (Expression element : this.parameters) {
            boolean isContextDependent = element.isContextDependent(ctx);
            if (!isContextDependent) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append(this.name);
        buf.append("(");
        Iterator<Expression> iter = this.parameters.iterator();
        while (iter.hasNext()) {
            Expression element = iter.next();
            buf.append(element);
            if (!iter.hasNext()) continue;
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }
}

