/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.facets;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarVersionChangeDelegate
implements IDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(WarVersionChangeDelegate.class);

    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        block12: {
            if (monitor != null) {
                monitor.beginTask("Updating Dynamic Web facet to " + fv, 1);
            }
            try {
                if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) break block12;
                IDataModel model = (IDataModel)cfg;
                IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)true);
                if (c == null) {
                    return;
                }
                try {
                    if (model != null && model.isProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT")) {
                        IWorkspace ws = ResourcesPlugin.getWorkspace();
                        IPath pjpath = project.getFullPath();
                        IPath contentdir = this.setContentPropertyIfNeeded(model, pjpath, project);
                        WarVersionChangeDelegate.mkdirs(ws.getRoot().getFolder(contentdir), monitor);
                        IVirtualFolder contentRootFolder = c.getRootFolder();
                        WTPProjectsUtil.setDefaultDeploymentDescriptorFolder(contentRootFolder, contentdir, monitor);
                        String contextRoot = model.getStringProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT");
                        this.setContextRootPropertyIfNeeded(c, contextRoot);
                        IDataModelOperation notificationOperation = (IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION");
                        if (notificationOperation != null) {
                            notificationOperation.execute(monitor, null);
                        }
                    }
                }
                catch (ExecutionException e) {
                    LOG.error("Unable to notify Dynamic Web version change", (Throwable)e);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    private static void mkdirs(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                WarVersionChangeDelegate.mkdirs((IFolder)folder.getParent(), monitor);
            }
            folder.create(true, true, null);
        } else {
            IFolder x = folder;
            while (x instanceof IFolder && x.isDerived()) {
                x.setDerived(false, monitor);
                x = x.getParent();
            }
        }
    }

    private void setContextRootPropertyIfNeeded(IVirtualComponent c, String contextRoot) {
        String existing = c.getMetaProperties().getProperty("context-root");
        if (existing == null) {
            c.setMetaProperty("context-root", contextRoot);
        }
    }

    private IPath setContentPropertyIfNeeded(IDataModel model, IPath pjpath, IProject project) {
        IVirtualComponent c = ComponentCore.createComponent((IProject)project, (boolean)false);
        if (c.exists() && !c.getRootFolder().getProjectRelativePath().isRoot()) {
            return c.getRootFolder().getUnderlyingResource().getFullPath();
        }
        return pjpath.append(model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER"));
    }
}

