/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.eclipse.m2e.wtp.IProjectConfiguratorDelegate;
import org.eclipse.m2e.wtp.MarkedException;
import org.eclipse.m2e.wtp.ProjectConfiguratorDelegateFactory;
import org.eclipse.m2e.wtp.internal.filtering.ResourceFilteringBuildParticipant;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WTPProjectConfigurator
extends AbstractProjectConfigurator
implements IJavaProjectConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(WTPProjectConfigurator.class);

    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = request.getMavenProject();
        IProjectConfiguratorDelegate configuratorDelegate = ProjectConfiguratorDelegateFactory.getProjectConfiguratorDelegate(mavenProject.getPackaging());
        if (configuratorDelegate != null) {
            IProject project = request.getProject();
            if (project.getResourceAttributes().isReadOnly()) {
                return;
            }
            try {
                configuratorDelegate.configureProject(project, mavenProject, monitor);
            }
            catch (MarkedException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = event.getMavenProject();
        if (facade != null) {
            MavenProject mavenProject;
            IProjectConfiguratorDelegate configuratorDelegate;
            IProject project = facade.getProject();
            if (project.getResourceAttributes().isReadOnly()) {
                return;
            }
            if (WTPProjectConfigurator.isWTPProject(project) && (configuratorDelegate = ProjectConfiguratorDelegateFactory.getProjectConfiguratorDelegate((mavenProject = facade.getMavenProject(monitor)).getPackaging())) != null) {
                configuratorDelegate.setModuleDependencies(project, mavenProject, monitor);
            }
        }
    }

    protected static boolean isWTPProject(IProject project) {
        return ModuleCoreNature.isFlexibleProject((IProject)project);
    }

    public void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = facade.getMavenProject(monitor);
        IProjectConfiguratorDelegate configuratorDelegate = ProjectConfiguratorDelegateFactory.getProjectConfiguratorDelegate(mavenProject.getPackaging());
        if (configuratorDelegate != null) {
            IProject project = facade.getProject();
            try {
                configuratorDelegate.configureClasspath(project, mavenProject, classpath, monitor);
            }
            catch (CoreException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void configureRawClasspath(ProjectConfigurationRequest request, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
    }

    public AbstractBuildParticipant getBuildParticipant(IMavenProjectFacade projectFacade, MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        if ("maven-war-plugin".equals(execution.getArtifactId()) && "war".equals(execution.getGoal()) || "maven-ear-plugin".equals(execution.getArtifactId()) && "generate-application-xml".equals(execution.getGoal()) || "maven-acr-plugin".equals(execution.getArtifactId()) && "acr".equals(execution.getGoal())) {
            return new ResourceFilteringBuildParticipant();
        }
        return null;
    }
}

