/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.internal.modulecore;

import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.FileSystemResourceFilter;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.ResourceListVirtualFolder;
import org.eclipse.m2e.wtp.overlay.modulecore.IOverlayVirtualComponent;
import org.eclipse.m2e.wtp.overlay.modulecore.UnpackArchiveJob;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlayVirtualArchiveComponent
extends VirtualArchiveComponent
implements IOverlayVirtualComponent {
    protected IPath unpackDirPath;
    private Set<String> inclusions;
    private Set<String> exclusions;

    public OverlayVirtualArchiveComponent(IProject aComponentProject, String archiveLocation, IPath unpackDirPath, IPath aRuntimePath) {
        super(aComponentProject, archiveLocation, aRuntimePath);
        this.unpackDirPath = unpackDirPath;
    }

    @Override
    public void setInclusions(Set<String> inclusionPatterns) {
        this.inclusions = inclusionPatterns;
    }

    @Override
    public void setExclusions(Set<String> exclusionPatterns) {
        this.exclusions = exclusionPatterns;
    }

    public IVirtualFolder getRootFolder() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.getProject());
        File archive = this.getArchive();
        ResourceListVirtualFolder root = null;
        if (component != null && archive != null) {
            IFolder unpackedFolder = this.getUnpackedArchiveFolder(archive);
            if (this.isUnpackNeeded(archive, unpackedFolder)) {
                new UnpackArchiveJob("Unpacking " + archive.getName(), archive, unpackedFolder).schedule();
                root = new ResourceListVirtualFolder(this.getProject(), this.getRuntimePath(), new IContainer[0]);
            } else {
                IContainer[] containers = new IContainer[]{unpackedFolder};
                root = new ResourceListVirtualFolder(this.getProject(), this.getRuntimePath(), containers);
                root.setFilter(new FileSystemResourceFilter(this.inclusions, this.exclusions, unpackedFolder.getLocation()));
            }
        }
        return root;
    }

    protected IFolder getUnpackedArchiveFolder(File archive) {
        IFolder overlaysFolder = this.getProject().getFolder(this.unpackDirPath);
        return overlaysFolder.getFolder(archive.getName());
    }

    private File getArchive() {
        File archive = (File)this.getAdapter(File.class);
        if (archive == null || !archive.exists() || !archive.canRead()) {
            return null;
        }
        return archive;
    }

    private boolean isUnpackNeeded(File archive, IFolder unpackFolder) {
        if (!unpackFolder.exists()) {
            return true;
        }
        long lastUnpacked = new File(unpackFolder.getLocation().toOSString()).lastModified();
        long lastModified = archive.lastModified();
        return lastModified > lastUnpacked;
    }

    public IPath getUnpackFolderPath() {
        return this.unpackDirPath;
    }

    @Override
    public Set<String> getExclusions() {
        return this.exclusions;
    }

    @Override
    public Set<String> getInclusions() {
        return this.inclusions;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.exclusions == null ? 0 : this.exclusions.hashCode());
        result = 31 * result + (this.inclusions == null ? 0 : this.inclusions.hashCode());
        result = 31 * result + (this.unpackDirPath == null ? 0 : this.unpackDirPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OverlayVirtualArchiveComponent other = (OverlayVirtualArchiveComponent)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.exclusions == null ? other.exclusions != null : !this.exclusions.equals(other.exclusions)) {
            return false;
        }
        if (this.inclusions == null ? other.inclusions != null : !this.inclusions.equals(other.inclusions)) {
            return false;
        }
        return !(this.unpackDirPath == null ? other.unpackDirPath != null : !this.unpackDirPath.equals((Object)other.unpackDirPath));
    }
}

