/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.internal.modulecore;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.IFilteredVirtualFolder;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.IResourceFilter;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFile;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class CompositeVirtualFolder
implements IFilteredVirtualFolder {
    private FlatVirtualComponent flatVirtualComponent;
    private IPath runtimePath;
    private IProject project;
    private Set<IVirtualReference> references = new LinkedHashSet<IVirtualReference>();
    private IVirtualResource[] members;
    private IResourceFilter filter;

    public CompositeVirtualFolder(FlatVirtualComponent aFlatVirtualComponent, IPath aRuntimePath, IResourceFilter filter) {
        this.flatVirtualComponent = aFlatVirtualComponent;
        if (this.flatVirtualComponent != null && this.flatVirtualComponent.getComponent() != null) {
            this.project = this.flatVirtualComponent.getComponent().getProject();
        }
        this.runtimePath = aRuntimePath;
        this.filter = filter;
        try {
            this.treeWalk();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public IPath getRuntimePath() {
        return this.runtimePath;
    }

    public IVirtualResource[] members() throws CoreException {
        if (this.members == null) {
            this.members = new IVirtualResource[0];
        }
        return this.members;
    }

    public void treeWalk() throws CoreException {
        IFlatResource[] flatResources = this.flatVirtualComponent.fetchResources();
        ArrayList<IVirtualResource> membersList = new ArrayList<IVirtualResource>(flatResources.length);
        IFlatResource[] iFlatResourceArray = flatResources;
        int n = flatResources.length;
        int n2 = 0;
        while (n2 < n) {
            IFlatResource flatResource = iFlatResourceArray[n2];
            IVirtualResource resource = this.convert(flatResource);
            if (resource != null) {
                membersList.add(resource);
            }
            ++n2;
        }
        this.members = new IVirtualResource[membersList.size()];
        membersList.toArray(this.members);
    }

    private IVirtualResource convert(IFlatResource flatResource) {
        IVirtualFolder virtualResource = null;
        if (flatResource instanceof IFlatFolder) {
            virtualResource = this.convertFolder((IFlatFolder)flatResource);
        } else if (flatResource instanceof IFlatFile) {
            virtualResource = this.convertFile((IFlatFile)flatResource);
        }
        return virtualResource;
    }

    private IVirtualFolder convertFolder(IFlatFolder flatFolder) {
        IFlatResource[] flatMembers = flatFolder.members();
        ArrayList<IVirtualResource> membersList = new ArrayList<IVirtualResource>(flatMembers.length);
        IFlatResource[] iFlatResourceArray = flatMembers;
        int n = flatMembers.length;
        int n2 = 0;
        while (n2 < n) {
            IFlatResource flatResource = iFlatResourceArray[n2];
            IVirtualResource resource = this.convert(flatResource);
            if (resource != null) {
                membersList.add(resource);
            }
            ++n2;
        }
        final IVirtualResource[] folderMembers = new IVirtualResource[membersList.size()];
        membersList.toArray(folderMembers);
        VirtualFolder vf = new VirtualFolder(this.project, flatFolder.getModuleRelativePath().append(flatFolder.getName())){

            public IVirtualResource[] members() throws CoreException {
                return folderMembers;
            }
        };
        return vf;
    }

    private IVirtualFile convertFile(IFlatFile flatFile) {
        IFile f = (IFile)flatFile.getAdapter(IFile.class);
        VirtualFile vf = null;
        String filePath = null;
        if (f == null) {
            File underlyingFile = (File)flatFile.getAdapter(File.class);
            if (underlyingFile != null && underlyingFile.exists()) {
                filePath = String.valueOf(flatFile.getModuleRelativePath().toPortableString()) + '/' + underlyingFile.getName();
                if (this.filter == null || this.filter.accepts(filePath, true)) {
                    IVirtualReference reference = this.createReference(underlyingFile, flatFile.getModuleRelativePath());
                    this.references.add(reference);
                }
            }
        } else {
            final String fileName = f.getName();
            vf = new VirtualFile(this.project, flatFile.getModuleRelativePath(), f){

                public String getName() {
                    return fileName;
                }
            };
            filePath = String.valueOf(vf.getRuntimePath().toPortableString()) + '/' + fileName;
            if (this.filter == null || this.filter.accepts(filePath, true)) {
                return vf;
            }
        }
        return null;
    }

    private IVirtualReference createReference(File underlyingFile, IPath path) {
        VirtualArchiveComponent archive = new VirtualArchiveComponent(this.project, "lib/" + underlyingFile.getAbsolutePath(), path);
        IVirtualReference ref = ComponentCore.createReference((IVirtualComponent)this.flatVirtualComponent.getComponent(), (IVirtualComponent)archive);
        ref.setArchiveName(archive.getArchivePath().lastSegment());
        ref.setRuntimePath(path);
        return ref;
    }

    public void create(int arg0, IProgressMonitor arg1) throws CoreException {
    }

    public boolean exists(IPath arg0) {
        return false;
    }

    public IVirtualResource findMember(String arg0) {
        return null;
    }

    public IVirtualResource findMember(IPath arg0) {
        return null;
    }

    public IVirtualResource findMember(String arg0, int arg1) {
        return null;
    }

    public IVirtualResource findMember(IPath arg0, int arg1) {
        return null;
    }

    public IVirtualFile getFile(IPath arg0) {
        return null;
    }

    public IVirtualFile getFile(String arg0) {
        return null;
    }

    public IVirtualFolder getFolder(IPath arg0) {
        return null;
    }

    public IVirtualFolder getFolder(String arg0) {
        return null;
    }

    public IVirtualResource[] getResources(String arg0) {
        return null;
    }

    public IVirtualResource[] members(int arg0) throws CoreException {
        return null;
    }

    public void createLink(IPath arg0, int arg1, IProgressMonitor arg2) throws CoreException {
    }

    public void delete(int arg0, IProgressMonitor arg1) throws CoreException {
    }

    public boolean exists() {
        return false;
    }

    public IVirtualComponent getComponent() {
        return null;
    }

    public String getFileExtension() {
        return null;
    }

    public String getName() {
        return null;
    }

    public IVirtualContainer getParent() {
        return null;
    }

    public IPath getProjectRelativePath() {
        return null;
    }

    public String getResourceType() {
        return null;
    }

    public int getType() {
        return 0;
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    public IResource[] getUnderlyingResources() {
        return null;
    }

    public IPath getWorkspaceRelativePath() {
        return null;
    }

    public boolean isAccessible() {
        return false;
    }

    public void removeLink(IPath arg0, int arg1, IProgressMonitor arg2) throws CoreException {
    }

    public void setResourceType(String arg0) {
    }

    public boolean contains(ISchedulingRule rule) {
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return false;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IContainer getUnderlyingFolder() {
        return null;
    }

    public IContainer[] getUnderlyingFolders() {
        return null;
    }

    public IVirtualReference[] getReferences() {
        return this.references.toArray(new IVirtualReference[this.references.size()]);
    }

    public IResourceFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IResourceFilter filter) {
        this.filter = filter;
    }
}

