/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.ui.internal.archetype.ArchetypePlugin;
import org.eclipse.m2e.core.ui.internal.util.ArchetypeUtil;
import org.eclipse.m2e.core.ui.internal.util.M2EUIUtils;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.m2e.core.ui.internal.wizards.CustomArchetypeDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectWizardArchetypePage
extends AbstractMavenWizardPage {
    private static final Logger log = LoggerFactory.getLogger(MavenProjectWizardArchetypePage.class);
    private static final String KEY_CATALOG = "catalog";
    private static final String ALL_CATALOGS = Messages.MavenProjectWizardArchetypePage_all;
    public static final Comparator<Archetype> ARCHETYPE_COMPARATOR = Comparator.comparing(Archetype::getGroupId).thenComparing(Archetype::getArtifactId).thenComparing(Archetype::getVersion, Comparator.nullsFirst(Comparator.naturalOrder()));
    private static final boolean DEFAULT_SHOW_LAST_VERSION = true;
    private boolean includeSnapshots;
    private final Map<String, List<Archetype>> archetypesCache = new HashMap<String, List<Archetype>>();
    ComboViewer catalogsComboViewer;
    Text filterText;
    TableViewer viewer;
    Text descriptionText;
    Button showLastVersionButton;
    Button includeShapshotsButton;
    Button addArchetypeButton;
    private volatile Collection<Archetype> archetypes;
    Map<String, List<ArtifactVersion>> archetypeVersions;
    private boolean isUsed = true;
    ArchetypeCatalogFactory catalogFactory = null;
    private RetrievingArchetypesJob job;

    public MavenProjectWizardArchetypePage(ProjectImportConfiguration projectImportConfiguration) {
        super("MavenProjectWizardArchetypePage", projectImportConfiguration);
        this.setTitle(Messages.wizardProjectPageArchetypeTitle);
        this.setDescription(Messages.wizardProjectPageArchetypeDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.archetypesCache.clear();
        this.includeSnapshots = M2EUIPluginActivator.getDefault().getPreferenceStore().getBoolean("enableSnapshotArchetypes");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createViewer(composite);
        this.createAdvancedSettings(composite, new GridData(4, 128, true, false, 3, 1));
        this.setControl((Control)composite);
    }

    private void createViewer(Composite parent) {
        Label catalogsLabel = new Label(parent, 0);
        catalogsLabel.setText(Messages.MavenProjectWizardArchetypePage_lblCatalog);
        Composite catalogsComposite = new Composite(parent, 0);
        GridLayout catalogsCompositeLayout = new GridLayout();
        catalogsCompositeLayout.marginWidth = 0;
        catalogsCompositeLayout.marginHeight = 0;
        catalogsCompositeLayout.numColumns = 2;
        catalogsComposite.setLayout((Layout)catalogsCompositeLayout);
        catalogsComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.catalogsComboViewer = new ComboViewer(catalogsComposite);
        this.catalogsComboViewer.getControl().setData("name", (Object)"catalogsCombo");
        this.catalogsComboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.catalogsComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.catalogsComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Object object = element;
                if (object instanceof ArchetypeCatalogFactory && (var2_3 = (ArchetypeCatalogFactory)object) == (ArchetypeCatalogFactory)var3_2) {
                    return archetypeCatalogFactory.getDescription();
                }
                if (element instanceof String var4_5) {
                    return s;
                }
                return super.getText(element);
            }
        });
        this.catalogsComboViewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            boolean loadAll = false;
            if (selection instanceof IStructuredSelection var4_5) {
                Object factory = structuredSelection.getFirstElement();
                Object newCatalogFactory = null;
                if (factory instanceof ArchetypeCatalogFactory var8_9) {
                    newCatalogFactory = archetypeCatalogFactory;
                }
                if (factory != null && newCatalogFactory == null) {
                    loadAll = true;
                } else if (Objects.equals(this.catalogFactory, newCatalogFactory) && this.viewer.getInput() != null) {
                    return;
                }
                this.catalogFactory = newCatalogFactory;
                this.viewer.setInput(null);
                this.reloadViewer();
            } else {
                loadAll = true;
            }
            if (loadAll) {
                this.catalogFactory = null;
                this.viewer.setInput(null);
                this.loadArchetypes(null, null, null);
            }
            if (this.dialogSettings != null) {
                if (this.catalogFactory != null) {
                    this.dialogSettings.put(KEY_CATALOG, this.catalogFactory.getId());
                } else {
                    this.dialogSettings.put(KEY_CATALOG, ALL_CATALOGS);
                }
            }
        });
        ArchetypePlugin archetypeManager = M2EUIPluginActivator.getDefault().getArchetypePlugin();
        ArrayList<ArchetypeCatalogFactory> allCatalogs = new ArrayList<ArchetypeCatalogFactory>(archetypeManager.getActiveArchetypeCatalogs());
        allCatalogs.add(0, (ArchetypeCatalogFactory)((Object)ALL_CATALOGS));
        this.catalogsComboViewer.setInput(allCatalogs);
        Button configureButton = new Button(catalogsComposite, 0);
        configureButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        configureButton.setText(Messages.MavenProjectWizardArchetypePage_btnConfigure);
        configureButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Collection<ArchetypeCatalogFactory> oldCatalogs = archetypeManager.getActiveArchetypeCatalogs();
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.eclipse.m2e.core.preferences.MavenArchetypesPreferencePage", null, null).open();
            Collection<ArchetypeCatalogFactory> newCatalogs = archetypeManager.getActiveArchetypeCatalogs();
            if (this.catalogFactory != null && !newCatalogs.contains(this.catalogFactory)) {
                this.catalogFactory = null;
            }
            ArchetypeCatalogFactory selectedCatalog = this.catalogFactory;
            for (ArchetypeCatalogFactory newCatalog : newCatalogs) {
                if (oldCatalogs.contains(newCatalog)) continue;
                selectedCatalog = newCatalog;
                break;
            }
            ArrayList<ArchetypeCatalogFactory> allCatalogs1 = new ArrayList<ArchetypeCatalogFactory>(newCatalogs);
            allCatalogs1.add(0, (ArchetypeCatalogFactory)((Object)ALL_CATALOGS));
            this.catalogsComboViewer.setInput(allCatalogs1);
            this.catalogsComboViewer.setSelection((ISelection)new StructuredSelection(selectedCatalog == null ? ALL_CATALOGS : selectedCatalog));
        }));
        Label filterLabel = new Label(parent, 0);
        filterLabel.setLayoutData((Object)new GridData());
        filterLabel.setText(Messages.MavenProjectWizardArchetypePage_lblFilter);
        QuickViewerFilter quickViewerFilter = new QuickViewerFilter();
        VersionsFilter versionFilter = new VersionsFilter(true, this.includeSnapshots);
        this.filterText = new Text(parent, 2176);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterText.addModifyListener((ModifyListener)quickViewerFilter);
        this.filterText.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.keyCode == 0x1000002) {
                this.viewer.getTable().setFocus();
                this.viewer.getTable().setSelection(0);
                this.viewer.setSelection((ISelection)new StructuredSelection(this.viewer.getElementAt(0)), true);
            }
        }));
        ToolBar toolBar = new ToolBar(parent, 0x800000);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ToolItem clearToolItem = new ToolItem(toolBar, 8);
        clearToolItem.setEnabled(false);
        clearToolItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE"));
        clearToolItem.setDisabledImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE_DISABLED"));
        clearToolItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.filterText.setText("")));
        this.filterText.addModifyListener(e -> clearToolItem.setEnabled(this.filterText.getText().length() > 0));
        SashForm sashForm = new SashForm(parent, 512);
        GridData gdSashForm = new GridData(4, 4, false, true, 3, 1);
        gdSashForm.heightHint = 200;
        sashForm.setLayoutData((Object)gdSashForm);
        sashForm.setLayout((Layout)new GridLayout());
        Composite composite1 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.horizontalSpacing = 0;
        gridLayout1.marginWidth = 0;
        gridLayout1.marginHeight = 0;
        composite1.setLayout((Layout)gridLayout1);
        this.viewer = new TableViewer(composite1, 68356);
        Table table = this.viewer.getTable();
        table.setData("name", (Object)"archetypesTable");
        table.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setWidth(150);
        column1.setText(Messages.wizardProjectPageArchetypeColumnGroupId);
        TableColumn column0 = new TableColumn(table, 16384);
        column0.setWidth(150);
        column0.setText(Messages.wizardProjectPageArchetypeColumnArtifactId);
        TableColumn column2 = new TableColumn(table, 16384);
        column2.setWidth(100);
        column2.setText(Messages.wizardProjectPageArchetypeColumnVersion);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.widthHint = 400;
        tableData.heightHint = 200;
        table.setLayoutData((Object)tableData);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ArchetypeLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ARCHETYPE_COMPARATOR.compare((Archetype)e1, (Archetype)e2);
            }
        });
        this.viewer.setComparer(new IElementComparer(){

            /*
             * WARNING - void declaration
             */
            public int hashCode(Object obj) {
                void var3_2;
                Archetype archetype;
                Object object = obj;
                if (object instanceof Archetype && (archetype = (Archetype)object) == (Archetype)var3_2) {
                    void archetype2;
                    return ArchetypeUtil.getHashCode((Archetype)archetype2);
                }
                return obj.hashCode();
            }

            public boolean equals(Object one, Object another) {
                if (one instanceof Archetype var3_4 && ( instanceOfPatternExpressionValue = another) instanceof Archetype var4_6) {
                    return ArchetypeUtil.areEqual((Archetype)first, (Archetype)second);
                }
                return one.equals(another);
            }
        });
        this.viewer.setFilters(new ViewerFilter[]{versionFilter, quickViewerFilter});
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.addSelectionChangedListener(event -> {
            Archetype archetype = this.getArchetype();
            if (archetype != null) {
                String repositoryUrl = archetype.getRepository();
                String description = archetype.getDescription();
                String text = description == null ? "" : description;
                text = text.replace("\n", "").replaceAll("\\s{2,}", " ");
                if (repositoryUrl != null) {
                    text = String.valueOf(text) + (text.length() > 0 ? "\n" + repositoryUrl : repositoryUrl);
                }
                this.descriptionText.setText(text);
                this.setPageComplete(true);
            } else {
                this.descriptionText.setText("");
                this.setPageComplete(false);
            }
        });
        this.viewer.addOpenListener(openevent -> {
            if (this.canFlipToNextPage()) {
                this.getContainer().showPage(this.getNextPage());
            }
        });
        Composite composite2 = new Composite((Composite)sashForm, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        this.descriptionText = new Text(composite2, 2634);
        GridData descriptionTextData = new GridData(4, 4, true, true);
        descriptionTextData.heightHint = 40;
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        descriptionTextData.widthHint = 250;
        sashForm.setWeights(new int[]{80, 20});
        Composite buttonComposite = new Composite(parent, 0);
        GridData gdButtonComposite = new GridData(4, 0x1000000, false, false, 3, 1);
        buttonComposite.setLayoutData((Object)gdButtonComposite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        buttonComposite.setLayout((Layout)gridLayout);
        this.showLastVersionButton = new Button(buttonComposite, 32);
        this.showLastVersionButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.showLastVersionButton.setText(Messages.MavenProjectWizardArchetypePage_btnLast);
        this.showLastVersionButton.setSelection(true);
        this.showLastVersionButton.addSelectionListener((SelectionListener)versionFilter);
        this.includeShapshotsButton = new Button(buttonComposite, 32);
        GridData buttonData = new GridData(16384, 0x1000000, true, false);
        buttonData.horizontalIndent = 25;
        this.includeShapshotsButton.setLayoutData((Object)buttonData);
        this.includeShapshotsButton.setText(Messages.MavenProjectWizardArchetypePage_btnSnapshots);
        this.includeShapshotsButton.setSelection(this.includeSnapshots);
        this.includeShapshotsButton.addSelectionListener((SelectionListener)versionFilter);
        this.addArchetypeButton = new Button(buttonComposite, 0);
        this.addArchetypeButton.setText(Messages.MavenProjectWizardArchetypePage_btnAdd);
        this.addArchetypeButton.setData("name", (Object)"addArchetypeButton");
        buttonData = new GridData(131072, 0x1000000, true, false);
        buttonData.horizontalIndent = 35;
        this.addArchetypeButton.setLayoutData((Object)buttonData);
        this.addArchetypeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            CustomArchetypeDialog dialog = new CustomArchetypeDialog(this.getShell(), Messages.MavenProjectWizardArchetypePage_add_title);
            if (dialog.open() == 0) {
                String archetypeGroupId = dialog.getArchetypeGroupId();
                String archetypeArtifactId = dialog.getArchetypeArtifactId();
                String archetypeVersion = dialog.getArchetypeVersion();
                String repositoryUrl = dialog.getRepositoryUrl();
                this.downloadArchetype(archetypeGroupId, archetypeArtifactId, archetypeVersion, repositoryUrl);
            }
        }));
    }

    public void addArchetypeSelectionListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    @Override
    public void dispose() {
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        this.archetypesCache.clear();
        super.dispose();
    }

    public List<Archetype> getArchetypesForCatalog(ArchetypeCatalogFactory archCatalogFactory, IProgressMonitor monitor) throws CoreException {
        if (archCatalogFactory == null) {
            return this.getAllArchetypes(monitor);
        }
        String catalogId = archCatalogFactory.getId();
        List archs = this.archetypesCache.get(catalogId);
        if (archs == null) {
            archs = archCatalogFactory.getArchetypeCatalog().getArchetypes();
            if (archs == null) {
                archs = Collections.emptyList();
            }
            this.archetypesCache.put(catalogId, archs);
        }
        return archs;
    }

    private List<Archetype> getAllArchetypes(IProgressMonitor monitor) {
        ArchetypePlugin manager = M2EUIPluginActivator.getDefault().getArchetypePlugin();
        Collection<ArchetypeCatalogFactory> archetypeCatalogs = manager.getActiveArchetypeCatalogs();
        ArrayList<Archetype> list = new ArrayList<Archetype>();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        for (ArchetypeCatalogFactory catalog : archetypeCatalogs) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            try {
                List<Archetype> arcs;
                if (catalog.getDescription().startsWith("Test") || (arcs = this.getArchetypesForCatalog(catalog, monitor)) == null) continue;
                list.addAll(arcs);
            }
            catch (Exception ce) {
                log.error("Unable to read archetype catalog: " + catalog.getId(), (Throwable)ce);
            }
        }
        return list;
    }

    void loadArchetypes(final String groupId, final String artifactId, final String version) {
        if (this.job != null) {
            this.job.cancel();
        }
        this.job = new RetrievingArchetypesJob(this.catalogFactory);
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ArchetypePlugin archetypeManager;
                Collection<ArchetypeCatalogFactory> catalogs;
                RetrievingArchetypesJob thisJob = (RetrievingArchetypesJob)event.getJob();
                if (8 == event.getResult().getSeverity() || !MavenProjectWizardArchetypePage.this.isCurrentPage()) {
                    return;
                }
                List<Archetype> catalogArchetypes = thisJob.catalogArchetypes;
                String error = 4 == event.getResult().getSeverity() ? event.getResult().getMessage() : (catalogArchetypes == null || catalogArchetypes.isEmpty() ? ((catalogs = (archetypeManager = M2EUIPluginActivator.getDefault().getArchetypePlugin()).getActiveArchetypeCatalogs()).isEmpty() ? Messages.MavenProjectWizardArchetypePage_error_noEnabledCatalogs : Messages.MavenProjectWizardArchetypePage_error_emptyCatalog) : null);
                Display.getDefault().asyncExec(() -> MavenProjectWizardArchetypePage.this.setErrorMessage(error));
                TreeSet<Archetype> archs = new TreeSet<Archetype>(ARCHETYPE_COMPARATOR);
                if (catalogArchetypes != null) {
                    archs.addAll(catalogArchetypes);
                }
                MavenProjectWizardArchetypePage.this.archetypes = archs;
                Display.getDefault().asyncExec(() -> MavenProjectWizardArchetypePage.this.updateViewer(groupId, artifactId, version));
            }
        });
        this.job.schedule();
    }

    private static String getArchetypeKey(Archetype archetype) {
        return String.valueOf(archetype.getGroupId()) + ":" + archetype.getArtifactId();
    }

    public void setUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public boolean isPageComplete() {
        return !this.isUsed || super.isPageComplete();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ArchetypePlugin archetypeManager = M2EUIPluginActivator.getDefault().getArchetypePlugin();
            String catalogId = this.dialogSettings.get(KEY_CATALOG);
            this.catalogFactory = null;
            if (catalogId != null && !catalogId.equals(ALL_CATALOGS)) {
                this.catalogFactory = archetypeManager.getArchetypeCatalogFactory(catalogId);
            }
            if (this.catalogsComboViewer.getSelection().isEmpty()) {
                this.catalogsComboViewer.setSelection((ISelection)new StructuredSelection(this.catalogFactory == null ? ALL_CATALOGS : this.catalogFactory));
            }
            this.viewer.getTable().setFocus();
            Archetype selected = this.getArchetype();
            if (selected != null) {
                this.viewer.reveal((Object)selected);
            }
        } else if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
    }

    public Archetype getArchetype() {
        return (Archetype)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    void updateViewer(String groupId, String artifactId, String version) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        this.archetypeVersions = MavenProjectWizardArchetypePage.getArchetypeVersions(this.archetypes);
        this.viewer.setInput(this.archetypes);
        if (this.isCurrentPage()) {
            this.selectArchetype(groupId, artifactId, version);
        }
        Table table = this.viewer.getTable();
        int columnCount = table.getColumnCount();
        int width = 0;
        int i = 0;
        while (i < columnCount) {
            TableColumn column = table.getColumn(i);
            column.pack();
            width += column.getWidth();
            ++i;
        }
        GridData tableData = (GridData)table.getLayoutData();
        int oldHint = tableData.widthHint;
        if (width > oldHint) {
            tableData.widthHint = width;
        }
        this.getShell().pack(true);
        tableData.widthHint = oldHint;
    }

    private static Map<String, List<ArtifactVersion>> getArchetypeVersions(Collection<Archetype> archetypes) {
        HashMap versionFactory = new HashMap();
        Map<String, List<ArtifactVersion>> archetypeVersions = archetypes.stream().filter(at -> !M2EUIUtils.nullOrEmpty(at.getVersion())).collect(Collectors.groupingBy(MavenProjectWizardArchetypePage::getArchetypeKey, Collectors.mapping(at -> versionFactory.computeIfAbsent(at.getVersion(), DefaultArtifactVersion::new), Collectors.toCollection(ArrayList::new))));
        for (List versions : archetypeVersions.values()) {
            versions.sort(Comparator.reverseOrder());
        }
        return archetypeVersions;
    }

    protected void selectArchetype(String groupId, String artifactId, String version) {
        Archetype archetype = this.findArchetype(groupId, artifactId, version);
        Table table = this.viewer.getTable();
        if (archetype != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)archetype), true);
            int n = table.getSelectionIndex();
            table.setSelection(n);
        }
    }

    protected Archetype findArchetype(String groupId, String artifactId, String version) {
        Stream<Archetype> archeTypes = this.archetypes.stream().filter(at -> at.getGroupId().equals(groupId) && at.getArtifactId().equals(artifactId));
        if (version != null) {
            List<Archetype> list = archeTypes.toList();
            return list.stream().filter(at -> version.equals(at.getVersion())).findFirst().orElse(list.isEmpty() ? null : list.get(0));
        }
        return archeTypes.findFirst().orElse(null);
    }

    protected void downloadArchetype(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, String repositoryUrl) {
        if (this.getContainer() == null) {
            return;
        }
        String archetypeName = String.valueOf(archetypeGroupId) + ":" + archetypeArtifactId + ":" + archetypeVersion;
        try {
            this.getContainer().run(true, true, monitor -> {
                monitor.beginTask(String.valueOf(Messages.MavenProjectWizardArchetypePage_task_downloading) + archetypeName, -1);
                try {
                    try {
                        List<ArtifactRepository> remoteRepositories;
                        IMaven maven = MavenPlugin.getMaven();
                        if (repositoryUrl.length() == 0) {
                            remoteRepositories = maven.getArtifactRepositories();
                        } else {
                            ArtifactRepository repository = maven.createArtifactRepository(String.valueOf(archetypeArtifactId) + "-repo", repositoryUrl);
                            remoteRepositories = Collections.singletonList(repository);
                        }
                        monitor.subTask(Messages.MavenProjectWizardArchetypePage_task_resolving);
                        Artifact pomArtifact = maven.resolve(archetypeGroupId, archetypeArtifactId, archetypeVersion, "pom", null, remoteRepositories, monitor);
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        File pomFile = pomArtifact.getFile();
                        if (pomFile.exists()) {
                            monitor.subTask(Messages.MavenProjectWizardArchetypePage_task_resolving2);
                            Artifact jarArtifact = maven.resolve(archetypeGroupId, archetypeArtifactId, archetypeVersion, "jar", null, remoteRepositories, monitor);
                            monitor.worked(1);
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            File jarFile = jarArtifact.getFile();
                            monitor.subTask(Messages.MavenProjectWizardArchetypePage_task_reading);
                            monitor.worked(1);
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            monitor.subTask(Messages.MavenProjectWizardArchetypePage_task_indexing);
                            Archetype archetype = new Archetype();
                            archetype.setGroupId(archetypeGroupId);
                            archetype.setArtifactId(archetypeArtifactId);
                            archetype.setVersion(archetypeVersion);
                            archetype.setRepository(repositoryUrl);
                            M2EUIPluginActivator.getDefault().getArchetypePlugin().updateLocalCatalog(archetype);
                            this.archetypesCache.clear();
                            this.loadArchetypes(archetypeGroupId, archetypeArtifactId, archetypeVersion);
                        } else {
                            Artifact pom = pomArtifact;
                            this.getShell().getDisplay().asyncExec(() -> this.setErrorMessage(NLS.bind((String)Messages.MavenProjectWizardArchetypePage_error_resolve, (Object)pom.toString())));
                        }
                    }
                    catch (InterruptedException ex1) {
                        throw ex1;
                    }
                    catch (Exception ex2) {
                        String msg = NLS.bind((String)Messages.MavenProjectWizardArchetypePage_error_resolve2, (Object)archetypeName);
                        log.error(msg, (Throwable)ex2);
                        this.getShell().getDisplay().asyncExec(() -> this.setErrorMessage(String.valueOf(msg) + "\n" + ex2.toString()));
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException ex) {
            String msg = NLS.bind((String)Messages.MavenProjectWizardArchetypePage_error_resolve2, (Object)archetypeName);
            log.error(msg, (Throwable)ex);
            this.setErrorMessage(String.valueOf(msg) + "\n" + ex.toString());
        }
    }

    protected void reloadViewer() {
        Display.getDefault().asyncExec(() -> {
            if (this.isCurrentPage()) {
                StructuredSelection sel = (StructuredSelection)this.viewer.getSelection();
                Archetype selArchetype = null;
                if (sel != null && sel.getFirstElement() != null) {
                    selArchetype = (Archetype)sel.getFirstElement();
                }
                if (selArchetype != null) {
                    this.loadArchetypes(selArchetype.getGroupId(), selArchetype.getArtifactId(), selArchetype.getVersion());
                } else {
                    this.loadArchetypes("org.apache.maven.archetypes", "maven-archetype-quickstart", "1.0");
                }
            }
        });
    }

    protected static class ArchetypeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected ArchetypeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Archetype var3_4) {
                switch (columnIndex) {
                    case 0: {
                        return archetype.getGroupId();
                    }
                    case 1: {
                        return archetype.getArtifactId();
                    }
                    case 2: {
                        return archetype.getVersion();
                    }
                }
            }
            return super.getText(element);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    protected class QuickViewerFilter
    extends ViewerFilter
    implements ModifyListener {
        private String currentFilter;

        protected QuickViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.currentFilter == null || this.currentFilter.length() == 0) {
                return true;
            }
            Archetype archetype = (Archetype)element;
            return archetype.getGroupId().toLowerCase().indexOf(this.currentFilter) > -1 || archetype.getArtifactId().toLowerCase().indexOf(this.currentFilter) > -1;
        }

        public void modifyText(ModifyEvent e) {
            this.currentFilter = MavenProjectWizardArchetypePage.this.filterText.getText().trim().toLowerCase();
            MavenProjectWizardArchetypePage.this.viewer.refresh();
        }
    }

    private class RetrievingArchetypesJob
    extends Job {
        List<Archetype> catalogArchetypes;
        private final ArchetypeCatalogFactory archetypeCatalogFactory;

        public RetrievingArchetypesJob(ArchetypeCatalogFactory catalogFactory) {
            super(Messages.wizardProjectPageArchetypeRetrievingArchetypes);
            this.archetypeCatalogFactory = catalogFactory;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.catalogArchetypes = MavenProjectWizardArchetypePage.this.getArchetypesForCatalog(this.archetypeCatalogFactory, monitor);
            }
            catch (Exception e) {
                monitor.done();
                return Status.error((String)Messages.MavenProjectWizardArchetypePage_ErrorRetrievingArchetypes, (Throwable)e);
            }
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
    }

    protected class VersionsFilter
    extends ViewerFilter
    implements SelectionListener {
        private boolean showLastVersion;
        private boolean includeSnapshots;

        public VersionsFilter(boolean showLastVersion, boolean includeSnapshots) {
            this.showLastVersion = showLastVersion;
            this.includeSnapshots = includeSnapshots;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof Archetype)) {
                return false;
            }
            Archetype archetype = (Archetype)element;
            String version = archetype.getVersion();
            if (!this.includeSnapshots && this.isSnapshotVersion(version)) {
                return false;
            }
            if (!this.showLastVersion) {
                return true;
            }
            List<ArtifactVersion> versions = MavenProjectWizardArchetypePage.this.archetypeVersions.get(MavenProjectWizardArchetypePage.getArchetypeKey(archetype));
            if (versions == null || versions.isEmpty()) {
                return false;
            }
            for (ArtifactVersion otherVersion : versions) {
                if (!this.includeSnapshots && this.isSnapshotVersion(otherVersion.toString())) continue;
                if (!otherVersion.toString().equals(version)) break;
                return true;
            }
            return false;
        }

        boolean isSnapshotVersion(String version) {
            return !M2EUIUtils.nullOrEmpty(version) && version.endsWith("SNAPSHOT");
        }

        public void widgetSelected(SelectionEvent e) {
            this.showLastVersion = MavenProjectWizardArchetypePage.this.showLastVersionButton.getSelection();
            this.includeSnapshots = MavenProjectWizardArchetypePage.this.includeShapshotsButton.getSelection();
            MavenProjectWizardArchetypePage.this.viewer.refresh();
            Archetype archetype = MavenProjectWizardArchetypePage.this.getArchetype();
            if (archetype != null) {
                MavenProjectWizardArchetypePage.this.viewer.reveal((Object)archetype);
            }
            MavenProjectWizardArchetypePage.this.viewer.getTable().setSelection(MavenProjectWizardArchetypePage.this.viewer.getTable().getSelectionIndex());
            MavenProjectWizardArchetypePage.this.viewer.getTable().setFocus();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

