/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.project.ProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.OpenMavenConsoleAction;
import org.eclipse.m2e.core.ui.internal.util.M2EUIUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IProgressConstants;

public class UpdateMavenProjectJob
extends WorkspaceJob {
    private final Collection<IProject> projects;
    private final boolean offline;
    private final boolean forceUpdateDependencies;
    private final boolean updateConfiguration;
    private final boolean cleanProjects;
    private final boolean refreshFromLocal;

    public UpdateMavenProjectJob(Collection<IProject> projects) {
        this(projects, MavenPlugin.getMavenConfiguration().isOffline(), false, true, true, true);
    }

    public UpdateMavenProjectJob(Collection<IProject> projects, boolean offline, boolean forceUpdateDependencies, boolean updateConfiguration, boolean cleanProjects, boolean refreshFromLocal) {
        super(Messages.UpdateSourcesAction_job_update_conf);
        this.projects = projects;
        this.offline = offline;
        this.forceUpdateDependencies = forceUpdateDependencies;
        this.updateConfiguration = updateConfiguration;
        this.cleanProjects = cleanProjects;
        this.refreshFromLocal = refreshFromLocal;
        this.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        ProjectConfigurationManager configurationManager = (ProjectConfigurationManager)MavenPlugin.getProjectConfigurationManager();
        this.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)new OpenMavenConsoleAction());
        MavenUpdateRequest request = new MavenUpdateRequest(this.projects, this.offline, this.forceUpdateDependencies);
        Map updateStatus = configurationManager.updateProjectConfiguration(request, this.updateConfiguration, this.cleanProjects, this.refreshFromLocal, monitor);
        LinkedHashMap<String, Throwable> errorMap = new LinkedHashMap<String, Throwable>();
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        for (Map.Entry entry : updateStatus.entrySet()) {
            if (((IStatus)entry.getValue()).isOK()) continue;
            errors.add((IStatus)entry.getValue());
            errorMap.put((String)entry.getKey(), new CoreException((IStatus)entry.getValue()));
        }
        if (errorMap.size() > 0) {
            this.handleErrors(errorMap);
        }
        Object status = Status.OK_STATUS;
        status = errors.size() == 1 ? (IStatus)errors.get(0) : new MultiStatus("org.eclipse.m2e.core.ui", -1, errors.toArray(new IStatus[errors.size()]), Messages.UpdateSourcesAction_error_cannot_update, null);
        return status;
    }

    private void handleErrors(Map<String, Throwable> updateErrors) {
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec(() -> M2EUIUtils.showErrorsForProjectsDialog(display.getActiveShell(), Messages.UpdateSourcesAction_error_title, Messages.UpdateSourcesAction_error_message, updateErrors));
        }
    }
}

