/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectUtils;
import org.eclipse.m2e.wtp.AbstractFilteringSupportMavenPlugin;
import org.eclipse.m2e.wtp.JEEPackaging;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcrPluginConfiguration
extends AbstractFilteringSupportMavenPlugin {
    private static final IProjectFacetVersion DEFAULT_APPCLIENT_FACET_VERSION = IJ2EEFacetConstants.APPLICATION_CLIENT_50;
    private static final int JEE_7_0_ID = 70;
    private static final int JEE_8_0_ID = 80;
    private static final Logger LOG = LoggerFactory.getLogger(AcrPluginConfiguration.class);
    final IMavenProjectFacade mavenProjectFacade;

    public AcrPluginConfiguration(IMavenProjectFacade facade) throws CoreException {
        MavenProject mavenProject = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
        if (JEEPackaging.APP_CLIENT != JEEPackaging.getValue(mavenProject.getPackaging())) {
            throw new IllegalArgumentException(Messages.AcrPluginConfiguration_Error_Project_Not_appclient);
        }
        this.mavenProjectFacade = facade;
        Plugin plugin = mavenProject.getPlugin("org.apache.maven.plugins:maven-acr-plugin");
        if (plugin != null) {
            this.setConfiguration((Xpp3Dom)plugin.getConfiguration());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProjectFacetVersion getFacetVersion() {
        IFile applicationClientXml = this.getApplicationClientXml();
        if (applicationClientXml != null && applicationClientXml.isAccessible()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream is = applicationClientXml.getContents();){
                    JavaEEQuickPeek jqp = new JavaEEQuickPeek(is);
                    switch (jqp.getVersion()) {
                        case 12: {
                            return IJ2EEFacetConstants.APPLICATION_CLIENT_12;
                        }
                        case 13: {
                            return IJ2EEFacetConstants.APPLICATION_CLIENT_13;
                        }
                        case 14: {
                            return IJ2EEFacetConstants.APPLICATION_CLIENT_14;
                        }
                        case 50: {
                            return IJ2EEFacetConstants.APPLICATION_CLIENT_50;
                        }
                        case 60: {
                            return IJ2EEFacetConstants.APPLICATION_CLIENT_60;
                        }
                        case 70: {
                            return IJ2EEFacetConstants.APPLICATION_CLIENT_FACET.getVersion("7.0");
                        }
                        case 80: {
                            return IJ2EEFacetConstants.APPLICATION_CLIENT_FACET.getVersion("8.0");
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException | CoreException throwable) {
                // empty catch block
            }
        }
        IProject project = this.mavenProjectFacade.getProject();
        try {
            IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
            if (fProject != null && fProject.hasProjectFacet(IJ2EEFacetConstants.APPLICATION_CLIENT_FACET)) {
                return fProject.getProjectFacetVersion(IJ2EEFacetConstants.APPLICATION_CLIENT_FACET);
            }
        }
        catch (Exception e) {
            LOG.warn(NLS.bind((String)Messages.Error_Reading_Project_Facet, (Object)project.getName()), (Throwable)e);
        }
        if (!WTPProjectsUtil.hasInClassPath(this.mavenProjectFacade.getProject(), "javax.servlet.annotation.WebServlet")) return DEFAULT_APPCLIENT_FACET_VERSION;
        return IJ2EEFacetConstants.APPLICATION_CLIENT_60;
    }

    public IFile getApplicationClientXml() {
        IProject project = this.mavenProjectFacade.getProject();
        String contentDir = null;
        IPath[] iPathArray = this.mavenProjectFacade.getResourceLocations();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            contentDir = String.valueOf(path.toPortableString()) + "/META-INF";
            IFile applicationClientXml = project.getFolder(contentDir).getFile("application-client.xml");
            if (applicationClientXml.exists()) {
                return applicationClientXml;
            }
            ++n2;
        }
        return null;
    }

    public String getContentDirectory(IProject project) {
        IPath[] resources = MavenProjectUtils.getResourceLocations((IProject)project, (List)this.mavenProjectFacade.getMavenProject().getResources());
        return resources[0].toPortableString();
    }

    @Override
    protected String getFilteringAttribute() {
        return "filterDeploymentDescriptor";
    }
}

