/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.jaxrs.java;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.junit.Test;

public class JaxRsApplicationPathCodeLensTest
extends BasePropertiesManagerTest {
    @Test
    public void urlCodeLensApplicationPath() throws Exception {
        IJavaProject javaProject = JaxRsApplicationPathCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_applicationpath);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        params.setCheckServerAvailable(false);
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/ApplicationPathResource.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        JaxRsApplicationPathCodeLensTest.saveFile("org/acme/MyApplication.java", "package org.acme;\r\nimport javax.ws.rs.ApplicationPath;\r\nimport javax.ws.rs.core.Application;\r\n@ApplicationPath(\"/api\")\r\npublic class MyApplication extends Application {}\r\n", javaProject, true);
        JaxRsApplicationPathCodeLensTest.assertCodeLenses(8080, params, utils, "/api/path");
    }

    @Test
    public void urlCodeLensApplicationPathNoSlash() throws Exception {
        IJavaProject javaProject = JaxRsApplicationPathCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_applicationpath);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        params.setCheckServerAvailable(false);
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/ApplicationPathResource.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        JaxRsApplicationPathCodeLensTest.saveFile("org/acme/MyApplication.java", "package org.acme;\r\nimport javax.ws.rs.ApplicationPath;\r\nimport javax.ws.rs.core.Application;\r\n@ApplicationPath(\"api\")\r\npublic class MyApplication extends Application {}\r\n", javaProject, true);
        JaxRsApplicationPathCodeLensTest.assertCodeLenses(8080, params, utils, "/api/path");
    }

    @Test
    public void urlCodeLensApplicationPathChange() throws Exception {
        IJavaProject javaProject = JaxRsApplicationPathCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_applicationpath);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        params.setCheckServerAvailable(false);
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/ApplicationPathResource.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        JaxRsApplicationPathCodeLensTest.saveFile("org/acme/MyApplication.java", "package org.acme;\r\nimport javax.ws.rs.ApplicationPath;\r\nimport javax.ws.rs.core.Application;\r\n@ApplicationPath(\"/api\")\r\npublic class MyApplication extends Application {}\r\n", javaProject, true);
        JaxRsApplicationPathCodeLensTest.assertCodeLenses(8080, params, utils, "/api/path");
        JaxRsApplicationPathCodeLensTest.saveFile("org/acme/MyApplication.java", "package org.acme;\r\nimport javax.ws.rs.ApplicationPath;\r\nimport javax.ws.rs.core.Application;\r\n@ApplicationPath(\"/ipa\")\r\npublic class MyApplication extends Application {}\r\n", javaProject, true);
        JaxRsApplicationPathCodeLensTest.assertCodeLenses(8080, params, utils, "/ipa/path");
    }

    @Test
    public void openLibertyJakarta() throws Exception {
        IJavaProject javaProject = JaxRsApplicationPathCodeLensTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.open_liberty);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams();
        params.setCheckServerAvailable(false);
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/com/demo/rest/MyResource.java"));
        params.setUri(javaFile.getLocation().toFile().toURI().toString());
        params.setUrlCodeLensEnabled(true);
        MicroProfileForJavaAssert.assertCodeLens(params, utils, MicroProfileForJavaAssert.cl("http://localhost:8080/api/api/resource", "", MicroProfileForJavaAssert.r(13, 5, 5)));
    }

    private static void assertCodeLenses(int port, MicroProfileJavaCodeLensParams params, IJDTUtils utils, String actualEndpoint) throws JavaModelException {
        MicroProfileForJavaAssert.assertCodeLens(params, utils, MicroProfileForJavaAssert.cl("http://localhost:" + port + actualEndpoint, "", MicroProfileForJavaAssert.r(12, 35, 35)));
    }
}

