/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.di;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.internal.di.ErrorCode;

public class DependencyInjectionDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IType[] alltypes;
        String uri = context.getUri();
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        IType[] iTypeArray = alltypes = unit.getAllTypes();
        int n = alltypes.length;
        int n2 = 0;
        while (n2 < n) {
            Range allMethods;
            Range range;
            IField[] allFields;
            IType type = iTypeArray[n2];
            IField[] iFieldArray = allFields = type.getFields();
            int n3 = allFields.length;
            int n4 = 0;
            while (n4 < n3) {
                IField field = iFieldArray[n4];
                if (Flags.isFinal((int)field.getFlags()) && this.containsAnnotation(type, field.getAnnotations(), "jakarta.inject.Inject")) {
                    String msg = Messages.getMessage("InjectNoFinalField", new Object[0]);
                    range = PositionUtils.toNameRange(field, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, msg, range, "jakarta-di", ErrorCode.InvalidInjectAnnotationOnFinalField, DiagnosticSeverity.Error));
                }
                ++n4;
            }
            ArrayList<IMethod> injectedConstructors = new ArrayList<IMethod>();
            range = allMethods = type.getMethods();
            int n5 = ((IMethod[])range).length;
            int n6 = 0;
            while (n6 < n5) {
                IMethod method = range[n6];
                int methodFlag = method.getFlags();
                boolean isFinal = Flags.isFinal((int)methodFlag);
                boolean isAbstract = Flags.isAbstract((int)methodFlag);
                boolean isStatic = Flags.isStatic((int)methodFlag);
                boolean isGeneric = method.getTypeParameters().length != 0;
                Range range2 = PositionUtils.toNameRange(method, context.getUtils());
                if (this.containsAnnotation(type, method.getAnnotations(), "jakarta.inject.Inject")) {
                    String msg;
                    if (DiagnosticUtils.isConstructorMethod(method)) {
                        injectedConstructors.add(method);
                    }
                    if (isFinal) {
                        msg = Messages.getMessage("InjectNoFinalMethod", new Object[0]);
                        diagnostics.add(context.createDiagnostic(uri, msg, range2, "jakarta-di", ErrorCode.InvalidInjectAnnotationOnFinalMethod, DiagnosticSeverity.Error));
                    }
                    if (isAbstract) {
                        msg = Messages.getMessage("InjectNoAbstractMethod", new Object[0]);
                        diagnostics.add(context.createDiagnostic(uri, msg, range2, "jakarta-di", ErrorCode.InvalidInjectAnnotationOnAbstractMethod, DiagnosticSeverity.Error));
                    }
                    if (isStatic) {
                        msg = Messages.getMessage("InjectNoStaticMethod", new Object[0]);
                        diagnostics.add(context.createDiagnostic(uri, msg, range2, "jakarta-di", ErrorCode.InvalidInjectAnnotationOnStaticMethod, DiagnosticSeverity.Error));
                    }
                    if (isGeneric) {
                        msg = Messages.getMessage("InjectNoGenericMethod", new Object[0]);
                        diagnostics.add(context.createDiagnostic(uri, msg, range2, "jakarta-di", ErrorCode.InvalidInjectAnnotationOnGenericMethod, DiagnosticSeverity.Error));
                    }
                }
                ++n6;
            }
            if (injectedConstructors.size() > 1) {
                String msg = Messages.getMessage("InjectMoreThanOneConstructor", new Object[0]);
                for (IMethod method : injectedConstructors) {
                    range = PositionUtils.toNameRange(method, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, msg, range, "jakarta-di", ErrorCode.InvalidInjectAnnotationOnMultipleConstructors, DiagnosticSeverity.Error));
                }
            }
            ++n2;
        }
        return diagnostics;
    }

    private boolean containsAnnotation(IType type, IAnnotation[] annotations, String annotationFQName) {
        return Stream.of(annotations).anyMatch(annotation -> {
            try {
                return DiagnosticUtils.isMatchedJavaElement(type, annotation.getElementName(), annotationFQName);
            }
            catch (JavaModelException e) {
                JakartaCorePlugin.logException("Cannot validate annotations", e);
                return false;
            }
        });
    }
}

