/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.references;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4j.Location;
import org.eclipse.search.ui.text.Match;

public class URIMatch
extends Match {
    public final Location location;

    public static URIMatch create(Location location) throws BadLocationException, URISyntaxException {
        URI uri = new URI(location.getUri());
        IDocument doc = LSPEclipseUtils.getDocument(uri);
        int offset = LSPEclipseUtils.toOffset(location.getRange().getStart(), doc);
        int length = LSPEclipseUtils.toOffset(location.getRange().getEnd(), doc) - LSPEclipseUtils.toOffset(location.getRange().getStart(), doc);
        return new URIMatch(location, uri, offset, length);
    }

    protected URIMatch(Location location, URI uri, int offset, int length) {
        super((Object)uri, offset, length);
        this.location = location;
    }
}

