/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.folding;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.test.utils.AllCleanRule;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class FoldingTest {
    private static final String CONTENT = "import\nimport\nimport\nvisible\n";
    @Rule
    public final AllCleanRule clear = new AllCleanRule();

    @Test
    public void testImportsFoldedByDefaultEnabled() throws CoreException {
        this.collapseImports(true);
        IEditorPart editor = this.createEditor();
        DisplayHelper.waitAndAssertCondition((Display)editor.getSite().getShell().getDisplay(), () -> Assert.assertEquals((Object)"import\nvisible", (Object)((StyledText)editor.getAdapter(Control.class)).getText().trim()));
    }

    @Test
    public void testImportsFoldedByDefaultDisabled() throws CoreException {
        this.collapseImports(false);
        IEditorPart editor = this.createEditor();
        DisplayHelper.waitAndAssertCondition((Display)editor.getSite().getShell().getDisplay(), () -> Assert.assertEquals((Object)CONTENT, (Object)((StyledText)editor.getAdapter(Control.class)).getText()));
    }

    private IEditorPart createEditor() throws CoreException, PartInitException {
        IFile file = TestUtils.createUniqueTestFile(null, CONTENT);
        FoldingRange foldingRange = new FoldingRange(0, 2);
        foldingRange.setKind("imports");
        MockLanguageServer.INSTANCE.setFoldingRanges(List.of(foldingRange));
        IEditorPart editor = TestUtils.openEditor(file);
        return editor;
    }

    private void collapseImports(boolean collapseImports) {
        IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
        store.setValue("foldingReconcilingStrategy.collapseImports", true);
    }
}

