/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.Random;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.outline.SymbolsLabelProvider;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class WorkspaceSymbolQuickAccessElement
extends QuickAccessElement {
    private static final SymbolsLabelProvider LABEL_PROVIDER = new SymbolsLabelProvider(false, false);
    private static final Random randomNumbers = new Random();
    private final WorkspaceSymbol symbol;
    private final int idExtension;

    public WorkspaceSymbolQuickAccessElement(WorkspaceSymbol symbol) {
        this.symbol = symbol;
        this.idExtension = randomNumbers.nextInt();
    }

    public String getLabel() {
        return LABEL_PROVIDER.getText(this.symbol);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)LABEL_PROVIDER.getImage(this.symbol));
    }

    public String getId() {
        Location location = (Location)this.symbol.getLocation().map(Function.identity(), symbol -> new Location(symbol.getUri(), null));
        @Nullable Range range = location.getRange();
        return String.valueOf(this.symbol.getName()) + '@' + location.getUri() + (range != null ? Integer.valueOf(91 + range.getStart().getLine() + 44 + range.getStart().getCharacter() + 58 + range.getEnd().getLine() + 44 + range.getEnd().getCharacter() + 93) : "") + ',' + this.idExtension;
    }

    public void execute() {
        LSPEclipseUtils.openInEditor((Location)this.symbol.getLocation().map(Function.identity(), symbol -> new Location(symbol.getUri(), null)));
    }
}

