/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.AbstractReconciler;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.outline.CNFOutlinePage;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class LSSymbolsContentProvider
implements ICommonContentProvider,
ITreeContentProvider {
    public static final Object COMPUTING = new Object();
    private TreeViewer viewer;
    private Throwable lastError;
    private CNFOutlinePage.OutlineInfo outlineInfo;
    private SymbolsModel symbolsModel = new SymbolsModel();
    private CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> symbols;
    private final boolean refreshOnResourceChanged;
    private IOutlineUpdater outlineUpdater;

    public LSSymbolsContentProvider() {
        this(false);
    }

    public LSSymbolsContentProvider(boolean refreshOnResourceChanged) {
        this.refreshOnResourceChanged = refreshOnResourceChanged;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        this.outlineInfo = (CNFOutlinePage.OutlineInfo)newInput;
        this.symbolsModel.setFile((IFile)LSPEclipseUtils.findResourceFor(LSPEclipseUtils.toUri(this.outlineInfo.document).toString()));
        if (this.outlineUpdater != null) {
            this.outlineUpdater.uninstall();
        }
        this.outlineUpdater = this.createOutlineUpdater();
        this.outlineUpdater.install();
    }

    private IOutlineUpdater createOutlineUpdater() {
        if (this.refreshOnResourceChanged) {
            IResource resource = LSPEclipseUtils.findResourceFor(LSPEclipseUtils.toUri(this.outlineInfo.document).toString());
            return new ResourceChangeOutlineUpdater(resource);
        }
        ITextViewer textViewer = this.outlineInfo.textEditor == null ? null : (ITextViewer)this.outlineInfo.textEditor.getAdapter(ITextOperationTarget.class);
        return textViewer == null ? new DocumentChangedOutlineUpdater(this.outlineInfo.document) : new ReconcilerOutlineUpdater(textViewer);
    }

    public Object[] getElements(Object inputElement) {
        if (this.symbols != null && !this.symbols.isDone()) {
            return new Object[]{COMPUTING};
        }
        if (this.lastError != null) {
            return new Object[]{this.lastError};
        }
        return this.symbolsModel.getElements();
    }

    public Object[] getChildren(Object parentElement) {
        return this.symbolsModel.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.symbolsModel.getParent(element);
    }

    public boolean hasChildren(Object parentElement) {
        Object[] children = this.symbolsModel.getChildren(parentElement);
        return children != null && children.length > 0;
    }

    private void refreshTreeContentFromLS() {
        if (this.symbols != null && !this.symbols.isDone()) {
            this.symbols.cancel(true);
        }
        this.lastError = null;
        URI documentUri = LSPEclipseUtils.toUri(this.outlineInfo.document);
        if (documentUri == null) {
            return;
        }
        DocumentSymbolParams params = new DocumentSymbolParams(new TextDocumentIdentifier(documentUri.toString()));
        this.symbols = this.outlineInfo.languageServer.getTextDocumentService().documentSymbol(params);
        this.symbols.thenAcceptAsync(t -> {
            this.symbolsModel.update((List<Either<SymbolInformation, DocumentSymbol>>)t);
            this.viewer.getControl().getDisplay().asyncExec(() -> this.viewer.refresh());
            if (!InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").getBoolean("org.eclipse.lsp4e.outline.linkWithEditor", true)) {
                return;
            }
            Display.getDefault().asyncExec(() -> {
                IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (editorPart instanceof AbstractTextEditor) {
                    ITextSelection selection = (ITextSelection)((AbstractTextEditor)editorPart).getSelectionProvider().getSelection();
                    CNFOutlinePage.refreshTreeSelection(this.viewer, selection.getOffset(), this.outlineInfo.document);
                }
            });
        });
        this.symbols.exceptionally(ex -> {
            this.lastError = ex;
            this.viewer.getControl().getDisplay().asyncExec(() -> this.viewer.refresh());
            return Collections.emptyList();
        });
    }

    public void dispose() {
        if (this.outlineUpdater != null) {
            this.outlineUpdater.uninstall();
        }
        super.dispose();
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    class DocumentChangedOutlineUpdater
    implements IDocumentListener,
    IOutlineUpdater {
        private final IDocument document;

        @Override
        public void install() {
            this.document.addDocumentListener((IDocumentListener)this);
            LSSymbolsContentProvider.this.refreshTreeContentFromLS();
        }

        @Override
        public void uninstall() {
            this.document.removeDocumentListener((IDocumentListener)this);
        }

        DocumentChangedOutlineUpdater(IDocument document) {
            this.document = document;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            LSSymbolsContentProvider.this.refreshTreeContentFromLS();
        }
    }

    static interface IOutlineUpdater {
        public void install();

        public void uninstall();
    }

    class ReconcilerOutlineUpdater
    extends AbstractReconciler
    implements IOutlineUpdater {
        private final ITextViewer textViewer;

        ReconcilerOutlineUpdater(ITextViewer textViewer) {
            this.textViewer = textViewer;
            super.setIsIncrementalReconciler(false);
            super.setIsAllowedToModifyDocument(false);
        }

        @Override
        public void install() {
            super.install(this.textViewer);
        }

        protected void initialProcess() {
            LSSymbolsContentProvider.this.refreshTreeContentFromLS();
        }

        protected void process(DirtyRegion dirtyRegion) {
            LSSymbolsContentProvider.this.refreshTreeContentFromLS();
        }

        protected void reconcilerDocumentChanged(IDocument newDocument) {
        }

        public IReconcilingStrategy getReconcilingStrategy(String contentType) {
            return null;
        }
    }

    class ResourceChangeOutlineUpdater
    implements IResourceChangeListener,
    IOutlineUpdater {
        private final IResource resource;

        public ResourceChangeOutlineUpdater(IResource resource) {
            this.resource = resource;
        }

        @Override
        public void install() {
            this.resource.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }

        @Override
        public void uninstall() {
            this.resource.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if ((event.getDelta().getFlags() ^ 0x20000) != 0) {
                try {
                    event.getDelta().accept(delta -> {
                        if (delta.getResource().equals((Object)this.resource)) {
                            LSSymbolsContentProvider.this.viewer.getControl().getDisplay().asyncExec(() -> {
                                if (!LSSymbolsContentProvider.this.viewer.getControl().isDisposed() && LSSymbolsContentProvider.this.viewer instanceof StructuredViewer) {
                                    LSSymbolsContentProvider.this.viewer.refresh(true);
                                }
                            });
                        }
                        return delta.getResource().getFullPath().isPrefixOf(this.resource.getFullPath());
                    });
                }
                catch (CoreException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
    }
}

